/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.render.particle;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.teamlapen.vampirism.util.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import org.lwjgl.opengl.GL11;

public class ParticleHandler {
    private static ParticleHandler instance;
    private static final String TAG = "ParticleHandler";
    private List[] fxlayers = new List[]{new ArrayList()};
    private int dimId;
    private final ResourceLocation particleTextures = new ResourceLocation("vampirism:textures/particles.png");

    private ParticleHandler() {
        this.dimId = Integer.MIN_VALUE;
    }

    public void addEffect(EntityFX effect) {
        int dim = effect.field_70170_p.field_73011_w.field_76574_g;
        if (dim != this.dimId) {
            this.dimId = dim;
            Logger.w(TAG, "Failed to add %s. Dimension %d is not activated", effect, dim);
            return;
        }
        int la = effect.func_70537_b();
        if (la > this.fxlayers.length) {
            Logger.w(TAG, "Failed to add %s. There is no %d layer", effect, la);
            return;
        }
        if (this.fxlayers[la].size() > 2000) {
            this.fxlayers[la].remove(0);
        }
        this.fxlayers[la].add(effect);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void renderEffects(RenderWorldLastEvent event) {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        float parTicks = event.partialTicks;
        TextureManager renderer = Minecraft.func_71410_x().field_71446_o;
        float f1 = ActiveRenderInfo.field_74588_d;
        float f2 = ActiveRenderInfo.field_74586_f;
        float f3 = ActiveRenderInfo.field_74587_g;
        float f4 = ActiveRenderInfo.field_74596_h;
        float f5 = ActiveRenderInfo.field_74589_e;
        EntityFX.field_70556_an = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)parTicks;
        EntityFX.field_70554_ao = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)parTicks;
        EntityFX.field_70555_ap = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)parTicks;
        for (int k = 0; k < this.fxlayers.length; ++k) {
            if (this.fxlayers[k].isEmpty()) continue;
            switch (k) {
                default: 
            }
            renderer.func_110577_a(this.particleTextures);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDepthMask((boolean)false);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glAlphaFunc((int)516, (float)0.003921569f);
            Tessellator tessellator = Tessellator.field_78398_a;
            tessellator.func_78382_b();
            for (int j = 0; j < this.fxlayers[k].size(); ++j) {
                final EntityFX entityfx = (EntityFX)this.fxlayers[k].get(j);
                if (entityfx == null) continue;
                tessellator.func_78380_c(entityfx.func_70070_b(parTicks));
                try {
                    entityfx.func_70539_a(tessellator, parTicks, f1, f5, f2, f3, f4);
                    continue;
                }
                catch (Throwable throwable) {
                    CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Rendering Particle");
                    CrashReportCategory crashreportcategory = crashreport.func_85058_a("Particle being rendered");
                    crashreportcategory.func_71500_a("Particle", new Callable(){
                        private static final String __OBFID = "CL_00000918";

                        public String call() {
                            return entityfx.toString();
                        }
                    });
                    throw new ReportedException(crashreport);
                }
            }
            tessellator.func_78381_a();
            GL11.glDisable((int)3042);
            GL11.glDepthMask((boolean)true);
            GL11.glAlphaFunc((int)516, (float)0.1f);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void updateEffects(TickEvent.ClientTickEvent event) {
        if (event.side == Side.SERVER || event.phase == TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e == null) {
            return;
        }
        int dim = mc.field_71441_e.field_73011_w.field_76574_g;
        if (dim != this.dimId) {
            this.dimId = dim;
            this.clearEffects();
        }
        for (int i = 0; i < this.fxlayers.length; ++i) {
            for (int j = 0; j < this.fxlayers[i].size(); ++j) {
                final EntityFX entityfx = (EntityFX)this.fxlayers[i].get(j);
                try {
                    if (entityfx != null) {
                        entityfx.func_70071_h_();
                    }
                }
                catch (Throwable throwable) {
                    CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Ticking Particle");
                    CrashReportCategory crashreportcategory = crashreport.func_85058_a("Particle being ticked");
                    crashreportcategory.func_71500_a("Particle", new Callable(){
                        private static final String __OBFID = "CL_00000916";

                        public String call() {
                            return entityfx.toString();
                        }
                    });
                    throw new ReportedException(crashreport);
                }
                if (entityfx != null && !entityfx.field_70128_L) continue;
                this.fxlayers[i].remove(j--);
            }
        }
    }

    public static ParticleHandler instance() {
        if (instance == null) {
            instance = new ParticleHandler();
        }
        return instance;
    }

    public void clearEffects() {
        for (List l : this.fxlayers) {
            l.clear();
        }
    }
}

