/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.teamlapen.vampirism.entity.VampireMob;
import de.teamlapen.vampirism.util.Logger;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class EntityDeadMob
extends Entity {
    private static final int MAX_TICKS = 1200;
    public static List<String> mobs = new ArrayList<String>();
    private int health;
    private String TAG = "EntityDeadMob";
    private final int WATCHER_TYPE_ID = 10;

    public static boolean canBecomeDeadMob(EntityCreature entity) {
        if (entity != null && VampireMob.get(entity).isMinion()) {
            return false;
        }
        return mobs.contains(EntityList.func_75621_b((Entity)entity));
    }

    public static Entity createFromEntity(EntityCreature entity) {
        EntityDeadMob e = (EntityDeadMob)EntityList.func_75620_a((String)"vampirism.dead_mob", (World)entity.field_70170_p);
        e.func_82149_j((Entity)entity);
        e.setDeadMob(EntityList.func_75621_b((Entity)entity));
        return e;
    }

    public EntityDeadMob(World p_i1582_1_) {
        super(p_i1582_1_);
        this.func_70105_a(0.98f, 0.4f);
        this.field_70180_af.func_75682_a(10, (Object)0);
        this.health = 5;
    }

    public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_) {
        if (this.func_85032_ar()) {
            return false;
        }
        if (!this.field_70128_L && !this.field_70170_p.field_72995_K) {
            this.health -= Math.round(p_70097_2_);
            if (this.health <= 0) {
                this.func_70106_y();
            }
        }
        return true;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public EntityCreature convertToMob() {
        EntityCreature e = (EntityCreature)EntityList.func_75620_a((String)this.getDeadMob(), (World)this.field_70170_p);
        if (e != null) {
            e.func_82149_j((Entity)this);
            e.func_70606_j(e.func_110138_aP() * 2.0f / 3.0f);
            this.field_70170_p.func_72838_d((Entity)e);
        } else {
            Logger.w(this.TAG, "Could not create entity: " + this.getDeadMob(), new Object[0]);
        }
        this.func_70106_y();
        return e;
    }

    protected void func_70088_a() {
    }

    public String getDeadMob() {
        int i = this.getDeadMobId();
        if (i >= mobs.size() || i < 0) {
            Logger.w(this.TAG, "Invalid Mob ID " + i, new Object[0]);
            this.setDeadMobId(0);
            return "Zombie";
        }
        return mobs.get(i);
    }

    public int getDeadMobId() {
        return this.field_70180_af.func_75679_c(10);
    }

    @SideOnly(value=Side.CLIENT)
    public float func_70053_R() {
        return 0.0f;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa > 1200) {
            this.func_70106_y();
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.field_70181_x -= (double)0.04f;
        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.field_70159_w *= (double)0.98f;
        this.field_70181_x *= (double)0.98f;
        this.field_70179_y *= (double)0.98f;
        if (this.field_70122_E) {
            this.field_70159_w *= 0.1;
            this.field_70179_y *= 0.1;
            this.field_70181_x *= 0.1;
        }
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.setDeadMobId(nbt.func_74762_e("entity_id"));
    }

    public void setDeadMob(String s) {
        for (int i = 0; i < mobs.size(); ++i) {
            if (!mobs.get(i).equals(s)) continue;
            this.setDeadMobId(i);
            return;
        }
        Logger.w(this.TAG, "Did not find an id for " + s, new Object[0]);
    }

    public void setDeadMobId(int id) {
        if (id >= 0 && id < mobs.size()) {
            this.field_70180_af.func_75692_b(10, (Object)id);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldRenderSkull() {
        return this.getDeadMobId() == 0 || this.getDeadMobId() == 1;
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74768_a("entity_id", this.getDeadMobId());
    }

    static {
        mobs.add("Zombie");
        mobs.add("Skeleton");
    }
}

