/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity;

import de.teamlapen.vampirism.ModItems;
import de.teamlapen.vampirism.entity.EntityDefaultVampireWithMinion;
import de.teamlapen.vampirism.entity.ai.VampireAIFleeGarlic;
import de.teamlapen.vampirism.entity.minions.IMinion;
import de.teamlapen.vampirism.entity.player.VampirePlayer;
import de.teamlapen.vampirism.generation.castle.CastlePositionData;
import de.teamlapen.vampirism.network.ISyncable;
import de.teamlapen.vampirism.network.UpdateEntityPacket;
import de.teamlapen.vampirism.util.BALANCE;
import de.teamlapen.vampirism.util.DifficultyCalculator;
import de.teamlapen.vampirism.util.Helper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class EntityVampireBaron
extends EntityDefaultVampireWithMinion
implements ISyncable,
DifficultyCalculator.IAdjustableLevel {
    private static final int MAX_LEVEL = 5;
    protected int level = 0;
    private boolean prevAttacking = false;

    public EntityVampireBaron(World par1World) {
        super(par1World);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new VampireAIFleeGarlic(this, (double)0.9f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.2));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityVampireBaron.class, 1.0, false));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, false));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVampireBaron.class, 5, false));
        this.resitsGarlic = 1;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.applyEntityAttributes(false);
    }

    protected void applyEntityAttributes(boolean aggressive) {
        if (aggressive) {
            this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(20.0);
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(BALANCE.MOBPROP.VAMPIRE_LORD_MOVEMENT_SPEED * Math.pow((BALANCE.MOBPROP.VAMPIRE_LORD_IMPROVEMENT_PER_LEVEL - 1.0) / 3.0 + 1.0, this.level - 1));
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(5.0);
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(BALANCE.MOBPROP.VAMPIRE_LORD_MOVEMENT_SPEED * Math.pow(BALANCE.MOBPROP.VAMPIRE_LORD_IMPROVEMENT_PER_LEVEL, this.level - 1) / 3.0);
        }
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(BALANCE.MOBPROP.VAMPIRE_LORD_MAX_HEALTH * Math.pow(BALANCE.MOBPROP.VAMPIRE_LORD_IMPROVEMENT_PER_LEVEL, this.level - 1));
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(BALANCE.MOBPROP.VAMPIRE_LORD_ATTACK_DAMAGE * Math.pow(BALANCE.MOBPROP.VAMPIRE_LORD_IMPROVEMENT_PER_LEVEL, this.level - 1));
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        boolean flag = super.func_70652_k(entity);
        if (flag && entity instanceof EntityLivingBase) {
            float tm = 1.0f;
            int mr = 1;
            if (entity instanceof EntityPlayer) {
                float pld = (float)this.getLevel() - (float)VampirePlayer.get((EntityPlayer)entity).getLevel() / 3.0f;
                tm = pld + 1.0f;
                mr = pld < 1.5f ? 1 : (pld < 3.0f ? 2 : 3);
            }
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, (int)(200.0f * tm), this.field_70146_Z.nextInt(mr) + 1));
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, (int)(100.0f * tm), this.field_70146_Z.nextInt(mr) + 1));
        }
        return flag;
    }

    public boolean func_94059_bO() {
        return true;
    }

    public String func_70005_c_() {
        return super.func_70005_c_() + " " + StatCollector.func_74838_a((String)"text.vampirism.entity_level") + " " + this.level;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    public int func_82145_z() {
        return 500;
    }

    @Override
    public int getMaxLevel() {
        return 5;
    }

    @Override
    public void loadUpdateFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("level")) {
            this.level = nbt.func_74762_e("level");
        }
    }

    public void func_70645_a(DamageSource s) {
        super.func_70645_a(s);
        if (this.field_70718_bc > 0 && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
            if (this.level > 0 && this.level < 6) {
                this.func_70099_a(new ItemStack((Item)ModItems.pureBlood, 1, this.level - 1), 0.3f);
            } else if (this.level > 5) {
                this.func_70099_a(new ItemStack((Item)ModItems.pureBlood, 1, 4), 0.3f);
            }
        }
    }

    @Override
    public void func_70636_d() {
        if (!this.prevAttacking && this.func_70638_az() != null) {
            this.prevAttacking = true;
            this.applyEntityAttributes(true);
        }
        if (this.prevAttacking && this.func_70638_az() == null) {
            this.prevAttacking = false;
            this.applyEntityAttributes(false);
        }
        if (!this.field_70170_p.field_72995_K && this.shouldSpawnMinion()) {
            int i = 0;
            if (this.field_70718_bc > 0) {
                i = this.field_70146_Z.nextInt(3);
            }
            IMinion m = null;
            if (i == 1) {
                EntityLiving e = (EntityLiving)EntityList.func_75620_a((String)"vampirism.vampireMinionS", (World)this.field_70170_p);
                e.func_82149_j((Entity)this);
                this.field_70170_p.func_72838_d((Entity)e);
                m = (IMinion)e;
            } else if (i == 2 && this.func_70638_az() != null) {
                m = (IMinion)Helper.spawnEntityBehindEntity(this.func_70638_az(), "vampirism.vampireMinionS");
            }
            if (m == null) {
                m = (IMinion)Helper.spawnEntityInWorld(this.field_70170_p, this.field_70121_D.func_72314_b(19.0, 4.0, 19.0), "vampirism.vampireMinionS", 3);
            }
            if (m != null) {
                m.setLord(this);
            }
        }
        if (!this.field_70170_p.field_72995_K && this.isGettingSundamage() && this.field_70170_p.func_72937_j(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v))) {
            this.teleportAway();
        }
        super.func_70636_d();
    }

    public void func_70074_a(EntityLivingBase entity) {
        super.func_70074_a(entity);
        if (entity instanceof EntityVampireBaron) {
            this.func_70606_j(this.func_110138_aP());
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.loadUpdateFromNBT(nbt);
    }

    @Override
    public void setLevel(int level) {
        this.setLevel(level, false);
    }

    public void setLevel(int l, boolean sync) {
        if (l > 0 && l != this.level) {
            this.level = l;
            float hp = this.func_110143_aJ() / this.func_110138_aP();
            this.applyEntityAttributes(false);
            this.func_70606_j(this.func_110138_aP() * hp);
            if (sync && !this.field_70170_p.field_72995_K) {
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74768_a("level", this.level);
                Helper.sendPacketToPlayersAround(new UpdateEntityPacket((Entity)this, nbt), (Entity)this);
            }
        }
    }

    protected boolean shouldSpawnMinion() {
        if (this.field_70173_aa % 40 == 0) {
            int count = this.getMinionHandler().getMinionCount();
            if (count < this.level + 1) {
                return true;
            }
            if (this.field_70718_bc > 0 && count < 2 + this.level) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int suggestLevel(DifficultyCalculator.Difficulty d) {
        int avg = Math.round((float)(d.avgLevel - 4) / 2.0f);
        int max = Math.round((float)(d.maxLevel - 4) / 2.0f);
        int min = Math.round((float)(d.minLevel - 4) / 2.0f);
        switch (this.field_70146_Z.nextInt(6)) {
            case 0: {
                return min;
            }
            case 1: {
                return max + 1;
            }
            case 2: {
                return avg;
            }
            case 3: {
                return avg + 1;
            }
        }
        return this.field_70146_Z.nextInt(max + 2 - min) + min;
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("level", this.level);
    }

    @Override
    public void writeFullUpdateToNBT(NBTTagCompound nbt) {
        this.func_70014_b(nbt);
    }

    @Override
    public boolean func_70601_bi() {
        int i = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b);
        if (i < 60) {
            return false;
        }
        CastlePositionData data = CastlePositionData.get(this.field_70170_p);
        if (data.isPosAt(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70161_v))) {
            return false;
        }
        return super.func_70601_bi();
    }

    @Override
    public int getMaxMinionCount() {
        return 100;
    }
}

