/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.teamlapen.vampirism.Configs;
import de.teamlapen.vampirism.ModPotion;
import de.teamlapen.vampirism.entity.ai.VanillaAIModifier;
import de.teamlapen.vampirism.entity.convertible.BiteableEntry;
import de.teamlapen.vampirism.entity.convertible.BiteableRegistry;
import de.teamlapen.vampirism.entity.convertible.EntityConvertedCreature;
import de.teamlapen.vampirism.entity.minions.DefendLordCommand;
import de.teamlapen.vampirism.entity.minions.IMinion;
import de.teamlapen.vampirism.entity.minions.IMinionCommand;
import de.teamlapen.vampirism.entity.minions.IMinionLord;
import de.teamlapen.vampirism.entity.minions.JustFollowCommand;
import de.teamlapen.vampirism.entity.player.VampirePlayer;
import de.teamlapen.vampirism.network.UpdateEntityPacket;
import de.teamlapen.vampirism.util.BALANCE;
import de.teamlapen.vampirism.util.Helper;
import de.teamlapen.vampirism.util.Logger;
import de.teamlapen.vampirism.villages.VillageVampire;
import de.teamlapen.vampirism.villages.VillageVampireData;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class VampireMob
implements UpdateEntityPacket.ISyncableExtendedProperties,
IMinion {
    public static final String EXT_PROP_NAME = "VampireMob";
    private static final String TAG = "VampireMob";
    private final EntityCreature entity;
    private final String KEY_TYPE = "type";
    private final String KEY_BLOOD = "blood";
    private int blood;
    public final int max_blood;
    private final boolean canBecomeVampire;
    private byte type;
    private UUID lordId = null;
    private IMinionCommand activeCommand = null;
    @SideOnly(value=Side.CLIENT)
    private int activeCommandId = -1;
    private final ArrayList<IMinionCommand> commands;

    public static VampireMob get(EntityCreature mob) {
        return (VampireMob)mob.getExtendedProperties("VampireMob");
    }

    public static void register(EntityCreature mob) {
        mob.registerExtendedProperties("VampireMob", (IExtendedEntityProperties)new VampireMob(mob));
    }

    public VampireMob(EntityCreature mob) {
        this.entity = mob;
        BiteableEntry entry = BiteableRegistry.getEntry(mob);
        if (entry != null) {
            this.max_blood = entry.blood;
            this.canBecomeVampire = entry.convertible;
        } else {
            this.max_blood = -1;
            this.canBecomeVampire = false;
        }
        this.blood = this.max_blood;
        this.type = 0;
        this.commands = new ArrayList();
        this.commands.add(new DefendLordCommand(0, this));
        this.commands.add(new JustFollowCommand(1));
    }

    @Override
    public void activateMinionCommand(@Nullable IMinionCommand command) {
        if (command == null) {
            return;
        }
        if (!this.isMinion()) {
            Logger.w("VampireMob", "%s is no minions and can therby not execute this %s minion command", this, command);
            return;
        }
        if (this.activeCommand != null) {
            this.activeCommand.onDeactivated();
        }
        this.activeCommand = command;
        this.activeCommand.onActivated();
        this.sync();
    }

    public int bite(boolean canTurn) {
        if (this.blood <= 0) {
            return 0;
        }
        int amt = Math.min(this.blood, (int)((float)this.max_blood / 2.0f));
        this.blood -= amt;
        if (this.blood < this.max_blood / 2 && (this.blood == 0 || this.entity.func_70681_au().nextInt(this.blood) == 0)) {
            if (this.canBecomeVampire && canTurn && this.entity.func_70681_au().nextBoolean()) {
                if (Configs.realismMode) {
                    this.entity.func_70690_d(new PotionEffect(ModPotion.sanguinare.field_76415_H, BALANCE.VAMPIRE_MOB_SANGUINARE_DURATION * 20));
                } else {
                    this.makeVampire();
                }
            } else {
                VillageVampire v;
                this.entity.func_70097_a(DamageSource.field_76376_m, 1000.0f);
                if (this.entity instanceof EntityVillager && (v = VillageVampireData.get(this.entity.field_70170_p).findNearestVillage((Entity)this.entity)) != null) {
                    v.villagerBitten();
                }
            }
        }
        if (this.entity instanceof EntityAgeable && ((EntityAgeable)this.entity).func_70874_b() < 0) {
            return Math.round((float)amt / 3.0f);
        }
        this.sync();
        return amt;
    }

    @Override
    public int getActiveCommandId() {
        return this.activeCommandId;
    }

    @Override
    public ArrayList<IMinionCommand> getAvailableCommands() {
        return this.commands;
    }

    public int getBlood() {
        return this.blood;
    }

    @Override
    public IMinionCommand getCommand(int id) {
        if (id < this.commands.size()) {
            return this.commands.get(id);
        }
        return null;
    }

    @Override
    public IMinionLord getLord() {
        if (!this.isMinion()) {
            Logger.w("VampireMob", "Trying to get lord, but mob is no minion", new Object[0]);
        }
        EntityPlayer player = this.lordId == null ? null : this.entity.field_70170_p.func_152378_a(this.lordId);
        return player == null ? null : VampirePlayer.get(player);
    }

    @Override
    @NonNull
    public EntityCreature getRepresentingEntity() {
        return this.entity;
    }

    @Override
    public int getTheEntityID() {
        return this.entity.func_145782_y();
    }

    public void init(Entity entity, World world) {
    }

    public boolean isMinion() {
        return (this.type & 2) == 2;
    }

    public boolean isVampire() {
        return (this.type & 1) == 1;
    }

    public void loadNBTData(NBTTagCompound compound) {
        NBTTagCompound properties = (NBTTagCompound)compound.func_74781_a("VampireMob");
        if (properties != null) {
            if (properties.func_74764_b("type")) {
                this.type = properties.func_74771_c("type");
            }
            if (properties.func_74764_b("blood")) {
                this.blood = properties.func_74762_e("blood");
            }
            IMinionCommand command = null;
            if (this.isMinion()) {
                if (properties.func_74764_b("BossUUIDMost")) {
                    this.lordId = new UUID(properties.func_74763_f("BossUUIDMost"), properties.func_74763_f("BossUUIDLeast"));
                    Logger.d("VampireMob", "Mob %s is minion with lord %s", this.entity, this.lordId);
                    command = this.getCommand(properties.func_74762_e("command_id"));
                    if (command == null) {
                        command = this.getCommand(0);
                    }
                } else {
                    Logger.w("VampireMob", "Mob %s is a minion but does not have a lord uuid saved (%s). This should only happen once", this.entity, properties);
                    this.type = this.isVampire() ? (byte)2 : (byte)0;
                }
            }
            if (this.isMinion()) {
                this.setMinion();
                this.activateMinionCommand(command);
            }
            if (this.isVampire()) {
                this.setVampire();
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void loadUpdateFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("type")) {
            this.type = nbt.func_74771_c("type");
        }
        if (nbt.func_74764_b("blood")) {
            this.blood = nbt.func_74762_e("blood");
        }
        if (nbt.func_74764_b("BossUUIDMost")) {
            this.lordId = new UUID(nbt.func_74763_f("BossUUIDMost"), nbt.func_74763_f("BossUUIDLeast"));
        }
        if (nbt.func_74764_b("active_command_id")) {
            this.activeCommandId = nbt.func_74762_e("active_command_id");
        }
    }

    public void makeMinion(IMinionLord lord) {
        this.setLord(lord);
        this.setMinion();
        this.activateMinionCommand(this.getCommand(0));
        this.entity.func_110163_bv();
        this.sync();
    }

    public boolean makeVampire() {
        if (!this.canBecomeVampire || this.blood < 0) {
            return false;
        }
        this.blood = 0;
        this.setVampire();
        EntityConvertedCreature e = BiteableRegistry.convert(this.entity);
        this.entity.func_70106_y();
        this.entity.field_70170_p.func_72838_d((Entity)e);
        return true;
    }

    public void onUpdate() {
        IMinionLord lord;
        if (this.isMinion() && !this.entity.field_70170_p.field_72995_K && (lord = this.getLord()) != null) {
            if (lord.getRepresentingEntity().equals((Object)this.entity.func_70638_az())) {
                this.entity.func_70624_b(lord.getMinionTarget());
            }
            if (this.entity.equals((Object)this.entity.func_70638_az())) {
                this.entity.func_70624_b(null);
            }
        }
        if (!this.entity.field_70170_p.field_72995_K) {
            if (this.blood > 0 && this.blood < this.max_blood && this.entity.field_70173_aa % 40 == 0) {
                this.entity.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, 40));
                this.entity.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 40, 2));
                if (this.entity.func_70681_au().nextInt(BALANCE.VAMPIRE_MOB_REGEN_CHANCE) == 0) {
                    ++this.blood;
                }
            }
            if (this.entity.func_82165_m(ModPotion.sanguinare.field_76415_H) && this.entity.func_70660_b(ModPotion.sanguinare).func_76459_b() == 1) {
                this.makeVampire();
            }
            if (this.isVampire()) {
                EntityConvertedCreature convertedCreature = BiteableRegistry.convert(this.entity);
                this.entity.func_70106_y();
                this.entity.field_70170_p.func_72838_d((Entity)convertedCreature);
            }
        }
    }

    public void saveNBTData(NBTTagCompound compound) {
        NBTTagCompound properties = new NBTTagCompound();
        properties.func_74774_a("type", this.type);
        if (this.isMinion()) {
            properties.func_74772_a("BossUUIDMost", this.lordId.getMostSignificantBits());
            properties.func_74772_a("BossUUIDLeast", this.lordId.getLeastSignificantBits());
            if (this.activeCommand != null) {
                properties.func_74768_a("command_id", this.activeCommand.getId());
            }
        }
        if (this.blood >= 0) {
            properties.func_74768_a("blood", this.getBlood());
        }
        compound.func_74782_a("VampireMob", (NBTBase)properties);
    }

    @Override
    public void setLord(IMinionLord b) {
        if (b != null) {
            if (b.getRepresentingEntity() instanceof EntityPlayer) {
                this.setLordId(b.getThePersistentID());
            } else {
                Logger.w("VampireMob", "Only players can have non saveable minion. This(%s) cannot be controlled by %s", this, b);
            }
        }
    }

    private void setLordId(UUID id) {
        if (!id.equals(this.lordId)) {
            this.lordId = id;
        }
    }

    private void setMinion() {
        this.type = (byte)(this.type | 2);
        VanillaAIModifier.makeMinion(this, this.entity);
    }

    private void setVampire() {
        this.type = (byte)(this.type | 1);
    }

    @Override
    public boolean shouldBeSavedWithLord() {
        return false;
    }

    public void sync() {
        if (!this.entity.field_70170_p.field_72995_K) {
            Helper.sendPacketToPlayersAround(new UpdateEntityPacket(this), (Entity)this.entity);
        }
    }

    public String toString() {
        return String.format("VampireMob of %s minion(%b) vampire(%b)", this.entity, this.isMinion(), this.isVampire());
    }

    @Override
    public void writeFullUpdateToNBT(NBTTagCompound nbt) {
        nbt.func_74774_a("type", this.type);
        nbt.func_74768_a("blood", this.blood);
        if (this.activeCommand != null) {
            nbt.func_74768_a("active_command_id", this.activeCommand.getId());
        }
        if (this.isMinion()) {
            nbt.func_74772_a("BossUUIDMost", this.lordId.getMostSignificantBits());
            nbt.func_74772_a("BossUUIDLeast", this.lordId.getLeastSignificantBits());
        }
    }
}

