/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.convertible;

import de.teamlapen.vampirism.entity.EntityHunterBase;
import de.teamlapen.vampirism.entity.EntityVampireBase;
import de.teamlapen.vampirism.entity.ai.VampireAIFleeSun;
import de.teamlapen.vampirism.entity.convertible.BiteableRegistry;
import de.teamlapen.vampirism.entity.convertible.ConvertingHandler;
import de.teamlapen.vampirism.network.ISyncable;
import de.teamlapen.vampirism.util.BALANCE;
import de.teamlapen.vampirism.util.Logger;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIRestrictSun;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class EntityConvertedCreature
extends EntityVampireBase
implements ISyncable {
    private EntityCreature entityCreature;
    private boolean entityChanged = false;

    public EntityConvertedCreature(World world) {
        super(world);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityHunterBase.class, (float)BALANCE.MOBPROP.VAMPIRE_DISTANCE_HUNTER, 1.0, 1.05));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new VampireAIFleeSun(this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIRestrictSun((EntityCreature)this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityPlayer.class, 0.9, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityHunterBase.class, 1.0, true));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.7));
        this.field_70714_bg.func_75776_a(13, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(15, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
    }

    public void setEntityCreature(EntityCreature creature) {
        if (creature == null && this.entityCreature != null) {
            this.entityChanged = true;
            this.entityCreature = null;
        } else if (creature != null && !creature.equals((Object)this.entityCreature)) {
            this.entityCreature = creature;
            this.entityChanged = true;
            this.func_70105_a(creature.field_70130_N, creature.field_70131_O);
        }
        if (this.entityCreature != null && this.getConvertingHandler() == null) {
            this.entityCreature = null;
            Logger.w("ConvCreature", "Cannot find converting handler for converted creature %s (%s)", this, this.entityCreature);
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        if (!this.nil()) {
            NBTTagCompound entity = new NBTTagCompound();
            this.entityCreature.field_70128_L = false;
            this.entityCreature.func_70039_c(entity);
            this.entityCreature.field_70128_L = true;
            nbt.func_74782_a("entity_old", (NBTBase)entity);
        }
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.updateEntityAttributes();
    }

    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        this.getConvertingHandler().dropConvertedItems(this.entityCreature, p_70628_1_, p_70628_2_);
    }

    protected void updateEntityAttributes() {
        if (!this.nil()) {
            ConvertingHandler handler = this.getConvertingHandler();
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(handler.getConvertedDMG(this.entityCreature));
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(handler.getConvertedMaxHealth(this.entityCreature));
            this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(handler.getConvertedKnockBackResistance(this.entityCreature));
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(handler.getConvertedSpeed(this.entityCreature));
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(1000.0);
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(0.0);
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.0);
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_74764_b("entity_old")) {
            this.setEntityCreature((EntityCreature)EntityList.func_75615_a((NBTTagCompound)nbt.func_74775_l("entity_old"), (World)this.field_70170_p));
        } else {
            Logger.t("Converted does not have old", new Object[0]);
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.entityCreature == null) {
            Logger.t("Setting dead", new Object[0]);
            this.func_70106_y();
        }
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (!this.nil()) {
            this.entityCreature.func_82149_j((Entity)this);
            this.entityCreature.field_70166_s = this.field_70166_s;
            this.entityCreature.field_70167_r = this.field_70167_r;
            this.entityCreature.field_70169_q = this.field_70169_q;
            this.entityCreature.field_70759_as = this.field_70759_as;
            this.entityCreature.field_70127_C = this.field_70127_C;
            this.entityCreature.field_70126_B = this.field_70126_B;
            this.entityCreature.field_70758_at = this.field_70758_at;
            this.entityCreature.field_70159_w = this.field_70159_w;
            this.entityCreature.field_70181_x = this.field_70181_x;
            this.entityCreature.field_70179_y = this.field_70179_y;
            this.entityCreature.field_70142_S = this.field_70142_S;
            this.entityCreature.field_70137_T = this.field_70137_T;
            this.entityCreature.field_70136_U = this.field_70136_U;
            this.entityCreature.field_70737_aN = this.field_70737_aN;
            this.entityCreature.field_70738_aO = this.field_70738_aO;
            this.entityCreature.field_70739_aP = this.field_70739_aP;
            this.entityCreature.field_70733_aJ = this.field_70733_aJ;
            this.entityCreature.field_70732_aI = this.field_70732_aI;
            this.entityCreature.field_70722_aY = this.field_70722_aY;
            this.entityCreature.field_70721_aZ = this.field_70721_aZ;
            this.entityCreature.field_70754_ba = this.field_70754_ba;
            this.entityCreature.field_70761_aq = this.field_70761_aq;
            this.entityCreature.field_70760_ar = this.field_70760_ar;
            this.entityCreature.field_70725_aQ = this.field_70725_aQ;
            if (this.field_70170_p.field_72995_K) {
                this.entityCreature.field_70118_ct = this.field_70118_ct;
                this.entityCreature.field_70117_cu = this.field_70117_cu;
                this.entityCreature.field_70116_cv = this.field_70116_cv;
            }
        }
        if (this.entityChanged) {
            this.updateEntityAttributes();
        }
    }

    @Override
    public void loadUpdateFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("entity")) {
            this.setEntityCreature((EntityCreature)EntityList.func_75615_a((NBTTagCompound)nbt.func_74775_l("entity"), (World)this.field_70170_p));
        }
    }

    protected boolean func_70692_ba() {
        return false;
    }

    @Override
    public void writeFullUpdateToNBT(NBTTagCompound nbt) {
        if (this.entityCreature != null) {
            NBTTagCompound entity = new NBTTagCompound();
            this.entityCreature.field_70128_L = false;
            this.entityCreature.func_70039_c(entity);
            this.entityCreature.field_70128_L = true;
            nbt.func_74782_a("entity", (NBTBase)entity);
        }
    }

    public EntityCreature getEntityCreature() {
        return this.entityCreature;
    }

    public String func_70005_c_() {
        return StatCollector.func_74838_a((String)"entity.vampirism.vampire.name") + " " + (this.nil() ? super.func_70005_c_() : this.entityCreature.func_70005_c_());
    }

    public String toString() {
        return "[" + super.toString() + " representing " + this.entityCreature + "]";
    }

    public void func_70642_aH() {
        if (!this.nil()) {
            this.entityCreature.func_70642_aH();
        }
    }

    protected ConvertingHandler getConvertingHandler() {
        return BiteableRegistry.getEntry((EntityCreature)this.entityCreature).convertingHandler;
    }

    protected boolean nil() {
        return this.entityCreature == null;
    }

    @Override
    public boolean isCreatureType(EnumCreatureType type, boolean forSpawnCount) {
        return type == EnumCreatureType.creature;
    }
}

