/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.minions;

import de.teamlapen.vampirism.ModItems;
import de.teamlapen.vampirism.entity.EntityHunterBase;
import de.teamlapen.vampirism.entity.ai.VampireAIFleeGarlic;
import de.teamlapen.vampirism.entity.ai.VampireAIFleeSun;
import de.teamlapen.vampirism.entity.minions.CollectBloodCommand;
import de.teamlapen.vampirism.entity.minions.ComeBackToPlayerCommand;
import de.teamlapen.vampirism.entity.minions.DefaultMinionCommand;
import de.teamlapen.vampirism.entity.minions.DefendAreaCommand;
import de.teamlapen.vampirism.entity.minions.EntitySaveableVampireMinion;
import de.teamlapen.vampirism.entity.minions.EntityVampireMinion;
import de.teamlapen.vampirism.entity.minions.IMinionCommand;
import de.teamlapen.vampirism.entity.minions.IMinionLord;
import de.teamlapen.vampirism.entity.minions.MinionHelper;
import de.teamlapen.vampirism.entity.minions.StayHereCommand;
import de.teamlapen.vampirism.entity.player.VampirePlayer;
import de.teamlapen.vampirism.item.ItemBloodBottle;
import de.teamlapen.vampirism.util.BALANCE;
import de.teamlapen.vampirism.util.Logger;
import java.util.ArrayList;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIRestrictSun;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import org.eclipse.jdt.annotation.NonNull;

public class EntityRemoteVampireMinion
extends EntityVampireMinion {
    private static final String TAG = "RVampireMinion";
    private static final String KEY_COMEBACK = "l_cbc";
    private UUID lordId;
    private final ArrayList<IMinionCommand> commands;
    private final IMinionCommand comeBack;
    private long lastComeBackCall;

    public EntityRemoteVampireMinion(World world) {
        super(world);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityHunterBase.class, (float)MathHelper.func_76141_d((float)((float)BALANCE.MOBPROP.VAMPIRE_DISTANCE_HUNTER * 1.5f)), 1.1, 1.4));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIRestrictSun((EntityCreature)this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new VampireAIFleeSun(this, (double)1.1f, true));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new VampireAIFleeGarlic(this, (double)1.1f, true));
        this.commands = new ArrayList();
        this.commands.add(this.getActiveCommand());
        this.commands.add(new ConvertToSaveableCommand(1, this));
        this.commands.add(new CollectBloodCommand(2, this));
        this.commands.add(new DefendAreaCommand(3, this));
        this.comeBack = new ComeBackToPlayerCommand(-1, this);
    }

    public void convertToSaveable() {
        EntitySaveableVampireMinion save = (EntitySaveableVampireMinion)EntityList.func_75620_a((String)"vampirism.vampireMinionS", (World)this.field_70170_p);
        save.copyDataFromMinion(this);
        save.func_82149_j((Entity)this);
        save.func_70606_j(this.func_110143_aJ());
        IMinionLord lord = this.getLord();
        if (lord != null) {
            save.setLord(lord);
        }
        this.field_70170_p.func_72838_d((Entity)save);
        this.func_82160_b(true, 100);
        this.func_70106_y();
    }

    @Override
    public void func_82141_a(Entity from, boolean p) {
        super.func_82141_a(from, p);
        if (from instanceof EntityRemoteVampireMinion) {
            EntityRemoteVampireMinion m = (EntityRemoteVampireMinion)from;
            this.lordId = m.lordId;
            this.activateMinionCommand(m.getActiveCommand());
        }
    }

    @Override
    public ArrayList<IMinionCommand> getAvailableCommands() {
        return this.commands;
    }

    @Override
    public IMinionCommand getCommand(int id) {
        if (id == -1) {
            return this.comeBack;
        }
        if (id < this.commands.size()) {
            return this.commands.get(id);
        }
        return null;
    }

    @Override
    @NonNull
    protected IMinionCommand getDefaultCommand() {
        return new StayHereCommand(0, this);
    }

    @Override
    @Nullable
    public IMinionLord getLord() {
        EntityPlayer player = this.lordId == null ? null : this.field_70170_p.func_152378_a(this.lordId);
        return player == null ? null : VampirePlayer.get(player);
    }

    @Override
    protected void loadPartialUpdateFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("LordUUIDMost")) {
            this.lordId = new UUID(nbt.func_74763_f("LordUUIDMost"), nbt.func_74763_f("LordUUIDLeast"));
        }
    }

    public void func_70645_a(DamageSource src) {
        MinionHelper.sendMessageToLord(this, "text.vampirism.sorry_i_died_while_doing", "\\: ", this.getActiveCommand().getUnlocalizedName());
        this.func_145779_a(ModItems.gemOfBinding, 1);
    }

    @Override
    public void func_70636_d() {
        long lc;
        super.func_70636_d();
        IMinionLord l = this.getLord();
        if (l != null && l instanceof VampirePlayer && (lc = l.getLastComebackCall()) > this.lastComeBackCall) {
            this.activateMinionCommand(this.comeBack);
            this.lastComeBackCall = lc;
            MinionHelper.sendMessageToLord(this, "text.vampirism.coming_back");
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_74764_b("LordUUIDMost")) {
            this.lordId = new UUID(nbt.func_74763_f("LordUUIDMost"), nbt.func_74763_f("LordUUIDLeast"));
        }
        this.lastComeBackCall = nbt.func_74763_f(KEY_COMEBACK);
    }

    @Override
    public void setLord(IMinionLord lord) {
        if (lord == null || !(lord instanceof VampirePlayer)) {
            Logger.w(TAG, "Only players can have non saveable minion. This(%s) cannot be controlled by %s", this, lord);
            throw new IllegalArgumentException("Only players can have non saveable minion");
        }
        this.lastComeBackCall = lord.getLastComebackCall();
        this.lordId = lord.getThePersistentID();
    }

    @Override
    public boolean shouldBeSavedWithLord() {
        return false;
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        if (this.lordId != null) {
            nbt.func_74772_a("LordUUIDMost", this.lordId.getMostSignificantBits());
            nbt.func_74772_a("LordUUIDLeast", this.lordId.getLeastSignificantBits());
        }
        nbt.func_74772_a(KEY_COMEBACK, this.lastComeBackCall);
    }

    @Override
    protected void writeUpdateToNBT(NBTTagCompound nbt) {
        if (this.lordId != null) {
            nbt.func_74772_a("LordUUIDMost", this.lordId.getMostSignificantBits());
            nbt.func_74772_a("LordUUIDLeast", this.lordId.getLeastSignificantBits());
        }
    }

    @Override
    public void addBlood(int amt) {
        ItemStack item = this.func_71124_b(0);
        if (item != null) {
            if (item.func_77973_b().equals(Items.field_151069_bo)) {
                ItemStack stack1 = new ItemStack((Item)ModItems.bloodBottle, 1, 0);
                ItemBloodBottle.addBlood(stack1, amt);
                this.func_70062_b(0, stack1);
                return;
            }
            if (item.func_77973_b().equals((Object)ModItems.bloodBottle)) {
                ItemBloodBottle.addBlood(item, amt);
                return;
            }
        }
    }

    private static class ConvertToSaveableCommand
    extends DefaultMinionCommand {
        private final EntityRemoteVampireMinion entity;

        public ConvertToSaveableCommand(int id, EntityRemoteVampireMinion minion) {
            super(id);
            this.entity = minion;
        }

        @Override
        public int getMinU() {
            return 144;
        }

        @Override
        public int getMinV() {
            return 0;
        }

        @Override
        public String getUnlocalizedName() {
            return "minioncommand.vampirism.converttosaveable";
        }

        @Override
        public void onActivated() {
            this.entity.convertToSaveable();
            EntityItem gem = new EntityItem(this.entity.field_70170_p, this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v, new ItemStack((Item)ModItems.gemOfBinding, 1));
            this.entity.field_70170_p.func_72838_d((Entity)gem);
        }

        @Override
        public void onDeactivated() {
        }
    }
}

