/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.minions;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.teamlapen.vampirism.entity.EntityDefaultVampire;
import de.teamlapen.vampirism.entity.EntityDracula;
import de.teamlapen.vampirism.entity.EntityPortalGuard;
import de.teamlapen.vampirism.entity.EntityVampireBaron;
import de.teamlapen.vampirism.entity.ai.MinionAIHurtByNonLord;
import de.teamlapen.vampirism.entity.minions.IMinion;
import de.teamlapen.vampirism.entity.minions.IMinionCommand;
import de.teamlapen.vampirism.entity.minions.MinionHelper;
import de.teamlapen.vampirism.network.ISyncable;
import de.teamlapen.vampirism.network.UpdateEntityPacket;
import de.teamlapen.vampirism.util.BALANCE;
import de.teamlapen.vampirism.util.Helper;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class EntityVampireMinion
extends EntityDefaultVampire
implements IMinion,
ISyncable {
    private int oldVampireTexture = -1;
    private IMinionCommand activeCommand;
    private boolean wantsBlood = false;
    @SideOnly(value=Side.CLIENT)
    private int activeCommandId;

    @Override
    public boolean wantsBlood() {
        return this.wantsBlood;
    }

    public void setWantsBlood(boolean wantsBlood) {
        this.wantsBlood = wantsBlood;
    }

    public void func_70074_a(EntityLivingBase entity) {
        super.func_70074_a(entity);
        if (entity instanceof EntityPlayer) {
            if (this.getLord() != null && this.getLord() instanceof EntityDracula) {
                ((EntityDracula)this.getLord()).restoreOnPlayerKill((EntityPlayer)entity);
            }
        } else if (this.getLord() != null && this.getLord() instanceof EntityVampireBaron) {
            ((EntityVampireBaron)this.getLord()).func_70074_a(entity);
        }
    }

    public EntityVampireMinion(World world) {
        super(world);
        this.func_110163_bv();
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityLivingBase.class, 1.0, false));
        this.field_70714_bg.func_75776_a(15, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.7));
        this.field_70714_bg.func_75776_a(16, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 10.0f));
        this.field_70715_bh.func_75776_a(8, (EntityAIBase)new MinionAIHurtByNonLord(this, false));
        this.activeCommand = this.getDefaultCommand();
        this.activeCommand.onActivated();
    }

    @Override
    public void activateMinionCommand(IMinionCommand command) {
        if (command == null) {
            return;
        }
        this.activeCommand.onDeactivated();
        this.activeCommand = command;
        this.activeCommand.onActivated();
        this.sync();
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(30.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(BALANCE.MOBPROP.VAMPIRE_MINION_MAX_HEALTH);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(BALANCE.MOBPROP.VAMPIRE_MINION_ATTACK_DAMAGE);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(BALANCE.MOBPROP.VAMPIRE_MINION_MOVEMENT_SPEED);
    }

    public void func_82141_a(Entity from, boolean p) {
        super.func_82141_a(from, p);
        if (from instanceof EntityVampireMinion) {
            EntityVampireMinion m = (EntityVampireMinion)from;
            this.copyDataFromMinion(m);
        }
    }

    protected void copyDataFromMinion(EntityVampireMinion from) {
        this.setOldVampireTexture(from.getOldVampireTexture());
    }

    public IMinionCommand getActiveCommand() {
        return this.activeCommand;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getActiveCommandId() {
        return this.activeCommandId;
    }

    @Override
    public float func_70783_a(int x, int y, int z) {
        float i = 0.5f - this.field_70170_p.func_72801_o(x, y, z);
        if (i > 0.0f) {
            return i;
        }
        return 0.01f;
    }

    @NonNull
    protected abstract IMinionCommand getDefaultCommand();

    public int getOldVampireTexture() {
        return this.oldVampireTexture;
    }

    @Override
    @NonNull
    public EntityCreature getRepresentingEntity() {
        return this;
    }

    public boolean func_70631_g_() {
        return true;
    }

    @Override
    public boolean isValidLightLevel() {
        return true;
    }

    protected void loadPartialUpdateFromNBT(NBTTagCompound nbt) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void loadUpdateFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("oldvampire")) {
            this.oldVampireTexture = nbt.func_74762_e("oldvampire");
        }
        this.activeCommandId = nbt.func_74762_e("active_command_id");
        this.loadPartialUpdateFromNBT(nbt);
    }

    public boolean func_70686_a(Class p_70686_1_) {
        if (EntityPortalGuard.class.equals((Object)p_70686_1_)) {
            return false;
        }
        return super.func_70686_a(p_70686_1_);
    }

    public boolean func_70685_l(Entity p_70685_1_) {
        if (p_70685_1_.func_82150_aj()) {
            return false;
        }
        return super.func_70685_l(p_70685_1_);
    }

    @Override
    public void func_70636_d() {
        if (this.oldVampireTexture != -1 && this.field_70173_aa > 50) {
            this.oldVampireTexture = -1;
        }
        if (this.oldVampireTexture != -1 && this.field_70170_p.field_72995_K) {
            Helper.spawnParticlesAroundEntity((EntityLivingBase)this, "witchMagic", 1.0, 3);
        }
        if (!this.field_70170_p.field_72995_K && !this.field_70729_aU) {
            List list = this.field_70170_p.func_72872_a(EntityItem.class, this.field_70121_D.func_72314_b(1.0, 0.0, 1.0));
            for (EntityItem entityitem : list) {
                ItemStack itemstack;
                if (entityitem.field_70128_L || entityitem.func_92059_d() == null || !this.activeCommand.shouldPickupItem(itemstack = entityitem.func_92059_d())) continue;
                ItemStack stack1 = this.func_71124_b(0);
                if (stack1 != null) {
                    this.func_70099_a(stack1, 0.0f);
                }
                this.func_70062_b(0, itemstack);
                entityitem.func_70106_y();
            }
        }
        if (BALANCE.MOBPROP.VAMPIRE_MINION_REGENERATE_SECS >= 0 && this.field_70173_aa % (BALANCE.MOBPROP.VAMPIRE_MINION_REGENERATE_SECS * 20) == 0 && (this.func_142013_aG() == 0 || this.func_142013_aG() - this.field_70173_aa > 100)) {
            this.func_70691_i(2.0f);
        }
        super.func_70636_d();
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        IMinionCommand command = this.getCommand(nbt.func_74762_e("command_id"));
        if (command != null) {
            this.activateMinionCommand(command);
        }
        if (nbt.func_150297_b("CustomName", 8) && nbt.func_74779_i("CustomName").length() > 0) {
            this.tryToSetName(nbt.func_74779_i("CustomName"), null);
        }
    }

    public void func_94058_c(String s) {
    }

    public void setOldVampireTexture(int oldVampireTexture) {
        this.oldVampireTexture = oldVampireTexture;
    }

    public void sync() {
        if (!this.field_70170_p.field_72995_K) {
            Helper.sendPacketToPlayersAround(new UpdateEntityPacket((Entity)this), (Entity)this);
        }
    }

    public boolean tryToSetName(String name, @Nullable EntityPlayer player) {
        if (player == null || MinionHelper.isLordSafe((IMinion)this, (Entity)player)) {
            super.func_94058_c(name);
            return true;
        }
        return false;
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("command_id", this.getActiveCommand().getId());
    }

    @Override
    public void writeFullUpdateToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("oldvampire", this.oldVampireTexture);
        nbt.func_74768_a("active_command_id", this.activeCommand.getId());
        this.writeUpdateToNBT(nbt);
    }

    public boolean func_70039_c(NBTTagCompound nbt) {
        if (this.shouldBeSavedWithLord()) {
            return false;
        }
        return super.func_70039_c(nbt);
    }

    protected void writeUpdateToNBT(NBTTagCompound nbt) {
    }

    @Override
    public int func_70627_aG() {
        return 2000;
    }
}

