/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.player;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.teamlapen.vampirism.Achievements;
import de.teamlapen.vampirism.Configs;
import de.teamlapen.vampirism.ModItems;
import de.teamlapen.vampirism.ModPotion;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.block.BlockCoffin;
import de.teamlapen.vampirism.block.IGarlic;
import de.teamlapen.vampirism.entity.EntityDracula;
import de.teamlapen.vampirism.entity.EntityVampire;
import de.teamlapen.vampirism.entity.EntityVampireBase;
import de.teamlapen.vampirism.entity.EntityVampireHunter;
import de.teamlapen.vampirism.entity.VampireMob;
import de.teamlapen.vampirism.entity.minions.EntityVampireMinion;
import de.teamlapen.vampirism.entity.minions.IMinion;
import de.teamlapen.vampirism.entity.minions.IMinionLord;
import de.teamlapen.vampirism.entity.minions.MinionHelper;
import de.teamlapen.vampirism.entity.minions.SaveableMinionHandler;
import de.teamlapen.vampirism.entity.player.PlayerModifiers;
import de.teamlapen.vampirism.entity.player.skills.ILastingSkill;
import de.teamlapen.vampirism.entity.player.skills.ISkill;
import de.teamlapen.vampirism.entity.player.skills.Skills;
import de.teamlapen.vampirism.item.GarlicHelper;
import de.teamlapen.vampirism.item.ItemBloodBottle;
import de.teamlapen.vampirism.item.ItemVampireArmor;
import de.teamlapen.vampirism.network.SpawnParticlePacket;
import de.teamlapen.vampirism.network.UpdateEntityPacket;
import de.teamlapen.vampirism.util.BALANCE;
import de.teamlapen.vampirism.util.DefaultPieElement;
import de.teamlapen.vampirism.util.Helper;
import de.teamlapen.vampirism.util.IPieElement;
import de.teamlapen.vampirism.util.Logger;
import de.teamlapen.vampirism.util.SunDmgHelper;
import de.teamlapen.vampirism.util.VampireLordData;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S0APacketUseBed;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.StatBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public class VampirePlayer
implements UpdateEntityPacket.ISyncableExtendedProperties,
IMinionLord {
    public static final String EXT_PROP_NAME = "VampirePlayer";
    public static final String TAG = "VampirePlayer";
    public static final int MAXBLOOD = 20;
    private static final String KEY_VAMPIRE_LORD = "vampire_lord";
    private static final String KEY_COMEBACK_CALL = "l_cbc";
    private static final String KEY_VISION = "vision";
    @SideOnly(value=Side.CLIENT)
    private static final ResourceLocation minionCommandIconLoc = new ResourceLocation("vampirism:textures/gui/minion_commands.png");
    private static final String KEY_MINIONS = "minions";
    private int biteCooldown;
    private static final int BITE_COOLDOWN = 15;
    public boolean sleepingCoffin = false;
    private final EntityPlayer player;
    private final String KEY_LEVEL = "level";
    private final String KEY_BLOOD = "blood";
    private final String KEY_AUTOFILL = "autofill";
    private final String KEY_SKILLS = "skills";
    private final String KEY_EXTRADATA = "extra";
    private final BloodStats bloodStats;
    private int level;
    private int[] skillTimer;
    private boolean dirty = false;
    private boolean autoFillBlood;
    private int vision;
    private EntityLivingBase minionTarget;
    private final SaveableMinionHandler minionHandler;
    private boolean skipFallDamageReduction = false;
    private boolean vampireLord = false;
    private boolean sundamageCache = false;
    private boolean batTransformed = false;
    private int ticksInSun = 0;
    private long lastRemoteMinionComebackCall = 0L;
    private NBTTagCompound extraData;

    public static VampirePlayer get(EntityPlayer player) {
        return (VampirePlayer)player.getExtendedProperties("VampirePlayer");
    }

    public static void onPlayerJoinWorld(EntityPlayer player) {
        VampirePlayer p = VampirePlayer.get(player);
        for (int i = 0; i < p.skillTimer.length; ++i) {
            if (p.skillTimer[i] <= 0) continue;
            ((ILastingSkill)Skills.getSkill(i)).onReActivated(p, player);
        }
        p.refreshVampireLordState();
        p.sync(false);
    }

    public static void register(EntityPlayer player) {
        player.registerExtendedProperties("VampirePlayer", (IExtendedEntityProperties)new VampirePlayer(player));
    }

    public VampirePlayer(EntityPlayer player) {
        this.player = player;
        try {
            this.player.func_70096_w().func_75682_a(Configs.player_blood_watcher, (Object)20);
        }
        catch (IllegalArgumentException e) {
            e.initCause(new Exception("Please change the player blood watcher id in config/vampirism.conf to something else"));
            throw e;
        }
        this.bloodStats = new BloodStats();
        this.autoFillBlood = true;
        this.vision = 1;
        this.skillTimer = new int[Skills.getSkillCount()];
        this.extraData = new NBTTagCompound();
        this.minionHandler = new SaveableMinionHandler(this);
    }

    public void copyFrom(EntityPlayer original) {
        NBTTagCompound nbt = new NBTTagCompound();
        VampirePlayer.get(original).saveNBTData(nbt);
        this.loadNBTData(nbt);
    }

    protected void fillBloodIntoInventory(int amt) {
        if (amt <= 0) {
            return;
        }
        ItemStack stack = ItemBloodBottle.getBloodBottleInInventory(this.player.field_71071_by, true);
        if (stack != null) {
            this.fillBloodIntoInventory(ItemBloodBottle.addBlood(stack, amt));
        } else {
            ItemStack glas = ItemBloodBottle.getGlasBottleInInventory(this.player.field_71071_by);
            if (glas != null) {
                ItemStack bloodBottle = new ItemStack((Item)ModItems.bloodBottle, 1, 0);
                amt = ItemBloodBottle.addBlood(bloodBottle, amt);
                this.player.field_71071_by.func_146026_a(Items.field_151069_bo);
                if (!this.player.field_71071_by.func_70441_a(bloodBottle)) {
                    this.player.func_71019_a(bloodBottle, false);
                }
                if (amt > 0) {
                    this.fillBloodIntoInventory(amt);
                }
            }
        }
    }

    private void func_71013_b(int direction) {
        this.player.field_71079_bU = 0.0f;
        this.player.field_71089_bV = 0.0f;
        switch (direction) {
            case 0: {
                this.player.field_71089_bV = -1.8f;
                break;
            }
            case 1: {
                this.player.field_71079_bU = 1.8f;
                break;
            }
            case 2: {
                this.player.field_71089_bV = 1.8f;
                break;
            }
            case 3: {
                this.player.field_71079_bU = -1.8f;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public List<IPieElement> getAvailableMinionCalls() {
        ArrayList<IPieElement> list = new ArrayList<IPieElement>();
        if (this.isVampireLord()) {
            list.add(new DefaultPieElement(1, "minioncommand.vampirism.comeback", 128, 0, minionCommandIconLoc, new float[]{1.0f, 1.0f, 0.05f}));
            list.add(new DefaultPieElement(2, "minioncommand.vampirism.defendlord", 64, 0, minionCommandIconLoc, new float[]{0.88f, 0.45f, 0.0f}));
            list.add(new DefaultPieElement(5, "minioncommand.vampirism.justfollow", 112, 0, minionCommandIconLoc, new float[]{0.88f, 0.45f, 0.0f}));
            if (this.getMinionHandler().getMinionCount() > 0) {
                list.add(new DefaultPieElement(3, "minioncommand.vampirism.attackhostilenoplayers", 0, 0, minionCommandIconLoc, new float[]{0.6f, 0.3f, 0.01f}));
                list.add(new DefaultPieElement(4, "minioncommand.vampirism.attackhostile", 32, 0, minionCommandIconLoc, new float[]{0.6f, 0.3f, 0.01f}));
            }
        }
        return list;
    }

    public int getBlood() {
        return this.player.func_70096_w().func_75679_c(Configs.player_blood_watcher);
    }

    public BloodStats getBloodStats() {
        return this.bloodStats;
    }

    public NBTTagCompound getExtraDataTag() {
        return this.extraData;
    }

    @Override
    public long getLastComebackCall() {
        return this.lastRemoteMinionComebackCall;
    }

    public int getLevel() {
        return this.level;
    }

    @Override
    public int getMaxMinionCount() {
        return Math.round((float)this.getLevel() / 3.0f) + (this.isVampireLord() ? 4 : 1);
    }

    @Override
    public SaveableMinionHandler getMinionHandler() {
        return this.minionHandler;
    }

    public int getMinionsLeft(boolean notify) {
        int left = this.minionHandler.getMinionsLeft();
        if (notify && left == 0) {
            this.player.func_145747_a((IChatComponent)new ChatComponentTranslation("text.vampirism.no_more_minions", new Object[0]));
        }
        return left;
    }

    @Override
    public EntityLivingBase getMinionTarget() {
        if (this.minionTarget != null) {
            return this.minionTarget;
        }
        if (this.player.func_142013_aG() < this.player.field_70173_aa + 200) {
            return this.player.func_110144_aD();
        }
        return null;
    }

    @Override
    public EntityLivingBase getRepresentingEntity() {
        return this.player;
    }

    @SideOnly(value=Side.CLIENT)
    public int getSkillTime(int id) {
        if (id >= 0) {
            return this.skillTimer[id];
        }
        return 0;
    }

    public int getSunDamageTicksInSun() {
        if (this.getLevel() < 3) {
            return 0;
        }
        return this.ticksInSun;
    }

    @Override
    public double getTheDistanceSquared(Entity e) {
        return this.player.func_70068_e(e);
    }

    @Override
    public int getTheEntityID() {
        return this.player.func_145782_y();
    }

    @Override
    public UUID getThePersistentID() {
        return this.player.getPersistentID();
    }

    public boolean gettingSundamage() {
        if (this.player.field_70173_aa % 4 != 0) {
            return this.sundamageCache;
        }
        this.sundamageCache = SunDmgHelper.gettingSundamge((EntityLivingBase)this.player);
        return this.sundamageCache;
    }

    public boolean isInStrongGarlic() {
        Block b;
        if (this.player.field_70170_p != null && (b = this.player.field_70170_p.func_147439_a((int)this.player.field_70165_t, (int)this.player.field_70163_u + 1, (int)this.player.field_70161_v)) instanceof IGarlic) {
            return !((IGarlic)b).isWeakGarlic();
        }
        return false;
    }

    public int getVision() {
        return this.vision;
    }

    private void handleSunDamage() {
        if (this.ticksInSun < 101) {
            ++this.ticksInSun;
        }
        if (this.player.field_71075_bZ.field_75098_d) {
            return;
        }
        int type = Math.min(3, Math.round((float)this.getLevel() / 2.0f - 0.51f));
        if (this.player.func_70644_a(ModPotion.sunscreen) && type > 0) {
            --type;
        }
        if (type > 0) {
            long t = this.player.field_70170_p.func_82737_E();
            boolean armor = ItemVampireArmor.isFullyWorn(this.player);
            if (!armor && BALANCE.VAMPIRE_PLAYER_SUNDAMAGE_NAUSEA && (t % 250L == 0L || this.ticksInSun == 1)) {
                this.player.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 180));
            }
            if (type > 1) {
                if (t % 30L == 0L) {
                    this.player.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, 30, 1));
                }
                if (type > 2 && this.ticksInSun >= 100 && t % 40L == 0L) {
                    float damage = (float)BALANCE.VAMPIRE_PLAYER_SUN_DAMAGE;
                    if (this.isVampireLord()) {
                        damage *= 1.8f;
                    }
                    if (armor) {
                        damage *= 0.6f;
                    }
                    this.player.func_70097_a(VampirismMod.sunDamage, damage);
                }
            }
        }
    }

    public void init(Entity entity, World world) {
    }

    public boolean isAutoFillBlood() {
        return this.autoFillBlood;
    }

    private boolean isRemote() {
        return this.player.field_70170_p.field_72995_K;
    }

    public boolean isSkillActive(int id) {
        if (id >= this.skillTimer.length) {
            Logger.w("VampirePlayer", "The skill with id " + id + " doesn't exist", new Object[0]);
            return false;
        }
        return this.skillTimer[id] > 0;
    }

    public boolean isSkillActive(ISkill s) {
        if (s == null) {
            return false;
        }
        return this.isSkillActive(s.getId());
    }

    @Override
    public boolean isTheEntityAlive() {
        return this.player.func_70089_S();
    }

    public boolean isVampireLord() {
        return this.vampireLord;
    }

    public void levelUp() {
        int level = this.getLevel();
        if (++level > 14) {
            --level;
        }
        this.setLevel(level);
        if (level > 0) {
            this.player.func_71064_a((StatBase)Achievements.becomingAVampire, 1);
        }
    }

    public void loadNBTData(NBTTagCompound compound) {
        NBTTagCompound properties = (NBTTagCompound)compound.func_74781_a("VampirePlayer");
        if (properties == null) {
            Logger.i("VampirePlayer", "VampirePlayer data for %s cannot be loaded. It probably does not exist", this.player);
            return;
        }
        this.setBloodData(properties.func_74762_e("blood"));
        this.level = properties.func_74762_e("level");
        int[] temp = properties.func_74759_k("skills");
        if (temp.length == Skills.getSkillCount()) {
            this.skillTimer = temp;
        } else {
            Logger.w("VampirePlayer", "Loaded skill timers have a different size than the existing skills", new Object[0]);
            this.skillTimer = new int[Skills.getSkillCount()];
        }
        if (properties.func_74764_b("autofill")) {
            this.setAutoFillBlood(properties.func_74767_n("autofill"));
        }
        if (properties.func_74764_b(KEY_VISION)) {
            this.setVision(properties.func_74762_e(KEY_VISION));
        }
        if (properties.func_74764_b("extra")) {
            this.extraData = properties.func_74775_l("extra");
        }
        this.lastRemoteMinionComebackCall = properties.func_74763_f(KEY_COMEBACK_CALL);
        this.bloodStats.readNBT(properties);
        PlayerModifiers.applyModifiers(this.level, this.player);
        this.minionHandler.loadMinions(properties.func_150295_c(KEY_MINIONS, 10));
    }

    @Override
    public void loadUpdateFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("level")) {
            this.setLevel(nbt.func_74762_e("level"));
        }
        if (nbt.func_74764_b("timers")) {
            this.skillTimer = nbt.func_74759_k("timers");
        }
        if (nbt.func_74764_b("lord")) {
            boolean old = this.vampireLord;
            this.vampireLord = nbt.func_74767_n("lord");
            if (old != this.vampireLord) {
                this.player.refreshDisplayName();
            }
        }
        if (nbt.func_74764_b("sleepingCoffin")) {
            this.sleepingCoffin = nbt.func_74767_n("sleepingCoffin");
        }
        if (nbt.func_74764_b(KEY_VISION)) {
            this.setVision(nbt.func_74762_e(KEY_VISION));
        }
    }

    private void looseLevel() {
        int level = this.getLevel();
        if (level > 1) {
            this.setLevel(level - 1);
        }
    }

    private void makeVampireToMinion(EntityVampire e) {
        if (this.getMinionsLeft(true) == 0) {
            return;
        }
        EntityVampireMinion m = (EntityVampireMinion)EntityList.func_75620_a((String)"vampirism.vampireMinionS", (World)e.field_70170_p);
        m.func_82149_j((Entity)e);
        m.setLord(this);
        m.setOldVampireTexture(e.func_145782_y() % 4);
        e.func_70106_y();
        e.field_70170_p.func_72838_d((Entity)m);
    }

    public void onCallActivated(int i) {
        Logger.d("VampirePlayer", "Minion call %d received", i);
        switch (i) {
            case 1: {
                this.lastRemoteMinionComebackCall = System.currentTimeMillis();
                break;
            }
            case 2: {
                this.minionHandler.notifyCall(SaveableMinionHandler.Call.DEFEND_LORD);
                for (VampireMob m : MinionHelper.getNearMobMinions(this, 20)) {
                    m.activateMinionCommand(m.getCommand(0));
                }
                break;
            }
            case 3: {
                this.minionHandler.notifyCall(SaveableMinionHandler.Call.ATTACK_NON_PLAYER);
                break;
            }
            case 4: {
                this.minionHandler.notifyCall(SaveableMinionHandler.Call.ATTACK);
                break;
            }
            case 5: {
                this.minionHandler.notifyCall(SaveableMinionHandler.Call.FOLLOW);
                for (VampireMob m : MinionHelper.getNearMobMinions(this, 20)) {
                    m.activateMinionCommand(m.getCommand(1));
                }
                break;
            }
        }
    }

    public void onChangedDimension(int from, int to) {
        this.minionHandler.teleportMinionsToLord();
    }

    public void onDeath(DamageSource source) {
        if (source instanceof EntityDamageSource) {
            Entity src = source.func_76346_g();
            if (src instanceof EntityVampireHunter && BALANCE.VAMPIRE_PLAYER_LOOSE_LEVEL) {
                this.looseLevel();
            }
            if (this.isVampireLord()) {
                IMinionLord l;
                EntityLivingBase old = null;
                if (src instanceof EntityVampire) {
                    old = (EntityLivingBase)src;
                } else if (src instanceof EntityPlayer) {
                    old = (EntityLivingBase)src;
                } else if (src instanceof IMinion) {
                    l = ((IMinion)src).getLord();
                    if (l != null) {
                        old = l.getRepresentingEntity();
                    }
                } else if (src instanceof EntityCreature && VampireMob.get((EntityCreature)src).isMinion() && (l = VampireMob.get((EntityCreature)src).getLord()) != null) {
                    old = l.getRepresentingEntity();
                }
                if (old != null) {
                    if (old instanceof EntityPlayer) {
                        VampireLordData.get(this.player.field_70170_p).replaceLord(this.player, (EntityPlayer)old);
                    } else {
                        EntityDracula dracula = (EntityDracula)EntityList.func_75620_a((String)"vampirism.dracula", (World)old.field_70170_p);
                        dracula.func_82149_j((Entity)old);
                        dracula.makeDisappear();
                        old.field_70170_p.func_72838_d((Entity)dracula);
                        old.func_70106_y();
                        VampireLordData.get(this.player.field_70170_p).makeNoLord(this.player, "text.vampirism.lord.vampire_kill_replace");
                    }
                }
            }
            if (this.player instanceof EntityPlayerMP && (src instanceof EntityDracula || src instanceof EntityVampireMinion)) {
                src.func_70074_a((EntityLivingBase)this.player);
            }
        }
        for (int i = 0; i < this.skillTimer.length; ++i) {
            if (this.skillTimer[i] <= 0) continue;
            this.skillTimer[i] = -Skills.getSkill(i).getCooldown();
            ((ILastingSkill)Skills.getSkill(i)).onDeactivated(this, this.player);
        }
        this.bloodStats.addBlood(20);
    }

    public boolean onEntityAttacked(DamageSource source, float amount) {
        if (source.func_76346_g() instanceof EntityVampireBase && this.getLevel() == 0 && this.player.field_70170_p.field_73012_v.nextInt(BALANCE.VAMPIRE_PLAYER_SANGUINARE_PROB * 4) == 0 && !this.player.func_70644_a(ModPotion.sanguinare)) {
            this.player.func_70690_d(new PotionEffect(ModPotion.sanguinare.field_76415_H, BALANCE.VAMPIRE_PLAYER_SANGUINARE_DURATION * 20));
        }
        if (source.func_76346_g() instanceof EntityLivingBase && this.getLevel() > 0) {
            this.minionTarget = (EntityLivingBase)source.func_76346_g();
            if (MinionHelper.isLordSafe(this.minionTarget, (IMinionLord)this)) {
                this.minionTarget = null;
            }
            return false;
        }
        if (DamageSource.field_76379_h.equals(source) && !this.skipFallDamageReduction) {
            float i = amount - (float)(this.getLevel() / 3) - 1.0f;
            if (i > 0.0f) {
                this.skipFallDamageReduction = true;
                this.player.func_70097_a(DamageSource.field_76379_h, i);
                this.skipFallDamageReduction = false;
            }
            return true;
        }
        if (this.sleepingCoffin && !this.player.func_85032_ar() && (!this.player.field_71075_bZ.field_75102_a || source.func_76357_e())) {
            this.wakeUpPlayer(false, true, false, false);
        }
        return false;
    }

    public void onPlayerLoggedIn() {
        this.minionHandler.addLoadedMinions();
    }

    public void onPlayerLoggedOut() {
        this.minionHandler.killMinions(true);
    }

    public void onSkillToggled(int i) {
        ISkill s = Skills.getSkill(i);
        if (s == null) {
            return;
        }
        int t = this.skillTimer[i];
        if (t > 0) {
            this.skillTimer[i] = Math.min(-s.getCooldown() + t, 0);
            ((ILastingSkill)s).onDeactivated(this, this.player);
        } else if (t == 0) {
            int r = s.canUse(this, this.player);
            if (r == -1) {
                this.player.func_145747_a((IChatComponent)new ChatComponentTranslation("text.vampirism.skill.deactivated_by_serveradmin", new Object[0]));
            } else if (r == 0) {
                this.player.func_145747_a((IChatComponent)new ChatComponentTranslation("text.vampirism.skill.level_to_low", new Object[0]));
            } else if (r == 1 && s.onActivated(this, this.player)) {
                if (s instanceof ILastingSkill) {
                    ILastingSkill ls = (ILastingSkill)s;
                    this.skillTimer[i] = ls.getDuration(this.getLevel());
                } else {
                    this.skillTimer[i] = -s.getCooldown();
                }
            }
        } else {
            this.player.func_145747_a((IChatComponent)new ChatComponentTranslation("text.vampirism.skill.cooldown_not_over", new Object[0]));
        }
        this.dirty = true;
    }

    public void onToggleAutoFillBlood() {
        if (this.autoFillBlood) {
            this.autoFillBlood = false;
            this.player.func_145747_a((IChatComponent)new ChatComponentTranslation("text.vampirism.auto_fill_disabled", new Object[0]));
        } else {
            this.autoFillBlood = true;
            this.player.func_145747_a((IChatComponent)new ChatComponentTranslation("text.vampirism.auto_fill_enabled", new Object[0]));
        }
    }

    public void onToggleVision() {
        if (this.getLevel() == 0) {
            this.player.func_145747_a((IChatComponent)new ChatComponentTranslation("text.vampirism.skill.level_to_low", new Object[0]));
            return;
        }
        int v = this.getVision() + 1;
        if (v == 2 && Configs.disable_blood_vision) {
            ++v;
        }
        if (v > 2) {
            v = 0;
        }
        this.setVision(v);
        this.sync(false);
        if (v == 0) {
            this.player.func_145747_a((IChatComponent)new ChatComponentTranslation("text.vampirism.normal_vision", new Object[0]));
        } else if (v == 1) {
            this.player.func_145747_a((IChatComponent)new ChatComponentTranslation("text.vampirism.night_vision", new Object[0]));
        } else {
            this.player.func_145747_a((IChatComponent)new ChatComponentTranslation("text.vampirism.blood_vision", new Object[0]));
        }
    }

    public void onUpdate() {
        ItemStack held;
        if (this.sleepingCoffin && this.player.func_70608_bn()) {
            this.player.field_70181_x = !this.player.field_70170_p.field_72995_K ? 0.0 : (this.player.field_70163_u > Math.floor(this.player.field_70163_u) + 0.2 ? -0.05 : 0.0);
        }
        if (this.vampireLord && !this.player.field_70170_p.field_72995_K && this.getLevel() < 14) {
            VampireLordData.get(this.player.field_70170_p).makeNoLord(this.player, "text.vampirism.lord.level_to_low");
        }
        if (this.getLevel() <= 0) {
            PotionEffect sang = this.player.func_70660_b(ModPotion.sanguinare);
            if (sang != null && sang.func_76459_b() == 1) {
                this.levelUp();
                this.player.func_70690_d(new PotionEffect(ModPotion.saturation.field_76415_H, 300, 2));
                this.player.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, 300));
            }
            return;
        }
        this.bloodStats.onUpdate();
        this.minionHandler.checkMinions();
        if (!this.player.field_70170_p.field_72995_K) {
            if (this.gettingSundamage()) {
                this.handleSunDamage();
            } else if (this.ticksInSun > 0) {
                --this.ticksInSun;
            }
            if (this.player.field_70173_aa % 10 == 0 && this.isInStrongGarlic()) {
                this.player.func_70690_d(new PotionEffect(ModPotion.garlic.field_76415_H, 60, 1));
            }
            if (this.biteCooldown > 0) {
                --this.biteCooldown;
            }
            if (this.player.func_82165_m(ModPotion.sanguinare.field_76415_H)) {
                this.player.func_82170_o(ModPotion.sanguinare.field_76415_H);
            }
            if (this.sleepingCoffin && !this.player.field_70170_p.func_72935_r()) {
                this.wakeUpPlayer(true, false, true, true);
            }
        } else if (this.gettingSundamage()) {
            if (this.ticksInSun < 101) {
                ++this.ticksInSun;
            }
        } else if (this.ticksInSun > 0) {
            --this.ticksInSun;
        }
        for (int i = 0; i < this.skillTimer.length; ++i) {
            int t = this.skillTimer[i];
            if (t == 0) continue;
            if (t < 0) {
                this.skillTimer[i] = ++t;
                continue;
            }
            this.skillTimer[i] = --t;
            ILastingSkill s = (ILastingSkill)Skills.getSkill(i);
            if (t == 0) {
                this.skillTimer[i] = -s.getCooldown();
                if (this.isRemote()) continue;
                s.onDeactivated(this, this.player);
                this.dirty = true;
                continue;
            }
            if (!s.onUpdate(this, this.player)) continue;
            this.skillTimer[i] = 1;
        }
        if (this.batTransformed != this.isSkillActive(Skills.batMode)) {
            this.batTransformed = !this.batTransformed;
            VampirismMod.proxy.setPlayerBat(this.player, this.batTransformed);
        }
        if (this.minionTarget != null && !this.minionTarget.func_70089_S()) {
            this.minionTarget = null;
        }
        if ((held = this.player.func_70694_bm()) != null && GarlicHelper.getGarlicValue(held) > 0) {
            this.player.func_70690_d(new PotionEffect(ModPotion.garlic.field_76415_H, 50, 0));
        }
        if (this.dirty && !this.player.field_70170_p.field_72995_K) {
            this.sync(true);
            this.dirty = false;
        }
    }

    public void saveNBTData(NBTTagCompound compound) {
        NBTTagCompound properties = new NBTTagCompound();
        properties.func_74768_a("level", this.getLevel());
        properties.func_74768_a("blood", this.getBlood());
        properties.func_74783_a("skills", this.skillTimer);
        properties.func_74757_a("autofill", this.isAutoFillBlood());
        properties.func_74768_a(KEY_VISION, this.getVision());
        properties.func_74782_a("extra", (NBTBase)this.extraData);
        properties.func_74782_a(KEY_MINIONS, (NBTBase)this.minionHandler.getMinionsToSave());
        properties.func_74772_a(KEY_COMEBACK_CALL, this.lastRemoteMinionComebackCall);
        this.bloodStats.writeNBT(properties);
        compound.func_74782_a("VampirePlayer", (NBTBase)properties);
    }

    private void setAutoFillBlood(boolean value) {
        this.autoFillBlood = value;
    }

    private synchronized void setBloodData(int b) {
        this.player.func_70096_w().func_75692_b(Configs.player_blood_watcher, (Object)b);
    }

    public void setLevel(int l) {
        if (l >= 0) {
            this.level = l;
            PlayerModifiers.applyModifiers(l, this.player);
            this.sync(true);
        }
    }

    public boolean setVampireLord(boolean state) {
        if (state && this.getLevel() < 14) {
            Logger.w("VampirePlayer", "Cannot become a vampire lord since the player has not reached the highest level", new Object[0]);
            return false;
        }
        if (state != this.vampireLord) {
            this.player.func_71064_a((StatBase)Achievements.becomingALord, 1);
            this.vampireLord = state;
            this.player.refreshDisplayName();
            this.sync(true);
        }
        return true;
    }

    private void setVision(int vision) {
        this.vision = vision;
    }

    public EntityPlayer.EnumStatus sleepInCoffinAt(int x, int y, int z) {
        if (!this.player.field_70170_p.field_72995_K) {
            if (this.sleepingCoffin || !this.isTheEntityAlive()) {
                Logger.w("VampirePlayer", "Player seems to be either already sleeping or dead", new Object[0]);
                return EntityPlayer.EnumStatus.OTHER_PROBLEM;
            }
            if (!this.player.field_70170_p.field_73011_w.func_76569_d()) {
                Logger.w("VampirePlayer", "Not possible here", new Object[0]);
                return EntityPlayer.EnumStatus.NOT_POSSIBLE_HERE;
            }
            if (!this.player.field_70170_p.func_72935_r()) {
                return EntityPlayer.EnumStatus.NOT_POSSIBLE_NOW;
            }
            if (Math.abs(this.player.field_70165_t - (double)x) > 3.0 || Math.abs(this.player.field_70163_u - (double)y) > 2.0 || Math.abs(this.player.field_70161_v - (double)z) > 3.0) {
                return EntityPlayer.EnumStatus.TOO_FAR_AWAY;
            }
            double d0 = 8.0;
            double d1 = 5.0;
            List list = this.player.field_70170_p.func_82733_a(EntityMob.class, AxisAlignedBB.func_72330_a((double)((double)x - d0), (double)((double)y - d1), (double)((double)z - d0), (double)((double)x + d0), (double)((double)y + d1), (double)((double)z + d0)), new IEntitySelector(){

                public boolean func_82704_a(Entity entity) {
                    if (!(entity instanceof EntityMob)) {
                        return false;
                    }
                    if (entity instanceof IMinion) {
                        return !(((IMinion)entity).getLord() instanceof EntityPlayer);
                    }
                    if (VampireMob.get((EntityCreature)((EntityMob)entity)).isMinion()) {
                        return !(VampireMob.get((EntityCreature)((EntityMob)entity)).getLord() instanceof EntityPlayer);
                    }
                    if (entity instanceof EntityVampire) {
                        return VampirePlayer.this.getLevel() <= BALANCE.VAMPIRE_FRIENDLY_LEVEL || VampirePlayer.this.isVampireLord();
                    }
                    if (entity instanceof EntityVampireHunter) {
                        return VampirePlayer.this.getLevel() >= BALANCE.VAMPIRE_HUNTER_ATTACK_LEVEL;
                    }
                    return true;
                }
            });
            if (!list.isEmpty()) {
                return EntityPlayer.EnumStatus.NOT_SAFE;
            }
        }
        if (this.player.func_70115_ae()) {
            this.player.func_70078_a(null);
        }
        Helper.Reflection.callMethod(Entity.class, this.player, Helper.Obfuscation.getPosNames("EntityPlayer/setSize"), new Class[]{Float.TYPE, Float.TYPE}, Float.valueOf(0.2f), Float.valueOf(0.2f));
        this.player.field_70129_M = 0.2f;
        if (this.player.field_70170_p.func_72899_e(x, y, z)) {
            int direction = ((BlockCoffin)this.player.field_70170_p.func_147439_a(x, y, z)).getDirection(this.player.field_70170_p, x, y, z);
            float xOffset = 0.5f;
            float zOffset = 0.5f;
            float yOffset = 0.5f;
            switch (direction) {
                case 0: {
                    zOffset = 1.8f;
                    break;
                }
                case 3: {
                    xOffset = 1.8f;
                    break;
                }
                case 2: {
                    zOffset = -0.8f;
                    break;
                }
                case 1: {
                    xOffset = -0.8f;
                }
            }
            this.func_71013_b(direction);
            this.player.func_70107_b((double)((float)x + xOffset), (double)((float)y + yOffset), (double)((float)z + zOffset));
            Logger.i("VampirePlayer", String.format("Setting player position, xOffset=%.3f, yOffset=%.3f, zOffset=%.3f", Float.valueOf(xOffset), Float.valueOf(yOffset), Float.valueOf(zOffset)), new Object[0]);
        } else {
            this.player.func_70107_b((double)((float)x + 0.5f), (double)((float)y + 0.9375f), (double)((float)z + 0.5f));
            Logger.i("VampirePlayer", "blockExists(x,y,z) was false, standard offsets", new Object[0]);
        }
        S0APacketUseBed s0apacketusebed = new S0APacketUseBed(this.player, x, y, z);
        ((EntityPlayerMP)this.player).func_71121_q().func_73039_n().func_151247_a((Entity)this.player, (Packet)s0apacketusebed);
        ((EntityPlayerMP)this.player).field_71135_a.func_147364_a(((EntityPlayerMP)this.player).field_70165_t, ((EntityPlayerMP)this.player).field_70163_u, ((EntityPlayerMP)this.player).field_70161_v, ((EntityPlayerMP)this.player).field_70177_z, ((EntityPlayerMP)this.player).field_70125_A);
        ((EntityPlayerMP)this.player).field_71135_a.func_147359_a((Packet)s0apacketusebed);
        Helper.Reflection.setPrivateField(EntityPlayer.class, this.player, true, Helper.Obfuscation.getPosNames("EntityPlayer/sleeping"));
        this.sleepingCoffin = true;
        Logger.i("VampirePlayer", "sleepingCoffin=" + this.sleepingCoffin, new Object[0]);
        Helper.Reflection.setPrivateField(EntityPlayer.class, this.player, 0, Helper.Obfuscation.getPosNames("EntityPlayer/sleepTimer"));
        this.player.field_71081_bT = new ChunkCoordinates(x, y, z);
        this.player.field_70181_x = 0.0;
        this.player.field_70179_y = 0.0;
        this.player.field_70159_w = 0.0;
        if (!this.player.field_70170_p.field_72995_K) {
            this.player.field_70170_p.func_72854_c();
        }
        VampirePlayer.get(this.player).sync(true);
        return EntityPlayer.EnumStatus.OK;
    }

    public void biteEntity(EntityLivingBase e) {
        if (e.field_70170_p.field_72995_K) {
            return;
        }
        if (this.getLevel() == 0) {
            return;
        }
        if (this.biteCooldown > 0) {
            return;
        }
        int blood = 0;
        BITE_TYPE type = this.determineByteType(e);
        if (type == BITE_TYPE.MAKE_MINION) {
            this.makeVampireToMinion((EntityVampire)e);
        } else if (type == BITE_TYPE.SUCK_BLOOD_PLAYER) {
            blood = VampirePlayer.get((EntityPlayer)e).bite();
        } else if (type == BITE_TYPE.SUCK_BLOOD) {
            blood = VampireMob.get((EntityCreature)e).bite(this.canTurnOthers());
        } else if (type == BITE_TYPE.ATTACK) {
            e.func_70097_a(DamageSource.func_76365_a((EntityPlayer)this.player), (float)BALANCE.VAMPIRE_PLAYER_BITE_DMG);
            if (this.player.func_70681_au().nextInt(4) == 0) {
                this.player.func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, 60));
            }
        } else if (type == BITE_TYPE.NONE) {
            return;
        }
        this.biteCooldown = 15;
        if (blood <= 0) {
            return;
        }
        if (blood > 0) {
            int amt = this.bloodStats.addBlood(blood);
            if (amt > 0 && this.isAutoFillBlood()) {
                this.fillBloodIntoInventory(amt);
            }
            this.player.func_71064_a((StatBase)Achievements.suckingBlood, 1);
            VampirismMod.modChannel.sendToAll((IMessage)new SpawnParticlePacket("magicCrit", e.field_70165_t, e.field_70163_u, e.field_70161_v, this.player.field_70165_t - e.field_70165_t, this.player.field_70163_u - e.field_70163_u, this.player.field_70161_v - e.field_70161_v, 10));
            VampirismMod.modChannel.sendTo((IMessage)new SpawnParticlePacket("blood_eat", 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10), (EntityPlayerMP)this.player);
        }
    }

    public BITE_TYPE determineByteType(EntityLivingBase entity) {
        VampireMob mob;
        if (entity instanceof EntityVampire && this.isVampireLord()) {
            PotionEffect p1 = entity.func_70660_b(Potion.field_76421_d);
            PotionEffect p2 = entity.func_70660_b(Potion.field_76430_j);
            if (p1 != null && p1.func_76458_c() == 10 || p2 != null && p2.func_76458_c() == 128) {
                return BITE_TYPE.MAKE_MINION;
            }
        }
        if (entity instanceof EntityPlayer) {
            if (((EntityPlayer)entity).field_71075_bZ.field_75098_d || !MinecraftServer.func_71276_C().func_71219_W()) {
                return BITE_TYPE.NONE;
            }
            if (this.canTurnOthers() && !Helper.canReallySee(entity, (EntityLivingBase)this.player, false)) {
                return BITE_TYPE.SUCK_BLOOD_PLAYER;
            }
            return BITE_TYPE.ATTACK;
        }
        if (entity instanceof EntityCreature && (mob = VampireMob.get((EntityCreature)entity)).getBlood() > 0) {
            return BITE_TYPE.SUCK_BLOOD;
        }
        return BITE_TYPE.ATTACK;
    }

    public void biteEntity(int entityId) {
        Entity e = this.player.field_70170_p.func_73045_a(entityId);
        if (e != null && e instanceof EntityLivingBase) {
            if ((double)e.func_70032_d((Entity)this.player) <= ((EntityPlayerMP)this.player).field_71134_c.getBlockReachDistance() + 2.0) {
                this.biteEntity((EntityLivingBase)e);
            } else {
                Logger.w("VampirePlayer", "Entity sent by client is not in reach " + entityId, new Object[0]);
            }
        }
    }

    private int bite() {
        if (this.getLevel() == 0) {
            int amt = this.player.func_71024_bL().func_75116_a();
            this.player.func_71020_j(10000.0f);
            this.player.func_70690_d(new PotionEffect(Potion.field_76438_s.field_76415_H, 1000, 50));
            if (!this.player.func_70644_a(ModPotion.sanguinare)) {
                this.player.func_70690_d(new PotionEffect(ModPotion.sanguinare.field_76415_H, BALANCE.VAMPIRE_PLAYER_SANGUINARE_DURATION * 20));
            }
            return amt;
        }
        int amt = this.getBloodStats().getBloodLevel();
        this.getBloodStats().consumeBlood(amt);
        return amt;
    }

    public void sync(boolean all) {
        if (!this.player.field_70170_p.field_72995_K && this.player instanceof EntityPlayerMP) {
            if (all) {
                Helper.sendPacketToPlayersAround(new UpdateEntityPacket(this), (Entity)this.player);
            } else {
                VampirismMod.modChannel.sendTo((IMessage)new UpdateEntityPacket(this), (EntityPlayerMP)this.player);
            }
        }
    }

    public void wakeUpPlayer(boolean vanilla, boolean immediately, boolean updateWorld, boolean setSpawn) {
        this.sleepingCoffin = false;
        this.sync(true);
        if (vanilla) {
            this.player.func_70999_a(immediately, updateWorld, setSpawn);
        }
    }

    public void refreshVampireLordState() {
        if (this.player.field_70170_p != null && !this.player.field_70170_p.field_72995_K) {
            boolean old = this.vampireLord;
            this.vampireLord = VampireLordData.get(this.player.field_70170_p).isLord(this.player);
            if (old != this.vampireLord) {
                this.player.refreshDisplayName();
            }
        }
    }

    @Override
    public void writeFullUpdateToNBT(NBTTagCompound tag) {
        tag.func_74768_a("level", this.getLevel());
        tag.func_74783_a("timers", this.skillTimer);
        tag.func_74757_a("lord", this.isVampireLord());
        tag.func_74757_a("sleepingCoffin", this.sleepingCoffin);
        tag.func_74768_a(KEY_VISION, this.getVision());
    }

    public boolean canTurnOthers() {
        return this.getLevel() >= BALANCE.VAMPIRE_PLAYER_MIN_TURN_LEVEL;
    }

    public static enum BITE_TYPE {
        ATTACK,
        SUCK_BLOOD,
        SUCK_BLOOD_PLAYER,
        MAKE_MINION,
        NONE;

    }

    public class BloodStats {
        private float bloodExhaustionLevel;
        private float bloodSaturationLevel;
        private int bloodTimer;
        private int prevBloodLevel;
        private int bloodToAdd;
        private final float maxExhaustion = 40.0f;

        public int addBlood(int amount) {
            int oldBlood = VampirePlayer.this.getBlood();
            int bloodToAdd = Math.min(amount, 20 - oldBlood);
            this.changeBlood(bloodToAdd);
            this.bloodSaturationLevel = (float)Math.min((double)this.bloodSaturationLevel + (double)bloodToAdd * BALANCE.BLOOD_SATURATION * 2.0, (double)(oldBlood + bloodToAdd));
            int bloodLeft = amount - bloodToAdd;
            return bloodLeft;
        }

        public void addExhaustion(float amount) {
            if (VampirePlayer.this.isSkillActive(Skills.vampireRage)) {
                amount *= 1.5f;
            }
            if (BALANCE.INCREASE_BLOOD_USAGE) {
                float f = (float)VampirePlayer.this.getLevel() / 14.0f + 1.0f;
                amount *= f;
            }
            this.bloodExhaustionLevel = Math.min(this.bloodExhaustionLevel + amount, 40.0f);
        }

        private void changeBlood(int amount) {
            this.bloodToAdd += amount;
        }

        public boolean consumeBlood(int a) {
            int blood = VampirePlayer.this.getBlood();
            int bloodToRemove = Math.min(a, blood);
            this.changeBlood(-bloodToRemove);
            return bloodToRemove <= blood;
        }

        public int getBloodLevel() {
            return VampirePlayer.this.getBlood();
        }

        @SideOnly(value=Side.CLIENT)
        public int getPrevBloodLevel() {
            return this.prevBloodLevel;
        }

        private synchronized void onUpdate() {
            if (((VampirePlayer)VampirePlayer.this).player.field_70170_p.field_72995_K) {
                return;
            }
            if (VampirePlayer.this.player.func_71024_bL().func_75116_a() < 10) {
                VampirePlayer.this.player.func_71024_bL().func_75122_a(5, 1.0f);
            }
            EnumDifficulty enumdifficulty = ((VampirePlayer)VampirePlayer.this).player.field_70170_p.field_73013_u;
            int newBloodLevel = VampirePlayer.this.getBlood();
            if ((newBloodLevel = Math.min(newBloodLevel + this.bloodToAdd, 20)) < 0) {
                newBloodLevel = 0;
            }
            this.bloodToAdd = 0;
            int playerSaturation = 1;
            if (VampirePlayer.this.player.func_82165_m(ModPotion.saturation.field_76415_H)) {
                playerSaturation = VampirePlayer.this.player.func_70660_b(ModPotion.saturation).func_76458_c() + 2;
            }
            if (this.bloodExhaustionLevel > (float)(BALANCE.BLOOD_EXH_PER_BL * playerSaturation)) {
                this.bloodExhaustionLevel -= (float)(BALANCE.BLOOD_EXH_PER_BL * playerSaturation);
                if (this.bloodSaturationLevel > 0.0f) {
                    this.bloodSaturationLevel = Math.max(this.bloodSaturationLevel - 1.0f, 0.0f);
                } else if (enumdifficulty != EnumDifficulty.PEACEFUL) {
                    newBloodLevel = Math.max(newBloodLevel - 1, 0);
                }
            }
            if (((VampirePlayer)VampirePlayer.this).player.field_70170_p.func_82736_K().func_82766_b("naturalRegeneration") && (double)newBloodLevel >= 18.0 && VampirePlayer.this.player.func_70996_bM()) {
                ++this.bloodTimer;
                if (this.bloodTimer >= 80) {
                    VampirePlayer.this.player.func_70691_i(1.0f);
                    this.addExhaustion(3.0f);
                    this.bloodTimer = 0;
                }
            } else if (newBloodLevel <= 0) {
                ++this.bloodTimer;
                if (this.bloodTimer >= 80) {
                    if (VampirePlayer.this.player.func_110143_aJ() > 10.0f || enumdifficulty == EnumDifficulty.HARD || VampirePlayer.this.player.func_110143_aJ() > 1.0f && enumdifficulty == EnumDifficulty.NORMAL) {
                        VampirePlayer.this.player.func_70097_a(DamageSource.field_76366_f, 1.0f);
                    }
                    this.bloodTimer = 0;
                }
            } else {
                this.bloodTimer = 0;
            }
            VampirePlayer.this.setBloodData(newBloodLevel);
        }

        private void readNBT(NBTTagCompound nbt) {
            if (nbt.func_74764_b("bloodTimer")) {
                this.bloodTimer = nbt.func_74762_e("bloodTimer");
                this.bloodExhaustionLevel = nbt.func_74760_g("bloodExhaustionLevel");
                this.bloodSaturationLevel = nbt.func_74760_g("bloodSaturationLevel");
            }
        }

        private void writeNBT(NBTTagCompound nbt) {
            nbt.func_74768_a("bloodTimer", this.bloodTimer);
            nbt.func_74776_a("bloodExhaustionLevel", this.bloodExhaustionLevel);
            nbt.func_74776_a("bloodSaturationlevel", this.bloodSaturationLevel);
        }
    }
}

