/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.generation.castle;

import de.teamlapen.vampirism.generation.castle.BlockList;
import de.teamlapen.vampirism.generation.castle.Extra;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.world.World;

public class BuildingTile {
    private List<BlockList> blocks;
    private List<Extra> extras;

    public BuildingTile(List<BlockList> blocks, List<Extra> extras) {
        this.blocks = blocks;
        this.extras = extras;
    }

    public BuildingTile() {
        this.blocks = new LinkedList<BlockList>();
        this.extras = new LinkedList<Extra>();
    }

    public void build(int cx, int cz, World world, int groundHeight, int rotation) {
        int x = cx << 4;
        int z = cz << 4;
        for (BlockList l : this.blocks) {
            List<BlockList.BlockPosition> pos = l.getPositions();
            for (BlockList.BlockPosition p : pos) {
                p = this.rotatePosition(rotation, p);
                world.func_147465_d(x + p.x, groundHeight + p.y, z + p.z, l.block, l.getBlockMetaForRotation(rotation), 0);
            }
        }
        for (Extra extra : this.extras) {
            BlockList.BlockPosition p = extra.pos;
            p = this.rotatePosition(rotation, p);
            extra.applyExtra(world, x + p.x, groundHeight + p.y, z + p.z);
        }
    }

    private BlockList.BlockPosition rotatePosition(int rotation, BlockList.BlockPosition pos) {
        switch (rotation) {
            case 1: {
                return new BlockList.BlockPosition(15 - pos.z, pos.y, pos.x);
            }
            case 2: {
                return new BlockList.BlockPosition(15 - pos.x, pos.y, 15 - pos.z);
            }
            case 3: {
                return new BlockList.BlockPosition(pos.z, pos.y, 15 - pos.x);
            }
        }
        return pos;
    }

    public void finishLoading() {
        for (BlockList l : this.blocks) {
            l.finishLoad();
        }
    }
}

