/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.generation.villages;

import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import de.teamlapen.vampirism.Configs;
import de.teamlapen.vampirism.ModBiomes;
import de.teamlapen.vampirism.generation.villages.BiomeBlockReplacer;
import de.teamlapen.vampirism.generation.villages.BiomeRegistrant;
import de.teamlapen.vampirism.generation.villages.ConfigHandler;
import de.teamlapen.vampirism.util.Logger;
import java.io.File;
import java.util.regex.Pattern;
import net.minecraftforge.common.MinecraftForge;

public class VillageBiomes {
    public static void postInit(FMLPostInitializationEvent ev) {
        if (Configs.disable_village_biome) {
            return;
        }
        BiomeRegistrant.init();
        for (String name : ConfigHandler.getAddBiomes()) {
            if (Pattern.matches("\\d+", name)) {
                BiomeRegistrant.addBiomeById(Integer.parseInt(name));
                continue;
            }
            BiomeRegistrant.addBiomeByName(name);
        }
        for (String name : ConfigHandler.getAddTypes()) {
            Logger.d("VillageBiomes", "Adding all %s biomes as village biomes.", name);
            BiomeRegistrant.addBiomesByTypeName(name);
        }
        for (String name : ConfigHandler.getRemoveBiomes()) {
            if (Pattern.matches("\\d+", name)) {
                BiomeRegistrant.removeBiomeById(Integer.parseInt(name));
                continue;
            }
            BiomeRegistrant.removeBiomeByName(name);
        }
        for (String name : ConfigHandler.getRemoveTypes()) {
            Logger.d("VillageBiomes", "Removing all " + name + " biomes from village biomes.", new Object[0]);
            BiomeRegistrant.removeBiomesByTypeName(name);
        }
        if (!Configs.disable_vampire_biome) {
            BiomeRegistrant.removeBiome(ModBiomes.biomeVampireForest);
        }
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)new BiomeBlockReplacer());
    }

    public static void preInit(FMLPreInitializationEvent event) {
        if (Configs.disable_village_biome) {
            return;
        }
        File ConfigFile = new File(event.getModConfigurationDirectory(), "vampirism_village_biomes.cfg");
        ConfigHandler.loadConfig(ConfigFile);
    }
}

