/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.guide;

import amerifrance.guideapi.api.abstraction.CategoryAbstract;
import amerifrance.guideapi.api.abstraction.EntryAbstract;
import amerifrance.guideapi.api.base.Book;
import amerifrance.guideapi.api.base.PageBase;
import amerifrance.guideapi.gui.GuiBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

public class PageTable
extends PageBase {
    private List<String[]> lines;
    private int[] width;
    private String headline;

    private PageTable(List<String[]> lines, int[] width, String headline) {
        this.lines = lines;
        this.width = width;
        this.headline = headline;
    }

    @SideOnly(value=Side.CLIENT)
    public void draw(Book book, CategoryAbstract category, EntryAbstract entry, int guiLeft, int guiTop, int mouseX, int mouseY, GuiBase guiBase, FontRenderer fontRenderer) {
        fontRenderer.func_78264_a(true);
        int charWidth = fontRenderer.func_78263_a(' ');
        int y = guiTop + 12;
        int x = guiLeft + 39;
        if (this.headline != null) {
            fontRenderer.func_78276_b("\u00a7l" + this.headline, x, y, 0);
            y += fontRenderer.field_78288_b;
        }
        this.drawLine(x, y + fontRenderer.field_78288_b, (float)x + (float)guiBase.xSize * 3.0f / 5.0f, y + fontRenderer.field_78288_b, guiBase.publicZLevel);
        for (String[] l : this.lines) {
            x = guiLeft + 39;
            for (int i = 0; i < l.length; ++i) {
                int mw = this.width[i] * charWidth;
                int aw = fontRenderer.func_78256_a(l[i]);
                int dw = (mw - aw) / 2;
                fontRenderer.func_78276_b(l[i], x + dw, y, 0);
                x += mw;
            }
            y += fontRenderer.field_78288_b;
        }
        fontRenderer.func_78264_a(false);
    }

    protected void drawLine(double x1, double y1, double x2, double y2, float publicZLevel) {
        GL11.glPushMatrix();
        GL11.glDisable((int)3553);
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glLineWidth((float)2.0f);
        GL11.glBegin((int)1);
        GL11.glVertex3d((double)x1, (double)y1, (double)publicZLevel);
        GL11.glVertex3d((double)x2, (double)y2, (double)publicZLevel);
        GL11.glEnd();
        GL11.glEnable((int)3553);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    public static class Builder {
        int columns;
        List<String[]> lines;
        String headline;

        public Builder(int columns) {
            this.columns = columns;
            this.lines = new ArrayList<String[]>();
        }

        public Builder setHeadline(String s) {
            this.headline = s;
            return this;
        }

        public Builder addLine(Object ... objects) {
            if (objects.length != this.columns) {
                throw new IllegalArgumentException("Every added line as to contain one String for every column");
            }
            String[] l = new String[objects.length];
            for (int i = 0; i < objects.length; ++i) {
                l[i] = String.valueOf(objects[i]);
            }
            this.lines.add(l);
            return this;
        }

        public Builder addUnlocLine(String ... strings) {
            String[] loc = new String[strings.length];
            for (int i = 0; i < strings.length; ++i) {
                loc[i] = StatCollector.func_74838_a((String)strings[i]);
            }
            return this.addLine(loc);
        }

        public PageTable build() {
            int[] width = new int[this.columns];
            for (int i = 0; i < this.columns; ++i) {
                int max = 0;
                for (String[] s : this.lines) {
                    int w = s[i].length();
                    if (w <= max) continue;
                    max = w;
                }
                width[i] = max;
            }
            return new PageTable(this.lines, width, this.headline);
        }
    }
}

