/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.item;

import de.teamlapen.vampirism.ModItems;
import de.teamlapen.vampirism.ModPotion;
import de.teamlapen.vampirism.entity.EntityVampireBase;
import de.teamlapen.vampirism.entity.player.VampirePlayer;
import de.teamlapen.vampirism.util.BALANCE;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.oredict.RecipeSorter;

public class GarlicHelper {
    public static void setMaxGarlic(ItemStack stack) {
        GarlicHelper.setGarlic(stack, BALANCE.GARLIC_WEAPON_EFFECT_DURABILITY);
    }

    public static void setGarlic(ItemStack stack, int value) {
        if (stack == null || value < 0) {
            return;
        }
        if (stack.func_77978_p() == null) {
            NBTTagCompound nbt = new NBTTagCompound();
            stack.func_77982_d(nbt);
        }
        stack.func_77978_p().func_74768_a("vampirism_garlic", value);
    }

    public static IRecipe createGarlicRecipe(final Item weapon) {
        ItemStack output = new ItemStack(weapon);
        GarlicHelper.setMaxGarlic(output);
        ArrayList<ItemStack> input = new ArrayList<ItemStack>();
        ItemStack w = new ItemStack(weapon);
        w.func_77964_b(Short.MAX_VALUE);
        input.add(w);
        input.add(new ItemStack((Item)ModItems.garlic));
        ShapelessRecipes recipe = new ShapelessRecipes(output, input){

            public ItemStack func_77572_b(InventoryCrafting inv) {
                for (int i = 0; i < inv.func_70302_i_(); ++i) {
                    ItemStack stack = inv.func_70301_a(i);
                    if (stack == null || !weapon.equals(stack.func_77973_b())) continue;
                    ItemStack out = this.func_77571_b().func_77946_l();
                    out.func_77964_b(inv.func_70301_a(i).func_77960_j());
                    return out;
                }
                return super.func_77572_b(inv);
            }
        };
        RecipeSorter.register((String)"vampirism:garlicsword", recipe.getClass(), (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
        return recipe;
    }

    public static int getGarlicValue(ItemStack stack) {
        if (stack != null && stack.func_77942_o()) {
            return stack.func_77978_p().func_74762_e("vampirism_garlic");
        }
        return 0;
    }

    public static void onPlayerAttackedEntity(EntityPlayer player, Entity target) {
        int i;
        ItemStack stack = player.func_71045_bC();
        if (stack == null || !(target instanceof EntityLivingBase)) {
            return;
        }
        if (target.func_70075_an() && (i = GarlicHelper.getGarlicValue(stack)) > 0) {
            if (target instanceof EntityVampireBase || target instanceof EntityPlayer && VampirePlayer.get((EntityPlayer)target).getLevel() > 0) {
                ((EntityLivingBase)target).func_70690_d(new PotionEffect(ModPotion.garlic.field_76415_H, 60, 0));
            }
            GarlicHelper.setGarlic(stack, --i);
        }
    }
}

