/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import de.teamlapen.vampirism.entity.minions.IMinion;
import de.teamlapen.vampirism.entity.minions.MinionHelper;
import de.teamlapen.vampirism.entity.player.VampirePlayer;
import de.teamlapen.vampirism.util.Logger;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.DamageSource;

public class InputEventPacket
implements IMessage {
    public static String SUCKBLOOD = "sb";
    public static String TOGGLEAUTOFILLBLOOD = "ta";
    public static String REVERTBACK = "rb";
    public static String TOGGLESKILL = "ts";
    public static String LEAVE_COFFIN = "lc";
    public static String MINION_CONTROL = "mc";
    private static final String TAG = "InputEventPacket";
    public static final String SWITCHVISION = "sw";
    private String param;
    private String action;
    private final String SPLIT = "-";

    public InputEventPacket() {
    }

    public InputEventPacket(String action, String param) {
        this.action = action;
        this.param = param;
    }

    public void fromBytes(ByteBuf buf) {
        String[] s = ByteBufUtils.readUTF8String((ByteBuf)buf).split("-");
        this.action = s[0];
        this.param = s.length > 1 ? s[1] : "";
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)(this.action + "-" + this.param));
    }

    public static class Handler
    implements IMessageHandler<InputEventPacket, IMessage> {
        public IMessage onMessage(InputEventPacket message, MessageContext ctx) {
            if (message.action == null) {
                return null;
            }
            if (message.action.equals(SUCKBLOOD)) {
                int id = 0;
                try {
                    id = Integer.parseInt(message.param);
                }
                catch (NumberFormatException e) {
                    Logger.e(InputEventPacket.TAG, "Receiving invalid param", e);
                }
                if (id != 0) {
                    EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                    VampirePlayer.get((EntityPlayer)player).biteEntity(id);
                }
            } else if (message.action.equals(TOGGLEAUTOFILLBLOOD)) {
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                VampirePlayer.get((EntityPlayer)player).onToggleAutoFillBlood();
            } else if (message.action.equals(REVERTBACK)) {
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                VampirePlayer.get((EntityPlayer)player).setLevel(0);
                player.func_70097_a(DamageSource.field_76376_m, 1000.0f);
            } else if (message.action.equals(InputEventPacket.SWITCHVISION)) {
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                VampirePlayer.get((EntityPlayer)player).onToggleVision();
            } else if (message.action.equals(TOGGLESKILL)) {
                int id = -1;
                try {
                    id = Integer.parseInt(message.param);
                }
                catch (NumberFormatException e) {
                    Logger.e(InputEventPacket.TAG, "Receiving invalid param", e);
                }
                if (id >= 0) {
                    EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                    VampirePlayer.get((EntityPlayer)player).onSkillToggled(id);
                } else {
                    Logger.w(InputEventPacket.TAG, "Skill with id " + id + " does not exist", new Object[0]);
                }
            } else if (message.action.equals(LEAVE_COFFIN)) {
                VampirePlayer.get((EntityPlayer)ctx.getServerHandler().field_147369_b).wakeUpPlayer(true, false, true, true);
            } else if (message.action.equals(MINION_CONTROL)) {
                try {
                    if (message.param.contains(",")) {
                        String[] p = message.param.split(",");
                        int cid = Integer.parseInt(p[0]);
                        int eid = Integer.parseInt(p[1]);
                        IMinion m = MinionHelper.getMinionFromEntity(ctx.getServerHandler().field_147369_b.field_70170_p.func_73045_a(eid));
                        if (m != null) {
                            Logger.i(InputEventPacket.TAG, "Activated command %s", m.getCommand(cid));
                            m.activateMinionCommand(m.getCommand(cid));
                        } else {
                            Logger.w(InputEventPacket.TAG, "Trying to activate command %s for enityid %s. But the entity cannot be found", cid, eid);
                        }
                    } else {
                        int id = Integer.parseInt(message.param);
                        VampirePlayer.get((EntityPlayer)ctx.getServerHandler().field_147369_b).onCallActivated(id);
                    }
                }
                catch (NumberFormatException e) {
                    Logger.e(InputEventPacket.TAG, "Receiving invalid param", e);
                }
            }
            return null;
        }
    }
}

