/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import de.teamlapen.vampirism.network.ISyncable;
import de.teamlapen.vampirism.network.UpdateEntityPacket;
import de.teamlapen.vampirism.util.Logger;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;

public class RequestEntityUpdatePacket
implements IMessage {
    private int id;

    public RequestEntityUpdatePacket() {
    }

    public RequestEntityUpdatePacket(Entity entity) {
        if (UpdateEntityPacket.Handler.tryToGetISyncable(entity) == null) {
            throw new IllegalArgumentException("You cannot request an update for this entity. The entity has to implement ISyncable or be a Player");
        }
        this.id = entity.func_145782_y();
    }

    public void fromBytes(ByteBuf buf) {
        this.id = ByteBufUtils.readTag((ByteBuf)buf).func_74762_e("id");
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("id", this.id);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
    }

    public static class Handler
    implements IMessageHandler<RequestEntityUpdatePacket, IMessage> {
        public IMessage onMessage(RequestEntityUpdatePacket message, MessageContext ctx) {
            Entity e = ctx.getServerHandler().field_147369_b.field_70170_p.func_73045_a(message.id);
            if (e != null) {
                ISyncable s = UpdateEntityPacket.Handler.tryToGetISyncable(e);
                if (s instanceof Entity) {
                    return new UpdateEntityPacket(e);
                }
                if (s instanceof UpdateEntityPacket.ISyncableExtendedProperties) {
                    return new UpdateEntityPacket((UpdateEntityPacket.ISyncableExtendedProperties)s);
                }
                Logger.w("ReqEntityUpdatePacket", "Entity " + e + " can't be synced", new Object[0]);
            }
            return null;
        }
    }
}

