/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.proxy;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import de.teamlapen.vampirism.ModPotion;
import de.teamlapen.vampirism.VampirismEventHandler;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.entity.EntityBlindingBat;
import de.teamlapen.vampirism.entity.EntityDeadMob;
import de.teamlapen.vampirism.entity.EntityDracula;
import de.teamlapen.vampirism.entity.EntityDummyBittenAnimal;
import de.teamlapen.vampirism.entity.EntityGarlicBomb;
import de.teamlapen.vampirism.entity.EntityGhost;
import de.teamlapen.vampirism.entity.EntityPortalGuard;
import de.teamlapen.vampirism.entity.EntityVampire;
import de.teamlapen.vampirism.entity.EntityVampireBaron;
import de.teamlapen.vampirism.entity.EntityVampireHunter;
import de.teamlapen.vampirism.entity.EntityVampireHunter2;
import de.teamlapen.vampirism.entity.VampireEntityEventHandler;
import de.teamlapen.vampirism.entity.convertible.BiteableRegistry;
import de.teamlapen.vampirism.entity.convertible.EntityConvertedCreature;
import de.teamlapen.vampirism.entity.convertible.EntityConvertedSheep;
import de.teamlapen.vampirism.entity.convertible.EntityConvertedVillager;
import de.teamlapen.vampirism.entity.minions.EntityRemoteVampireMinion;
import de.teamlapen.vampirism.entity.minions.EntitySaveableVampireMinion;
import de.teamlapen.vampirism.entity.player.VampirePlayer;
import de.teamlapen.vampirism.entity.player.VampirePlayerEventHandler;
import de.teamlapen.vampirism.item.ItemSpawnEgg;
import de.teamlapen.vampirism.proxy.IProxy;
import de.teamlapen.vampirism.util.BALANCE;
import de.teamlapen.vampirism.util.Logger;
import de.teamlapen.vampirism.util.TickRunnable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;

public abstract class CommonProxy
implements IProxy {
    public static final List<String> spawnableEntityNames = new ArrayList<String>();
    private List<TickRunnable> clientRunnables = new ArrayList<TickRunnable>();
    private List<TickRunnable> serverRunnables = new ArrayList<TickRunnable>();
    private int modEntityId = 0;

    @Override
    public void onTick(TickEvent event) {
        if (event instanceof TickEvent.ServerTickEvent) {
            WorldServer server = MinecraftServer.func_71276_C().func_71218_a(0);
            if (server.func_73056_e() && event.phase.equals((Object)TickEvent.Phase.START)) {
                Logger.i("ServerProxy", "All players are asleep", new Object[0]);
                if (server.field_73010_i.size() > 0) {
                    if (VampirePlayer.get((EntityPlayer)((EntityPlayer)server.field_73010_i.get((int)0))).sleepingCoffin) {
                        Logger.i("CommonProxy", "All players are sleeping in a coffin ->waking them up", new Object[0]);
                        long i = server.func_72820_D() + 24000L;
                        server.func_72877_b(i - i % 24000L - 11000L);
                        this.wakeAllPlayers(server);
                    } else {
                        Logger.i("CommonProxy", "All players are sleeping in a bed", new Object[0]);
                    }
                }
            }
            if (VampirismMod.potionFail && event.phase.equals((Object)TickEvent.Phase.END) && MinecraftServer.func_71276_C().func_71259_af() % 200 == 0) {
                MinecraftServer.func_71276_C().func_71203_ab().func_148539_a((IChatComponent)new ChatComponentText("There was a SEVERE error adding Vampirism's potions, please check and change the configured IDs of " + ModPotion.checkPotions()));
            }
            Iterator<TickRunnable> iterator = this.serverRunnables.iterator();
            while (iterator.hasNext()) {
                TickRunnable run = iterator.next();
                if (!run.shouldContinue()) {
                    iterator.remove();
                    continue;
                }
                run.onTick();
            }
            this.onServerTick((TickEvent.ServerTickEvent)event);
        } else if (event instanceof TickEvent.ClientTickEvent) {
            Iterator<TickRunnable> iterator = this.clientRunnables.iterator();
            while (iterator.hasNext()) {
                TickRunnable run = iterator.next();
                if (!run.shouldContinue()) {
                    iterator.remove();
                    continue;
                }
                run.onTick();
            }
            this.onClientTick((TickEvent.ClientTickEvent)event);
        }
    }

    protected void addTickRunnable(TickRunnable run, boolean client) {
        List<TickRunnable> list;
        List<TickRunnable> list2 = list = client ? this.clientRunnables : this.serverRunnables;
        if (list.size() > 100) {
            Logger.w("CommonProxy", "There are over 100 runnables in %s list. Deleting them.", client ? "client" : "server");
        }
        list.add(run);
    }

    public abstract void onClientTick(TickEvent.ClientTickEvent var1);

    public abstract void onServerTick(TickEvent.ServerTickEvent var1);

    private void registerEntity(Class<? extends Entity> clazz, String name, boolean egg) {
        Logger.d("EntityRegister", "Adding " + name + "(" + clazz.getSimpleName() + ") with mod id %d", this.modEntityId);
        EntityRegistry.registerModEntity(clazz, (String)name.replace("vampirism.", ""), (int)this.modEntityId++, (Object)VampirismMod.instance, (int)80, (int)1, (boolean)true);
        if (egg) {
            spawnableEntityNames.add(name);
        }
    }

    private void registerEntity(Class<? extends EntityLiving> clazz, String name, int probe, int min, int max, EnumCreatureType type, BiomeGenBase ... biomes) {
        this.registerEntity(clazz, name, true);
        Logger.d("EntityRegister", "Adding spawn with probe of " + probe, new Object[0]);
        EntityRegistry.addSpawn(clazz, (int)probe, (int)min, (int)max, (EnumCreatureType)type, (BiomeGenBase[])biomes);
    }

    @Override
    public void registerEntitys() {
        BiomeGenBase[] allBiomes = BiomeGenBase.func_150565_n();
        allBiomes = Arrays.copyOf(allBiomes, allBiomes.length);
        allBiomes[9] = null;
        allBiomes[8] = null;
        Object[] zombieBiomes = Arrays.copyOf(allBiomes, allBiomes.length);
        for (int i = 0; i < zombieBiomes.length; ++i) {
            Object b = zombieBiomes[i];
            if (b == null || b.func_150562_l().getName().startsWith("net.minecraft.")) continue;
            Iterator iterator = b.func_76747_a(EnumCreatureType.monster).iterator();
            boolean zombie = false;
            while (iterator.hasNext()) {
                if (!((BiomeGenBase.SpawnListEntry)iterator.next()).field_76300_b.equals(EntityZombie.class)) continue;
                zombie = true;
                break;
            }
            if (zombie) continue;
            Logger.d("EntitySpawn", "In biome %s no vampire will spawn", b);
            zombieBiomes[i] = null;
        }
        zombieBiomes = (BiomeGenBase[])Iterators.toArray((Iterator)Iterators.filter((Iterator)Iterators.forArray((Object[])zombieBiomes), (Predicate)Predicates.notNull()), BiomeGenBase.class);
        this.registerEntity(EntityVampireHunter.class, "vampirism.vampireHunter", true);
        this.registerEntity(EntityVampire.class, "vampirism.vampire", BALANCE.VAMPIRE_SPAWN_PROBE, 1, 3, EnumCreatureType.monster, (BiomeGenBase[])zombieBiomes);
        this.registerEntity(EntityVampireBaron.class, "vampirism.vampireBaron", true);
        EntityList.field_75625_b.put("vampirism.vampireLord", EntityVampireBaron.class);
        this.registerEntity(EntitySaveableVampireMinion.class, "vampirism.vampireMinionS", false);
        this.registerEntity(EntityRemoteVampireMinion.class, "vampirism.vampireMinionR", false);
        this.registerEntity(EntityDeadMob.class, "vampirism.dead_mob", false);
        this.registerEntity(EntityDracula.class, "vampirism.dracula", false);
        this.registerEntity(EntityGhost.class, "vampirism.ghost", true);
        this.registerEntity(EntityBlindingBat.class, "vampirism.blinding_bat", false);
        this.registerEntity(EntityDummyBittenAnimal.class, "vampirism.dummy_creature", false);
        this.registerEntity(EntityPortalGuard.class, "vampirism.portal_guard", false);
        this.registerEntity(EntityConvertedCreature.class, "vampirism.converted.creature", false);
        this.registerEntity(EntityConvertedVillager.class, "vampirism.converted.villager", false);
        this.registerEntity(EntityConvertedSheep.class, "vampirism.converted.sheep", false);
        this.registerEntity(EntityVampireHunter2.class, "vampirism.vampireHunter2", true);
        this.registerEntity(EntityGarlicBomb.class, "vampirism.garlicbomb", false);
        ItemSpawnEgg item = new ItemSpawnEgg(spawnableEntityNames);
        GameRegistry.registerItem((Item)item, (String)"spawn_egg");
        OreDictionary.registerOre((String)"mobEgg", (Item)item);
        this.registerConvertibles();
    }

    private void registerConvertibles() {
        String base = "vampirism:textures/entity/vanilla/%sOverlay.png";
        BiteableRegistry.addConvertible(EntityCow.class, String.format(base, "cow"));
        BiteableRegistry.addConvertible(EntityPig.class, String.format(base, "pig"));
        BiteableRegistry.addConvertible(EntityOcelot.class, String.format(base, "cat"));
        BiteableRegistry.addConvertible(EntityHorse.class, String.format(base, "horse"));
        BiteableRegistry.addConvertible(EntitySheep.class, String.format(base, "sheep"), new EntityConvertedSheep.ConvertingSheepHandler());
        BiteableRegistry.addConvertible(EntityVillager.class, String.format(base, "villager"), new EntityConvertedVillager.VillagerConvertingHandler());
    }

    @Override
    public void registerSubscriptions() {
        VampirePlayerEventHandler playerHandler = new VampirePlayerEventHandler();
        MinecraftForge.EVENT_BUS.register((Object)playerHandler);
        FMLCommonHandler.instance().bus().register((Object)playerHandler);
        MinecraftForge.EVENT_BUS.register((Object)new VampireEntityEventHandler());
        VampirismEventHandler handler = new VampirismEventHandler();
        MinecraftForge.EVENT_BUS.register((Object)handler);
        FMLCommonHandler.instance().bus().register((Object)handler);
    }

    private void wakeAllPlayers(WorldServer server) {
        for (EntityPlayerMP p : server.field_73010_i) {
            VampirePlayer.get((EntityPlayer)p).wakeUpPlayer(true, false, false, true);
        }
    }
}

