/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.tileEntity;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.entity.player.VampirePlayer;
import de.teamlapen.vampirism.network.SpawnCustomParticlePacket;
import de.teamlapen.vampirism.util.BALANCE;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;

public class TileEntityBloodAltar2
extends TileEntity {
    public static final int MAX_BLOOD = 100;
    public static final int MIN_LEVEL = 1;
    public static final int MAX_LEVEL = 3;
    private int bloodAmount = 0;
    private final String KEY_BLOOD_AMOUNT = "blood_amount";
    private int ritualTicksLeft = 0;
    private EntityPlayer ritualPlayer;
    private final int RITUAL_TIME = 60;

    public int addBlood(int amount) {
        int old = this.bloodAmount;
        this.bloodAmount += amount;
        if (this.bloodAmount > 100) {
            this.bloodAmount = 100;
        }
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return this.bloodAmount - old;
    }

    public int removeBlood(int maxAmount) {
        int amount = Math.min(maxAmount, this.bloodAmount);
        this.bloodAmount -= amount;
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return amount;
    }

    public int getBloodAmount() {
        return this.bloodAmount;
    }

    public Packet func_145844_m() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.func_145841_b(nbtTag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbtTag);
    }

    public int getMaxBlood() {
        return 100;
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.bloodAmount = nbt.func_74762_e("blood_amount");
    }

    public void startRitual(EntityPlayer p) {
        if (this.ritualTicksLeft > 0) {
            return;
        }
        VampirePlayer player = VampirePlayer.get(p);
        int level = player.getLevel();
        if (level < 1 || level > 3) {
            p.func_145747_a((IChatComponent)new ChatComponentTranslation("text.vampirism.ritual_level_wrong", new Object[0]));
            return;
        }
        int neededBlood = BALANCE.LEVELING.A2_getRequiredBlood(level);
        if (this.bloodAmount < neededBlood) {
            p.func_146105_b((IChatComponent)new ChatComponentTranslation("text.vampirism.not_enough_blood", new Object[0]));
            return;
        }
        NBTTagCompound data = new NBTTagCompound();
        data.func_74768_a("player_id", p.func_145782_y());
        VampirismMod.modChannel.sendToAll((IMessage)new SpawnCustomParticlePacket(0, this.field_145851_c, this.field_145848_d, this.field_145849_e, 40, data));
        this.ritualPlayer = p;
        this.ritualTicksLeft = 60;
    }

    public void func_145845_h() {
        if (this.ritualTicksLeft == 0) {
            return;
        }
        switch (this.ritualTicksLeft) {
            case 5: {
                this.func_145831_w().func_72942_c((Entity)new EntityLightningBolt(this.func_145831_w(), (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e));
                this.ritualPlayer.func_70606_j(this.ritualPlayer.func_110138_aP());
                VampirePlayer.get(this.ritualPlayer).getBloodStats().addBlood(20);
                break;
            }
            case 1: {
                VampirePlayer player = VampirePlayer.get(this.ritualPlayer);
                this.bloodAmount -= BALANCE.LEVELING.A2_getRequiredBlood(player.getLevel());
                this.ritualPlayer.func_70690_d(new PotionEffect(Potion.field_76428_l.field_76415_H, player.getLevel() * 5));
                player.levelUp();
                this.func_70296_d();
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
        --this.ritualTicksLeft;
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("blood_amount", this.bloodAmount);
    }
}

