/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.util;

import cpw.mods.fml.common.FMLCommonHandler;
import de.teamlapen.vampirism.entity.player.VampirePlayer;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class DifficultyCalculator {
    private static Difficulty calculateDifficulty(List<EntityPlayer> list) {
        if (list == null || list.isEmpty()) {
            return new Difficulty(0, 0, 0);
        }
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        int sum = 0;
        for (EntityPlayer p : list) {
            int l = VampirePlayer.get(p).getLevel();
            if (l < min) {
                min = l;
            }
            if (l > max) {
                max = l;
            }
            sum += l;
        }
        return new Difficulty(min, max, Math.round((float)sum / (float)list.size()));
    }

    public static Difficulty getGlobalDifficulty() {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            throw new IllegalStateException("You can only use this method on server side");
        }
        return DifficultyCalculator.calculateDifficulty(MinecraftServer.func_71276_C().func_71203_ab().field_72404_b);
    }

    public static Difficulty getLocalDifficulty(World w, double cX, double cZ, int r) {
        List list = w.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)(cX - (double)r), (double)0.0, (double)(cZ - (double)r), (double)(cX + (double)r), (double)256.0, (double)(cZ + (double)r)));
        return DifficultyCalculator.calculateDifficulty(list);
    }

    public static Difficulty getWorldDifficulty(World w) {
        return DifficultyCalculator.calculateDifficulty(w.field_73010_i);
    }

    public static interface IAdjustableLevel {
        public int getLevel();

        public int getMaxLevel();

        public void setLevel(int var1);

        public int suggestLevel(Difficulty var1);
    }

    public static class Difficulty {
        public final int minLevel;
        public final int maxLevel;
        public final int avgLevel;

        private Difficulty(int mil, int mal, int al) {
            this.minLevel = mil;
            this.maxLevel = mal;
            this.avgLevel = al;
        }

        public boolean isZero() {
            return this.minLevel == 0 && this.maxLevel == 0;
        }

        public String toString() {
            return "Difficulty: min_" + this.minLevel + " max_" + this.maxLevel + " avg_" + this.avgLevel;
        }
    }
}

