/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.util;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.ReflectionHelper;
import de.teamlapen.vampirism.ModBiomes;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.network.SpawnCustomParticlePacket;
import de.teamlapen.vampirism.util.Logger;
import de.teamlapen.vampirism.villages.VillageVampire;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.village.Village;
import net.minecraft.world.World;
import scala.actors.threadpool.Arrays;

public class Helper {
    public static String entityToString(Entity e) {
        if (e == null) {
            return "Entity is null";
        }
        return e.toString();
    }

    public static MovingObjectPosition getPlayerLookingSpot(EntityPlayer player, double restriction) {
        float scale = 1.0f;
        float pitch = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * scale;
        float yaw = player.field_70126_B + (player.field_70177_z - player.field_70126_B) * scale;
        double x = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)scale;
        double y = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)scale + 1.62 - (double)player.field_70129_M;
        double z = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)scale;
        Vec3 vector1 = Vec3.func_72443_a((double)x, (double)y, (double)z);
        float cosYaw = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float sinYaw = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float cosPitch = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float sinPitch = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        float pitchAdjustedSinYaw = sinYaw * cosPitch;
        float pitchAdjustedCosYaw = cosYaw * cosPitch;
        double distance = 500.0;
        if (restriction == 0.0 && player instanceof EntityPlayerMP) {
            distance = ((EntityPlayerMP)player).field_71134_c.getBlockReachDistance();
        } else if (restriction > 0.0) {
            distance = restriction;
        }
        Vec3 vector2 = vector1.func_72441_c((double)pitchAdjustedSinYaw * distance, (double)sinPitch * distance, (double)pitchAdjustedCosYaw * distance);
        return player.field_70170_p.func_72933_a(vector1, vector2);
    }

    public static ChunkCoordinates getRandomPosInBox(World w, AxisAlignedBB box) {
        int z;
        int x = (int)box.field_72340_a + w.field_73012_v.nextInt((int)(box.field_72336_d - box.field_72340_a) + 1);
        int y = w.func_72976_f(x, z = (int)box.field_72339_c + w.field_73012_v.nextInt((int)(box.field_72334_f - box.field_72339_c) + 1)) + 1;
        if ((double)y < box.field_72340_a || (double)y > box.field_72337_e) {
            y = (int)box.field_72338_b + w.field_73012_v.nextInt((int)(box.field_72337_e - box.field_72338_b) + 1);
        }
        return new ChunkCoordinates(x, y, z);
    }

    public static void sendPacketToPlayersAround(IMessage message, Entity e) {
        VampirismMod.modChannel.sendToAllAround(message, new NetworkRegistry.TargetPoint(e.field_71093_bK, e.field_70165_t, e.field_70163_u, e.field_70161_v, 100.0));
    }

    public static Entity spawnEntityBehindEntity(EntityLivingBase p, String name) {
        if (p == null) {
            return null;
        }
        EntityLiving e = (EntityLiving)EntityList.func_75620_a((String)name, (World)p.field_70170_p);
        if (e == null) {
            Logger.w("Helper", "Failed to create %s", name);
        }
        float yaw = p.field_70759_as;
        float cosYaw = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float sinYaw = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        int distance = 2;
        double x = p.field_70165_t + (double)(sinYaw * (float)distance);
        double z = p.field_70161_v + (double)(cosYaw * (float)distance);
        e.func_70107_b(x, p.field_70163_u, z);
        if (e.func_70601_bi()) {
            p.field_70170_p.func_72838_d((Entity)e);
            return e;
        }
        e.func_70107_b(x, (double)p.field_70170_p.func_72976_f((int)Math.round(x), (int)Math.round(z)), z);
        if (e.func_70601_bi()) {
            p.field_70170_p.func_72838_d((Entity)e);
            return e;
        }
        e.func_70106_y();
        return null;
    }

    public static List<Entity> spawnEntityInVillage(Village v, int max, String name, World world) {
        ArrayList<Entity> list = new ArrayList<Entity>();
        Entity e = null;
        for (int i = 0; i < max; ++i) {
            if (e == null) {
                e = EntityList.func_75620_a((String)name, (World)world);
            }
            if (!Helper.spawnEntityInWorld(world, VillageVampire.getBoundingBox(v), e, 5)) continue;
            list.add(e);
            e = null;
        }
        if (e != null) {
            e.func_70106_y();
        }
        return list;
    }

    public static boolean spawnEntityInWorld(World world, AxisAlignedBB box, Entity e, int maxTry) {
        boolean flag = false;
        int i = 0;
        while (!flag && i++ < maxTry) {
            ChunkCoordinates c = Helper.getRandomPosInBox(world, box);
            e.func_70107_b((double)c.field_71574_a, (double)c.field_71572_b, (double)c.field_71573_c);
            if (e instanceof EntityLiving && !((EntityLiving)e).func_70601_bi()) continue;
            flag = true;
        }
        if (flag) {
            world.func_72838_d(e);
            return true;
        }
        return false;
    }

    public static Entity spawnEntityInWorld(World world, AxisAlignedBB box, String name, int maxTry) {
        Entity e = EntityList.func_75620_a((String)name, (World)world);
        if (Helper.spawnEntityInWorld(world, box, e, maxTry)) {
            return e;
        }
        e.func_70106_y();
        return null;
    }

    public static void spawnParticlesAroundEntity(EntityLivingBase e, String particle, double maxDistance, int amount) {
        if (!e.field_70170_p.field_72995_K) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74778_a("particle", particle);
            nbt.func_74768_a("id", e.func_145782_y());
            nbt.func_74780_a("distance", maxDistance);
            Helper.sendPacketToPlayersAround(new SpawnCustomParticlePacket(2, 0.0, 0.0, 0.0, amount, nbt), (Entity)e);
            return;
        }
        int short1 = amount;
        for (int l = 0; l < short1; ++l) {
            double d6 = (double)l / ((double)short1 - 1.0) - 0.5;
            float f = (e.func_70681_au().nextFloat() - 0.5f) * 0.2f;
            float f1 = (e.func_70681_au().nextFloat() - 0.5f) * 0.2f;
            float f2 = (e.func_70681_au().nextFloat() - 0.5f) * 0.2f;
            double d7 = e.field_70165_t + maxDistance * d6 + (e.func_70681_au().nextDouble() - 0.5) * (double)e.field_70130_N * 2.0;
            double d8 = e.field_70163_u + maxDistance / 2.0 * d6 + e.func_70681_au().nextDouble() * (double)e.field_70131_O;
            double d9 = e.field_70161_v + maxDistance * d6 + (e.func_70681_au().nextDouble() - 0.5) * (double)e.field_70130_N * 2.0;
            e.field_70170_p.func_72869_a(particle, d7, d8, d9, (double)f, (double)f1, (double)f2);
        }
    }

    public static boolean teleportTo(EntityLiving entity, double x, double y, double z, boolean sound) {
        int k;
        int j;
        double d3 = entity.field_70165_t;
        double d4 = entity.field_70163_u;
        double d5 = entity.field_70161_v;
        entity.field_70165_t = x;
        entity.field_70163_u = y;
        entity.field_70161_v = z;
        boolean flag = false;
        int i = MathHelper.func_76128_c((double)entity.field_70165_t);
        if (entity.field_70170_p.func_72899_e(i, j = MathHelper.func_76128_c((double)entity.field_70163_u), k = MathHelper.func_76128_c((double)entity.field_70161_v))) {
            boolean flag1 = false;
            while (!flag1 && j > 0) {
                Block block = entity.field_70170_p.func_147439_a(i, j - 1, k);
                if (block.func_149688_o().func_76230_c()) {
                    flag1 = true;
                    continue;
                }
                entity.field_70163_u -= 1.0;
                --j;
            }
            if (flag1) {
                entity.func_70107_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                if (entity.field_70170_p.func_72945_a((Entity)entity, entity.field_70121_D).isEmpty() && !entity.field_70170_p.func_72953_d(entity.field_70121_D)) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            entity.func_70107_b(d3, d4, d5);
            return false;
        }
        int short1 = 128;
        for (int l = 0; l < short1; ++l) {
            double d6 = (double)l / ((double)short1 - 1.0);
            float f = (entity.func_70681_au().nextFloat() - 0.5f) * 0.2f;
            float f1 = (entity.func_70681_au().nextFloat() - 0.5f) * 0.2f;
            float f2 = (entity.func_70681_au().nextFloat() - 0.5f) * 0.2f;
            double d7 = d3 + (entity.field_70165_t - d3) * d6 + (entity.func_70681_au().nextDouble() - 0.5) * (double)entity.field_70130_N * 2.0;
            double d8 = d4 + (entity.field_70163_u - d4) * d6 + entity.func_70681_au().nextDouble() * (double)entity.field_70131_O;
            double d9 = d5 + (entity.field_70161_v - d5) * d6 + (entity.func_70681_au().nextDouble() - 0.5) * (double)entity.field_70130_N * 2.0;
            entity.field_70170_p.func_72869_a("portal", d7, d8, d9, (double)f, (double)f1, (double)f2);
        }
        if (sound) {
            entity.field_70170_p.func_72908_a(d3, d4, d5, "mob.endermen.portal", 1.0f, 1.0f);
            entity.func_85030_a("mob.endermen.portal", 1.0f, 1.0f);
        }
        return true;
    }

    public static double rnd1n1(Random ran) {
        return (ran.nextDouble() - 0.5) * 2.0;
    }

    public static boolean isEntityInVampireBiome(Entity e) {
        if (e == null || e.field_70170_p == null) {
            return false;
        }
        try {
            return e.field_70170_p.func_72807_a((int)MathHelper.func_76128_c((double)e.field_70165_t), (int)MathHelper.func_76128_c((double)e.field_70161_v)).field_76756_M == ModBiomes.biomeVampireForest.field_76756_M;
        }
        catch (NullPointerException e1) {
            Logger.e("Helper", e1, "Nullpointer when checking biome. This is strange and should not happen", new Object[0]);
            return false;
        }
    }

    public static void sendMessageToAllExcept(EntityPlayer player, IChatComponent message) {
        for (Object o : MinecraftServer.func_71276_C().func_71203_ab().field_72404_b) {
            if (o.equals(player)) continue;
            ((EntityPlayer)o).func_146105_b(message);
        }
    }

    public static void sendMessageToAll(IChatComponent message) {
        Helper.sendMessageToAllExcept(null, message);
    }

    public static boolean canReallySee(EntityLivingBase entity, EntityLivingBase target, boolean alsoRaytrace) {
        if (alsoRaytrace && !entity.func_70685_l((Entity)target)) {
            return false;
        }
        Vec3 look1 = Vec3.func_72443_a((double)(-Math.sin((double)(entity.field_70759_as / 180.0f) * Math.PI)), (double)0.0, (double)Math.cos((double)(entity.field_70759_as / 180.0f) * Math.PI));
        Vec3 dist = Vec3.func_72443_a((double)(target.field_70165_t - entity.field_70165_t), (double)0.0, (double)(target.field_70161_v - entity.field_70161_v));
        double alpha = Math.acos((look1 = look1.func_72432_b()).func_72430_b(dist = dist.func_72432_b()));
        return alpha < 1.5707963267948966;
    }

    public static class Reflection {
        public static Object callMethod(Class cls, Object obj, String[] methodName, Class[] paramtype, Object ... param) {
            if (param != null && paramtype.length != param.length) {
                Logger.w("ReflectCallMethod", "Param count doesnt fit paramtype count", new Object[0]);
                return null;
            }
            try {
                Method method = ReflectionHelper.findMethod((Class)cls, (Object)obj, (String[])methodName, (Class[])paramtype);
                return method.invoke(obj, param);
            }
            catch (Exception e) {
                Logger.e("ReflectCallMethod", "Failed to invoke method", new Object[0]);
                e.printStackTrace();
                return null;
            }
        }

        public static Object callMethod(Object obj, String[] methodName, Class[] paramtype, Object ... param) {
            return Reflection.callMethod(obj.getClass(), obj, methodName, paramtype, param);
        }

        public static Class[] createArray(Class ... objects) {
            return objects;
        }

        public static Object getPrivateFinalField(Class cls, Object obj, String ... fieldname) {
            try {
                Field privateStringField = ReflectionHelper.findField((Class)cls, (String[])fieldname);
                return privateStringField.get(obj);
            }
            catch (Exception e) {
                Logger.e("Reflection", "Failed to get " + Arrays.toString((Object[])fieldname) + " from " + obj.toString() + " of class " + cls.getCanonicalName(), e);
                return null;
            }
        }

        public static void setPrivateField(Class cls, Object obj, Object value, String ... fieldname) {
            try {
                Field privateStringField = ReflectionHelper.findField((Class)cls, (String[])fieldname);
                privateStringField.set(obj, value);
            }
            catch (Exception e) {
                Logger.e("Reflection", "Failed to get " + Arrays.toString((Object[])fieldname) + " from " + obj.toString() + " of class " + cls.getCanonicalName(), e);
                return;
            }
        }
    }

    public static class Obfuscation {
        private static final HashMap<String, String[]> posNames = new HashMap();

        private static void add(String key, String ... value) {
            posNames.put(key, value);
        }

        public static void fillMap() {
            Obfuscation.add("EntityPlayer/updateItemUse", "updateItemUse", "func_71010_c");
            Obfuscation.add("EntityPlayer/setSize", "setSize", "func_70105_a");
            Obfuscation.add("EntityPlayer/sleeping", "sleeping", "field_71083_bS");
            Obfuscation.add("EntityPlayer/sleepTimer", "sleepTimer", "field_71076_b");
            Obfuscation.add("Minecraft/fileAssets", "fileAssets", "field_110446_Y");
            Obfuscation.add("TileEntityBeacon/field_146015_k", "field_146015_k");
            Obfuscation.add("Entity/setSize", "setSize", "func_70105_a");
        }

        public static String[] getPosNames(String key) {
            return posNames.get(key);
        }
    }
}

