/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.villages;

import cpw.mods.fml.common.gameevent.TickEvent;
import de.teamlapen.vampirism.generation.castle.CastlePositionData;
import de.teamlapen.vampirism.util.Logger;
import de.teamlapen.vampirism.villages.VillageVampire;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.village.Village;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import org.eclipse.jdt.annotation.Nullable;

public class VillageVampireData
extends WorldSavedData {
    private static final String IDENTIFIER = "vampirism_village";
    private final List<VillageVampire> villageList = new ArrayList<VillageVampire>();
    private World worldObj;
    private int tickCounter;

    public static VillageVampireData get(World world) {
        VillageVampireData data = (VillageVampireData)world.perWorldStorage.func_75742_a(VillageVampireData.class, IDENTIFIER);
        if (data == null) {
            data = new VillageVampireData();
            world.perWorldStorage.func_75745_a(IDENTIFIER, (WorldSavedData)data);
        }
        data.setWorld(world);
        return data;
    }

    public VillageVampireData() {
        super(IDENTIFIER);
    }

    public VillageVampireData(String identifier) {
        super(identifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForAnnihilatedVillages() {
        List<VillageVampire> list = this.villageList;
        synchronized (list) {
            Iterator<VillageVampire> iterator = this.villageList.iterator();
            while (iterator.hasNext()) {
                VillageVampire v = iterator.next();
                switch (v.isAnnihilated()) {
                    case -1: {
                        Logger.d("VillageVampireData", "Removing annihilated village", new Object[0]);
                        iterator.remove();
                        this.func_76185_a();
                        break;
                    }
                    case 0: {
                        this.func_76185_a();
                    }
                }
            }
        }
    }

    public VillageVampire findNearestVillage(Entity e) {
        return this.findNearestVillage((int)e.field_70165_t, (int)e.field_70163_u, (int)e.field_70161_v, 5);
    }

    public VillageVampire findNearestVillage(int x, int y, int z, int r) {
        Village v = this.worldObj.field_72982_D.func_75550_a(x, y, z, r);
        if (v == null) {
            return null;
        }
        return this.getVillageVampire(v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public VillageVampire getVillageVampire(Village v) {
        List<VillageVampire> list = this.villageList;
        synchronized (list) {
            for (VillageVampire vv : this.villageList) {
                if (!vv.getCenter().equals((Object)v.func_75577_a())) continue;
                return vv;
            }
            VillageVampire vv = new VillageVampire();
            vv.setWorld(this.worldObj);
            vv.setCenter(v.func_75577_a());
            if (CastlePositionData.get(this.worldObj).isPosAt(v.func_75577_a().field_71574_a, v.func_75577_a().field_71573_c)) {
                Logger.d("VampireVillage", "Cannot create a village at %s, because it is inside a castle", v.func_75577_a());
                return null;
            }
            Logger.d("VampireVillage", "Created village at " + v.func_75577_a(), new Object[0]);
            this.villageList.add(vv);
            this.func_76185_a();
            return vv;
        }
    }

    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (this.worldObj == null || this.worldObj.field_72982_D == null) {
            return;
        }
        if (event.world.equals(this.worldObj) && event.phase == TickEvent.Phase.END) {
            ++this.tickCounter;
            boolean dirty = false;
            this.checkForAnnihilatedVillages();
            for (VillageVampire v : this.villageList) {
                if (!v.tick(this.tickCounter)) continue;
                dirty = true;
            }
            if (dirty) {
                this.func_76185_a();
            }
        }
    }

    public void func_76184_a(NBTTagCompound p_76184_1_) {
        this.tickCounter = p_76184_1_.func_74762_e("Tick");
        NBTTagList nbttaglist = p_76184_1_.func_150295_c("Villages", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            VillageVampire village = new VillageVampire();
            village.readFromNBT(nbttagcompound1);
            this.villageList.add(village);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setWorld(World world) {
        this.worldObj = world;
        List<VillageVampire> list = this.villageList;
        synchronized (list) {
            for (VillageVampire vv : this.villageList) {
                vv.setWorld(world);
            }
        }
    }

    public void func_76187_b(NBTTagCompound p_76187_1_) {
        p_76187_1_.func_74768_a("Tick", this.tickCounter);
        NBTTagList nbttaglist = new NBTTagList();
        for (VillageVampire village : this.villageList) {
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            village.writeToNBT(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        p_76187_1_.func_74782_a("Villages", (NBTBase)nbttaglist);
    }
}

