/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.explosive.blast;

import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.api.IWorldPosition;
import com.builtbroken.mc.imp.transform.vector.Pos;
import icbm.classic.content.entity.EntityFlyingBlock;
import icbm.classic.content.explosive.blast.Blast;
import icbm.classic.content.explosive.thread.ThreadSmallExplosion;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlastAntiGravitational
extends Blast {
    protected ThreadSmallExplosion thread;
    protected Set<EntityFlyingBlock> flyingBlocks = new HashSet<EntityFlyingBlock>();

    public BlastAntiGravitational(World world, Entity entity, double x, double y, double z, float size) {
        super(world, entity, x, y, z, size);
    }

    @Override
    public void doPreExplode() {
        if (!this.oldWorld().field_72995_K) {
            this.thread = new ThreadSmallExplosion((IWorldPosition)this.position, (int)this.getRadius(), this.field_77283_e);
            this.thread.start();
        }
        this.oldWorld().func_72908_a(this.position.x(), this.position.y(), this.position.z(), "voltzengine:antigravity", 6.0f, (1.0f + (this.oldWorld().field_73012_v.nextFloat() - this.oldWorld().field_73012_v.nextFloat()) * 0.2f) * 0.7f);
    }

    @Override
    public void doExplode() {
        int r = this.callCount;
        if (!this.oldWorld().field_72995_K && this.thread.isComplete) {
            if (r == 0) {
                Collections.sort(this.thread.results, new GravitationalBlockSorter((IPos3D)this.position));
            }
            int blocksToTake = 20;
            for (Pos targetPosition : this.thread.results) {
                float hardness;
                Block block;
                double distance = targetPosition.distance((IPos3D)this.position);
                if (distance > (double)r || distance < (double)(r - 2) || blocksToTake <= 0 || (block = targetPosition.getBlock((IBlockAccess)this.oldWorld())) == null || !((hardness = block.func_149712_f(this.oldWorld(), targetPosition.xi(), targetPosition.yi(), targetPosition.zi())) >= 0.0f) || !(hardness < 1000.0f)) continue;
                int metadata = this.oldWorld().func_72805_g(targetPosition.xi(), targetPosition.yi(), targetPosition.zi());
                if (!(distance < (double)(r - 1)) && this.oldWorld().field_73012_v.nextInt(3) <= 0) continue;
                this.oldWorld().func_147468_f(targetPosition.xi(), targetPosition.yi(), targetPosition.zi());
                --blocksToTake;
                EntityFlyingBlock entity = new EntityFlyingBlock(this.oldWorld(), (Pos)targetPosition.add(0.5), block, metadata, 0.0f);
                entity.yawChange = 50.0f * this.oldWorld().field_73012_v.nextFloat();
                entity.pitchChange = 100.0f * this.oldWorld().field_73012_v.nextFloat();
                entity.field_70181_x += Math.max(0.15 * (double)this.oldWorld().field_73012_v.nextFloat(), 0.1);
                entity.field_70145_X = true;
                this.oldWorld().func_72838_d((Entity)entity);
                this.flyingBlocks.add(entity);
            }
        }
        int radius = (int)this.getRadius();
        AxisAlignedBB bounds = AxisAlignedBB.func_72330_a((double)(this.position.x() - (double)radius), (double)(this.position.y() - (double)radius), (double)(this.position.z() - (double)radius), (double)(this.position.y() + (double)radius), (double)100.0, (double)(this.position.z() + (double)radius));
        List allEntities = this.oldWorld().func_72872_a(Entity.class, bounds);
        for (Entity entity : allEntities) {
            if (entity instanceof EntityFlyingBlock || !(entity.field_70163_u < 100.0 + this.position.y()) || !(entity.field_70181_x < 0.4)) continue;
            entity.field_70181_x += 0.15;
        }
        if (this.callCount > 2400) {
            this.controller.endExplosion();
        }
    }

    @Override
    protected void doPostExplode() {
        for (EntityFlyingBlock entity : this.flyingBlocks) {
            entity.gravity = 0.045f;
        }
    }

    @Override
    public int proceduralInterval() {
        return 1;
    }

    @Override
    public float getRadius() {
        return 15.0f;
    }

    @Override
    public long getEnergy() {
        return 10000L;
    }

    public class GravitationalBlockSorter
    implements Comparator<IPos3D> {
        final IPos3D center;

        public GravitationalBlockSorter(IPos3D center) {
            this.center = center;
        }

        @Override
        public int compare(IPos3D o1, IPos3D o2) {
            if ((int)o1.y() == (int)o2.y()) {
                double d2;
                double d = new Pos(o1).distance(this.center);
                return d > (d2 = new Pos(o2).distance(this.center)) ? 1 : (d == d2 ? 0 : -1);
            }
            return Integer.compare((int)o1.y(), (int)o2.y());
        }
    }
}

