/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.explosive.blast;

import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.api.IWorldPosition;
import com.builtbroken.mc.imp.transform.vector.Pos;
import icbm.classic.ICBMClassic;
import icbm.classic.content.entity.EntityFlyingBlock;
import icbm.classic.content.entity.EntityMissile;
import icbm.classic.content.explosive.blast.Blast;
import icbm.classic.content.explosive.thread.ThreadLargeExplosion;
import icbm.classic.content.explosive.tile.BlockExplosive;
import icbm.classic.content.explosive.tile.TileEntityExplosive;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.fluids.IFluidBlock;

public class BlastSonic
extends Blast {
    private float energy;
    private ThreadLargeExplosion thread;
    private boolean hasShockWave = false;

    public BlastSonic(World world, Entity entity, double x, double y, double z, float size) {
        super(world, entity, x, y, z, size);
    }

    public BlastSonic(World world, Entity entity, double x, double y, double z, float size, float energy) {
        this(world, entity, x, y, z, size);
        this.energy = energy;
    }

    public Blast setShockWave() {
        this.hasShockWave = true;
        return this;
    }

    @Override
    public void doPreExplode() {
        if (!this.oldWorld().field_72995_K) {
            this.thread = new ThreadLargeExplosion((IWorldPosition)this.position, (int)this.getRadius(), this.energy, this.field_77283_e, new ThreadLargeExplosion.IThreadCallBack(){

                @Override
                public float getResistance(World world, IPos3D explosionPosition, IPos3D targetPosition, Entity source, Block block) {
                    float resistance = 0.0f;
                    resistance = block instanceof BlockLiquid || block instanceof IFluidBlock ? 1.0f : block.getExplosionResistance(source, world, (int)targetPosition.x(), (int)targetPosition.y(), (int)targetPosition.z(), explosionPosition.x(), explosionPosition.y(), explosionPosition.z());
                    return resistance;
                }
            });
            this.thread.start();
        }
        if (this.hasShockWave) {
            this.oldWorld().func_72908_a(this.position.x(), this.position.y(), this.position.z(), "icbmclassic:hypersonic", 4.0f, (1.0f + (this.oldWorld().field_73012_v.nextFloat() - this.oldWorld().field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        } else {
            this.oldWorld().func_72908_a(this.position.x(), this.position.y(), this.position.z(), "icbmclassic:sonicwave", 4.0f, (1.0f + (this.oldWorld().field_73012_v.nextFloat() - this.oldWorld().field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doExplode() {
        List allEntities;
        int r = this.callCount;
        if (!this.oldWorld().field_72995_K && this.thread != null && this.thread.isComplete) {
            Iterator it = this.thread.results.iterator();
            while (it.hasNext()) {
                Block blockID;
                Pos targetPosition = (Pos)it.next();
                double distance = targetPosition.distance((IPos3D)this.position);
                if (distance > (double)r || distance < (double)(r - 3) || (blockID = this.oldWorld().func_147439_a(targetPosition.xi(), targetPosition.yi(), targetPosition.zi())) == Blocks.field_150350_a || blockID.field_149782_v < 0.0f) continue;
                int metadata = this.oldWorld().func_72805_g(targetPosition.xi(), targetPosition.yi(), targetPosition.zi());
                if (!(distance < (double)(r - 1)) && this.oldWorld().field_73012_v.nextInt(3) <= 0) continue;
                if (blockID == ICBMClassic.blockExplosive) {
                    BlockExplosive.triggerExplosive(this.oldWorld(), targetPosition.xi(), targetPosition.yi(), targetPosition.zi(), ((TileEntityExplosive)this.oldWorld().func_147438_o((int)targetPosition.xi(), (int)targetPosition.yi(), (int)targetPosition.zi())).explosive, 1);
                } else {
                    this.oldWorld().func_147468_f(targetPosition.xi(), targetPosition.yi(), targetPosition.zi());
                }
                targetPosition = (Pos)targetPosition.add(0.5);
                if ((double)this.oldWorld().field_73012_v.nextFloat() < 0.3 * (double)(this.getRadius() - (float)r)) {
                    EntityFlyingBlock entity = new EntityFlyingBlock(this.oldWorld(), (IPos3D)targetPosition, blockID, metadata);
                    this.oldWorld().func_72838_d((Entity)entity);
                    entity.yawChange = 50.0f * this.oldWorld().field_73012_v.nextFloat();
                    entity.pitchChange = 100.0f * this.oldWorld().field_73012_v.nextFloat();
                }
                it.remove();
            }
        }
        int radius = 2 * this.callCount;
        AxisAlignedBB bounds = AxisAlignedBB.func_72330_a((double)(this.position.x() - (double)radius), (double)(this.position.y() - (double)radius), (double)(this.position.z() - (double)radius), (double)(this.position.x() + (double)radius), (double)(this.position.y() + (double)radius), (double)(this.position.z() + (double)radius));
        List list = allEntities = this.oldWorld().func_72872_a(Entity.class, bounds);
        synchronized (list) {
            for (Entity entity : allEntities) {
                if (entity instanceof EntityMissile) {
                    ((EntityMissile)entity).setExplode();
                    break;
                }
                double xDifference = entity.field_70165_t - this.position.x();
                double zDifference = entity.field_70161_v - this.position.z();
                r = (int)this.getRadius();
                if (xDifference < 0.0) {
                    r = (int)(-this.getRadius());
                }
                entity.field_70159_w += ((double)r - xDifference) * 0.02 * (double)this.oldWorld().field_73012_v.nextFloat();
                entity.field_70181_x += (double)(3.0f * this.oldWorld().field_73012_v.nextFloat());
                r = (int)this.getRadius();
                if (zDifference < 0.0) {
                    r = (int)(-this.getRadius());
                }
                entity.field_70179_y += ((double)r - zDifference) * 0.02 * (double)this.oldWorld().field_73012_v.nextFloat();
            }
        }
        if ((float)this.callCount > this.getRadius()) {
            this.controller.endExplosion();
        }
    }

    @Override
    public int proceduralInterval() {
        return 4;
    }

    @Override
    public long getEnergy() {
        return 3000L;
    }
}

