/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.machines.launcher.base;

import cofh.api.energy.IEnergyHandler;
import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.api.tile.multiblock.IMultiTile;
import com.builtbroken.mc.api.tile.multiblock.IMultiTileHost;
import com.builtbroken.mc.api.tile.provider.IInventoryProvider;
import com.builtbroken.mc.core.network.IPacketIDReceiver;
import com.builtbroken.mc.core.registry.implement.IRecipeContainer;
import com.builtbroken.mc.framework.energy.data.EnergyBuffer;
import com.builtbroken.mc.framework.multiblock.EnumMultiblock;
import com.builtbroken.mc.framework.multiblock.MultiBlockHelper;
import com.builtbroken.mc.imp.transform.rotation.EulerAngle;
import com.builtbroken.mc.imp.transform.vector.Pos;
import com.builtbroken.mc.lib.helper.LanguageUtility;
import com.builtbroken.mc.lib.helper.recipe.UniversalRecipe;
import com.builtbroken.mc.prefab.items.ItemBlockSubTypes;
import com.builtbroken.mc.prefab.tile.Tile;
import com.builtbroken.mc.prefab.tile.TileModuleMachine;
import com.builtbroken.mc.prefab.tile.module.TileModuleInventory;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.registry.GameRegistry;
import icbm.classic.ICBMClassic;
import icbm.classic.Settings;
import icbm.classic.content.entity.EntityMissile;
import icbm.classic.content.entity.EntityPlayerSeat;
import icbm.classic.content.explosive.Explosive;
import icbm.classic.content.explosive.Explosives;
import icbm.classic.content.items.ItemMissile;
import icbm.classic.content.machines.launcher.frame.TileLauncherFrame;
import icbm.classic.content.machines.launcher.screen.TileLauncherScreen;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.ShapedOreRecipe;
import resonant.api.ITier;
import resonant.api.explosion.ILauncherContainer;
import resonant.api.explosion.ILauncherController;

public class TileLauncherBase
extends TileModuleMachine
implements IPacketIDReceiver,
IMultiTileHost,
ITier,
ILauncherContainer,
IRecipeContainer,
IEnergyHandler {
    public static HashMap<IPos3D, String> northSouthMultiBlockCache = new HashMap();
    public static HashMap<IPos3D, String> eastWestMultiBlockCache = new HashMap();
    private static EulerAngle angle = new EulerAngle(0.0, 0.0, 0.0);
    public TileLauncherFrame supportFrame = null;
    public TileLauncherScreen launchScreen = null;
    public EntityPlayerSeat seat;
    protected int tier = 0;
    private boolean _destroyingStructure = false;

    public TileLauncherBase() {
        super("launcherBase", Material.field_151573_f);
        this.itemBlock = ItemBlockSubTypes.class;
        this.hardness = 10.0f;
        this.resistance = 10.0f;
        this.isOpaque = false;
    }

    protected IInventory createInventory() {
        return new TileModuleInventory((IInventoryProvider)this, 1);
    }

    public Tile newTile() {
        return new TileLauncherBase();
    }

    public EnergyBuffer getEnergyBuffer(ForgeDirection side) {
        if (this.launchScreen != null) {
            return this.launchScreen.getEnergyBuffer(ForgeDirection.UNKNOWN);
        }
        return null;
    }

    public void update() {
        super.update();
        if (this.isServer() && this.ticks % 3L == 0L) {
            if (this.seat != null) {
                this.seat.func_70107_b(this.x() + 0.5, this.y() + 0.5, this.z() + 0.5);
            }
            if (this.getMissileStack() != null && this.seat == null) {
                this.seat = new EntityPlayerSeat(this.field_145850_b);
                this.seat.host = this;
                this.seat.rideOffset = new Pos((double)this.getFacing().offsetX * 0.5, 1.0, (double)this.getFacing().offsetZ * 0.5);
                this.seat.func_70107_b(this.x() + 0.5, this.y() + 0.5, this.z() + 0.5);
                this.seat.func_70105_a(0.5f, 2.5f);
                this.field_145850_b.func_72838_d((Entity)this.seat);
            } else if (this.getMissileStack() == null && this.seat != null) {
                if (this.seat.field_70153_n != null) {
                    this.seat.field_70153_n.func_70078_a(null);
                }
                this.seat.func_70106_y();
                this.seat = null;
            }
        }
        if (this.ticks % 20L == 0L && (this.supportFrame == null || this.launchScreen == null || this.launchScreen.func_145837_r() || this.supportFrame.func_145837_r())) {
            this.supportFrame = null;
            this.launchScreen = null;
            for (int i = 2; i < 6; i = (int)((byte)(i + 1))) {
                Pos position = (Pos)new Pos((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e).add(ForgeDirection.getOrientation((int)i));
                TileEntity tileEntity = this.field_145850_b.func_147438_o(position.xi(), position.yi(), position.zi());
                if (tileEntity instanceof TileLauncherFrame) {
                    this.supportFrame = (TileLauncherFrame)tileEntity;
                    if (!this.isServer()) continue;
                    this.supportFrame.setFacing(this.getDirection());
                    continue;
                }
                if (!(tileEntity instanceof TileLauncherScreen)) continue;
                this.launchScreen = (TileLauncherScreen)tileEntity;
            }
        }
    }

    public void onInventoryChanged(int slot, ItemStack prev, ItemStack item) {
        if (slot == 0) {
            this.sendDescPacket();
        }
    }

    public boolean canStore(ItemStack stack, ForgeDirection side) {
        return stack != null && stack.func_77973_b() == ICBMClassic.itemMissile;
    }

    public boolean canRemove(ItemStack stack, ForgeDirection side) {
        return true;
    }

    public String func_145825_b() {
        return LanguageUtility.getLocal((String)"gui.launcherBase.name");
    }

    public boolean launchMissile(Pos target, int lockHeight) {
        Explosive ex;
        ItemStack stack = this.getMissileStack();
        if (stack != null && stack.func_77973_b() == ICBMClassic.itemMissile && (ex = Explosives.get((int)stack.func_77960_j()).handler).hasMissileForm()) {
            int inaccuracy = 30;
            if (this.supportFrame != null) {
                inaccuracy = this.supportFrame.getInaccuracy();
            }
            inaccuracy = this.oldWorld().field_73012_v.nextInt(inaccuracy);
            angle.setYaw((double)(this.oldWorld().field_73012_v.nextFloat() * 360.0f));
            target = (Pos)target.add(angle.x() * (double)inaccuracy, 0.0, angle.z() * (double)inaccuracy);
            if (this.isServer()) {
                EntityMissile missile = new EntityMissile(this.oldWorld());
                missile.explosiveID = Explosives.get(stack.func_77960_j());
                missile.launcherPos = new Pos((TileEntity)this);
                missile.func_70107_b(this.xi(), this.yi() + 3, this.zi());
                missile.launch(target, lockHeight);
                this.oldWorld().func_72838_d((Entity)missile);
                if (this.seat != null && this.seat.field_70153_n != null) {
                    Entity entity = this.seat.field_70153_n;
                    this.seat.field_70153_n.func_70078_a(null);
                    entity.func_70078_a((Entity)missile);
                }
                this.func_70298_a(0, 1);
            }
            return true;
        }
        return false;
    }

    public boolean isInRange(Pos target) {
        if (target != null) {
            return !this.isTargetTooFar(target) && !this.isTargetTooClose(target);
        }
        return false;
    }

    public boolean isTargetTooClose(Pos target) {
        return new Pos((double)this.field_145851_c, 0.0, (double)this.field_145849_e).distance((IPos3D)new Pos(target.x(), 0.0, target.z())) < 10.0;
    }

    public boolean isTargetTooFar(Pos target) {
        double distance = new Pos((double)this.field_145851_c, 0.0, (double)this.field_145849_e).distance((IPos3D)new Pos(target.x(), 0.0, target.z()));
        return distance > this.getRange();
    }

    public double getRange() {
        return TileLauncherBase.getRangeForTier(this.tier);
    }

    public static double getRangeForTier(int tier) {
        if (tier == 0) {
            return Settings.MAX_LAUNCHER_RANGE / 10;
        }
        if (tier == 1) {
            return Settings.MAX_LAUNCHER_RANGE / 5;
        }
        return Settings.MAX_LAUNCHER_RANGE;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tier = nbt.func_74762_e("tier");
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("tier", this.getTier());
    }

    public void writeDescPacket(ByteBuf buf) {
        super.writeDescPacket(buf);
        buf.writeInt(this.getTier());
        buf.writeBoolean(this.getMissileStack() != null);
        if (this.getMissileStack() != null) {
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.getMissileStack());
        }
    }

    public ItemStack getMissileStack() {
        return this.func_70301_a(0);
    }

    public int getTier() {
        return this.tier;
    }

    public void setTier(int tier) {
        this.tier = tier;
    }

    protected boolean onPlayerRightClick(EntityPlayer player, int side, Pos hit) {
        if (player.field_71071_by.func_70448_g() != null) {
            if (player.field_71071_by.func_70448_g().func_77973_b() instanceof ItemMissile) {
                if (this.getMissileStack() == null) {
                    if (this.isServer()) {
                        this.func_70299_a(0, player.field_71071_by.func_70448_g());
                        if (!player.field_71075_bZ.field_75098_d) {
                            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                            player.field_71069_bz.func_75142_b();
                        }
                    }
                    return true;
                }
            } else if (this.launchScreen != null) {
                return this.launchScreen.onPlayerActivated(player, side, hit);
            }
        } else if (this.getMissileStack() != null) {
            if (this.isServer()) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, this.getMissileStack());
                this.func_70299_a(0, null);
                player.field_71069_bz.func_75142_b();
            }
            return true;
        }
        return true;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public boolean canStore(ItemStack stack, int slot, ForgeDirection side) {
        return slot == 0 && stack.func_77973_b() instanceof ItemMissile;
    }

    public ILauncherController getController() {
        for (int i = 2; i < 6; i = (int)((byte)(i + 1))) {
            Pos position = (Pos)new Pos((TileEntity)this).add(ForgeDirection.getOrientation((int)i));
            TileEntity tileEntity = position.getTileEntity((IBlockAccess)this.field_145850_b);
            if (!(tileEntity instanceof ILauncherController)) continue;
            return (ILauncherController)tileEntity;
        }
        return null;
    }

    public void firstTick() {
        super.firstTick();
        MultiBlockHelper.buildMultiBlock((World)this.oldWorld(), (IMultiTileHost)this, (boolean)true, (boolean)true);
    }

    public void onMultiTileAdded(IMultiTile tileMulti) {
        if (tileMulti instanceof TileEntity && this.getLayoutOfMultiBlock().containsKey(new Pos((TileEntity)this).sub((IPos3D)new Pos((TileEntity)tileMulti)))) {
            tileMulti.setHost((IMultiTileHost)this);
        }
    }

    public boolean onMultiTileBroken(IMultiTile tileMulti, Object source, boolean harvest) {
        if (!this._destroyingStructure && tileMulti instanceof TileEntity) {
            Pos pos = (Pos)new Pos((TileEntity)tileMulti).sub((IPos3D)new Pos((TileEntity)this));
            if (this.getLayoutOfMultiBlock().containsKey(pos)) {
                MultiBlockHelper.destroyMultiBlockStructure((IMultiTileHost)this, (boolean)harvest, (boolean)true, (boolean)true);
                return true;
            }
        }
        return false;
    }

    public boolean canPlaceBlockAt() {
        return super.canPlaceBlockAt() && this.oldWorld().func_147439_a(this.xi(), this.yi() + 1, this.zi()).isReplaceable((IBlockAccess)this.oldWorld(), this.xi(), this.yi() + 1, this.zi()) && this.oldWorld().func_147439_a(this.xi(), this.yi() + 2, this.zi()).isReplaceable((IBlockAccess)this.oldWorld(), this.xi(), this.yi() + 2, this.zi());
    }

    public boolean canPlaceBlockOnSide(ForgeDirection side) {
        return side == ForgeDirection.UP && this.canPlaceBlockAt();
    }

    public boolean removeByPlayer(EntityPlayer player, boolean willHarvest) {
        this._destroyingStructure = true;
        MultiBlockHelper.destroyMultiBlockStructure((IMultiTileHost)this, (boolean)false, (boolean)true, (boolean)false);
        return super.removeByPlayer(player, willHarvest);
    }

    public void onTileInvalidate(IMultiTile tileMulti) {
    }

    public boolean onMultiTileActivated(IMultiTile tile, EntityPlayer player, int side, float xHit, float yHit, float zHit) {
        return this.onPlayerRightClick(player, side, new Pos((double)xHit, (double)yHit, (double)zHit));
    }

    public void onMultiTileClicked(IMultiTile tile, EntityPlayer player) {
    }

    public HashMap<IPos3D, String> getLayoutOfMultiBlock() {
        if (this.getDirection() == ForgeDirection.EAST || this.getDirection() == ForgeDirection.WEST) {
            return eastWestMultiBlockCache;
        }
        return northSouthMultiBlockCache;
    }

    public void setFacing(ForgeDirection facingDirection) {
        if (facingDirection != this.getDirection()) {
            if (this.isServer()) {
                MultiBlockHelper.destroyMultiBlockStructure((IMultiTileHost)this, (boolean)false, (boolean)true, (boolean)false);
            }
            super.setFacing(facingDirection);
            if (this.isServer()) {
                MultiBlockHelper.buildMultiBlock((World)this.oldWorld(), (IMultiTileHost)this, (boolean)true, (boolean)true);
                this.func_70296_d();
            }
        }
    }

    public void genRecipes(List<IRecipe> recipes) {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(ICBMClassic.blockLaunchBase, 1, 0), new Object[]{"! !", "!C!", "!!!", Character.valueOf('!'), UniversalRecipe.SECONDARY_METAL.get(), Character.valueOf('C'), UniversalRecipe.CIRCUIT_T1.get()}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(ICBMClassic.blockLaunchBase, 1, 1), new Object[]{"! !", "!C!", "!@!", Character.valueOf('@'), new ItemStack(ICBMClassic.blockLaunchBase, 1, 0), Character.valueOf('!'), UniversalRecipe.PRIMARY_METAL.get(), Character.valueOf('C'), UniversalRecipe.CIRCUIT_T2.get()}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(ICBMClassic.blockLaunchBase, 1, 2), new Object[]{"! !", "!C!", "!@!", Character.valueOf('@'), new ItemStack(ICBMClassic.blockLaunchBase, 1, 1), Character.valueOf('!'), UniversalRecipe.PRIMARY_PLATE.get(), Character.valueOf('C'), UniversalRecipe.CIRCUIT_T3.get()}));
    }

    public void onPlaced(EntityLivingBase entityLiving, ItemStack itemStack) {
        super.onPlaced(entityLiving, itemStack);
        this.setTier(itemStack.func_77960_j());
    }

    public int metadataDropped(int meta, int fortune) {
        return this.getTier();
    }

    protected boolean useMetaForFacing() {
        return true;
    }

    static {
        northSouthMultiBlockCache.put((IPos3D)new Pos(1.0, 0.0, 0.0), EnumMultiblock.INV_ENERGY.getTileName());
        northSouthMultiBlockCache.put((IPos3D)new Pos(1.0, 1.0, 0.0), EnumMultiblock.INV_ENERGY.getTileName());
        northSouthMultiBlockCache.put((IPos3D)new Pos(1.0, 2.0, 0.0), EnumMultiblock.INV_ENERGY.getTileName());
        northSouthMultiBlockCache.put((IPos3D)new Pos(-1.0, 0.0, 0.0), EnumMultiblock.INV_ENERGY.getTileName());
        northSouthMultiBlockCache.put((IPos3D)new Pos(-1.0, 1.0, 0.0), EnumMultiblock.INV_ENERGY.getTileName());
        northSouthMultiBlockCache.put((IPos3D)new Pos(-1.0, 2.0, 0.0), EnumMultiblock.INV_ENERGY.getTileName());
        eastWestMultiBlockCache.put((IPos3D)new Pos(0.0, 0.0, 1.0), EnumMultiblock.INV_ENERGY.getTileName());
        eastWestMultiBlockCache.put((IPos3D)new Pos(0.0, 1.0, 1.0), EnumMultiblock.INV_ENERGY.getTileName());
        eastWestMultiBlockCache.put((IPos3D)new Pos(0.0, 2.0, 1.0), EnumMultiblock.INV_ENERGY.getTileName());
        eastWestMultiBlockCache.put((IPos3D)new Pos(0.0, 0.0, -1.0), EnumMultiblock.INV_ENERGY.getTileName());
        eastWestMultiBlockCache.put((IPos3D)new Pos(0.0, 1.0, -1.0), EnumMultiblock.INV_ENERGY.getTileName());
        eastWestMultiBlockCache.put((IPos3D)new Pos(0.0, 2.0, -1.0), EnumMultiblock.INV_ENERGY.getTileName());
    }
}

