/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.machines.launcher.cruise;

import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.api.data.IPacket;
import com.builtbroken.mc.api.items.tools.IWorldPosItem;
import com.builtbroken.mc.api.tile.access.IGuiTile;
import com.builtbroken.mc.api.tile.provider.IInventoryProvider;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.core.network.IPacketIDReceiver;
import com.builtbroken.mc.core.network.packet.PacketSpawnParticleStream;
import com.builtbroken.mc.core.network.packet.PacketTile;
import com.builtbroken.mc.core.network.packet.PacketType;
import com.builtbroken.mc.core.registry.implement.IRecipeContainer;
import com.builtbroken.mc.imp.transform.rotation.EulerAngle;
import com.builtbroken.mc.imp.transform.vector.Location;
import com.builtbroken.mc.imp.transform.vector.Pos;
import com.builtbroken.mc.lib.helper.LanguageUtility;
import com.builtbroken.mc.lib.helper.recipe.UniversalRecipe;
import com.builtbroken.mc.prefab.items.ItemBlockBase;
import com.builtbroken.mc.prefab.tile.Tile;
import com.builtbroken.mc.prefab.tile.module.TileModuleInventory;
import cpw.mods.fml.common.network.ByteBufUtils;
import icbm.classic.ICBMClassic;
import icbm.classic.content.entity.EntityMissile;
import icbm.classic.content.explosive.Explosives;
import icbm.classic.content.explosive.ex.Explosion;
import icbm.classic.content.items.ItemMissile;
import icbm.classic.content.machines.launcher.TileLauncherPrefab;
import icbm.classic.content.machines.launcher.cruise.ContainerCruiseLauncher;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.oredict.ShapedOreRecipe;
import resonant.api.explosion.ILauncherContainer;
import resonant.api.explosion.ILauncherController;
import resonant.api.explosion.LauncherType;

public class TileCruiseLauncher
extends TileLauncherPrefab
implements IInventory,
IPacketIDReceiver,
ILauncherController,
ILauncherContainer,
IRecipeContainer,
IGuiTile {
    protected final EulerAngle aim = new EulerAngle(0.0, 0.0, 0.0);
    protected final EulerAngle currentAim = new EulerAngle(0.0, 0.0, 0.0);
    protected static double ROTATION_SPEED = 10.0;
    protected long lastRotationUpdate = System.nanoTime();
    protected double deltaTime;

    public TileCruiseLauncher() {
        super("cruiseLauncher", Material.field_151573_f);
        this.itemBlock = ItemBlockBase.class;
        this.setTarget(new Pos());
        this.hardness = 10.0f;
        this.resistance = 10.0f;
        this.isOpaque = false;
    }

    public Tile newTile() {
        return new TileCruiseLauncher();
    }

    protected IInventory createInventory() {
        return new TileModuleInventory((IInventoryProvider)this, 2);
    }

    @Override
    public String getStatus() {
        String status;
        String color = "\u00a74";
        if (!this.checkExtract()) {
            status = LanguageUtility.getLocal((String)"gui.launcherCruise.statusNoPower");
        } else if (this.func_70301_a(0) == null) {
            status = LanguageUtility.getLocal((String)"gui.launcherCruise.statusEmpty");
        } else if (this.func_70301_a(0).func_77973_b() != ICBMClassic.itemMissile) {
            status = LanguageUtility.getLocal((String)"gui.launcherCruise.invalidMissile");
        } else {
            Explosion missile = (Explosion)Explosives.get((int)this.func_70301_a((int)0).func_77960_j()).handler;
            if (missile == null) {
                status = LanguageUtility.getLocal((String)"gui.launcherCruise.invalidMissile");
            } else if (!missile.isCruise()) {
                status = LanguageUtility.getLocal((String)"gui.launcherCruise.notCruiseMissile");
            } else if (missile.getTier() > 3) {
                status = LanguageUtility.getLocal((String)"gui.launcherCruise.invalidMissileTier");
            } else if (this.getTarget() == null || this.getTarget().isZero()) {
                status = LanguageUtility.getLocal((String)"gui.launcherCruise.statusInvalid");
            } else if (this.isTooClose(this.getTarget())) {
                status = LanguageUtility.getLocal((String)"gui.launcherCruise.targetToClose");
            } else if (!this.canSpawnMissileWithNoCollision()) {
                status = LanguageUtility.getLocal((String)"gui.launcherCruise.noRoom");
            } else {
                color = "\u00a72";
                status = LanguageUtility.getLocal((String)"gui.launcherCruise.statusReady");
            }
        }
        return color + status;
    }

    public String func_145825_b() {
        return LanguageUtility.getLocal((String)"gui.launcherCruise.name");
    }

    public boolean func_145818_k_() {
        return false;
    }

    @Override
    public void update() {
        super.update();
        this.deltaTime = (double)(System.nanoTime() - this.lastRotationUpdate) / 1.0E8;
        this.lastRotationUpdate = System.nanoTime();
        if (this.getTarget() != null && !this.getTarget().isZero()) {
            Pos aimPoint = this.getTarget();
            Pos center = (Pos)this.toPos().add(0.5);
            if (Engine.runningAsDev) {
                this.sendPacket((IPacket)new PacketSpawnParticleStream(this.oldWorld().field_73011_w.field_76574_g, (IPos3D)center, (IPos3D)aimPoint));
            }
            this.aim.set(center.toEulerAngle((IPos3D)aimPoint).clampTo360());
            this.currentAim.moveTowards(this.aim, ROTATION_SPEED, this.deltaTime).clampTo360();
            if (!this.field_145850_b.field_72995_K && this.ticks % 40L == 0L && this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                this.launch();
            }
        }
    }

    public void placeMissile(ItemStack itemStack) {
        this.func_70299_a(0, itemStack);
    }

    @Override
    public PacketTile getGUIPacket() {
        return new PacketTile((TileEntity)this, new Object[]{0, this.getEnergy(), this.getFrequency(), this.getTarget().xi(), this.getTarget().yi(), this.getTarget().zi()});
    }

    public boolean read(ByteBuf data, int id, EntityPlayer player, PacketType type) {
        if (!super.read(data, id, player, type)) {
            if (this.isServer()) {
                switch (id) {
                    case 1: {
                        this.setFrequency(data.readInt());
                        return true;
                    }
                    case 2: {
                        this.setTarget(new Pos((double)data.readInt(), (double)data.readInt(), (double)data.readInt()));
                        return true;
                    }
                }
            }
            return false;
        }
        return true;
    }

    public void writeDescPacket(ByteBuf buf) {
        super.writeDescPacket(buf);
        buf.writeBoolean(this.func_70301_a(0) != null);
        if (this.func_70301_a(0) != null) {
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.func_70301_a(0));
        }
        buf.writeInt(this.getTarget().xi());
        buf.writeInt(this.getTarget().yi());
        buf.writeInt(this.getTarget().zi());
    }

    public boolean canLaunch() {
        Explosion missile;
        if (this.getTarget() != null && !this.getTarget().isZero() && this.func_70301_a(0) != null && this.func_70301_a(0).func_77973_b() == ICBMClassic.itemMissile && (missile = (Explosion)Explosives.get((int)this.func_70301_a((int)0).func_77960_j()).handler) != null && missile.isCruise() && missile.getTier() <= 3 && this.checkExtract() && !this.isTooClose(this.getTarget())) {
            return this.canSpawnMissileWithNoCollision();
        }
        return false;
    }

    protected boolean canSpawnMissileWithNoCollision() {
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                if (this.oldWorld().func_147439_a(this.xi() + x, this.yi() + 1, this.zi() + z).isAir((IBlockAccess)this.oldWorld(), this.xi() + x, this.yi() + 1, this.zi() + z)) continue;
                return false;
            }
        }
        return true;
    }

    public LauncherType getLauncherType() {
        return LauncherType.CRUISE;
    }

    public void launch() {
        if (this.canLaunch()) {
            this.extractEnergy();
            EntityMissile entityMissile = new EntityMissile(this.oldWorld(), (double)this.xi() + 0.5, (double)this.yi() + 1.5, (double)this.zi() + 0.5, -((float)this.currentAim.yaw()) - 180.0f, -((float)this.currentAim.pitch()), 2.0f);
            entityMissile.missileType = EntityMissile.MissileType.CruiseMissile;
            entityMissile.explosiveID = Explosives.get(this.func_70301_a(0).func_77960_j());
            entityMissile.acceleration = 1.0f;
            entityMissile.launch(null);
            this.oldWorld().func_72838_d((Entity)entityMissile);
            this.func_70298_a(0, 1);
        }
    }

    public boolean isTooClose(Pos target) {
        return new Pos((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5).distance((IPos3D)new Pos(target.x() + 0.5, target.z() + 0.5, target.z() + 0.5)) < 20.0;
    }

    @Override
    public void onInventoryChanged(int slot, ItemStack prev, ItemStack item) {
        if (slot == 0) {
            this.updateClient = true;
        }
    }

    public boolean onPlayerActivated(EntityPlayer player, int side, Pos hit) {
        if (this.isServer()) {
            boolean notNull;
            boolean bl = notNull = player.func_70694_bm() != null;
            if (notNull && player.func_70694_bm().func_77973_b() == Items.field_151137_ax) {
                if (this.canLaunch()) {
                    this.launch();
                } else {
                    player.func_146105_b((IChatComponent)new ChatComponentText(LanguageUtility.getLocal((String)"chat.launcher.failedToFire")));
                    String translation = LanguageUtility.getLocal((String)"chat.launcher.status");
                    translation = translation.replace("%1", this.getStatus());
                    player.func_146105_b((IChatComponent)new ChatComponentText(translation));
                }
            } else if (notNull && player.func_70694_bm().func_77973_b() instanceof IWorldPosItem) {
                Location location = ((IWorldPosItem)player.func_70694_bm().func_77973_b()).getLocation(player.func_70694_bm());
                if (location != null) {
                    if (location.oldWorld() == this.oldWorld()) {
                        this.setTarget(new Pos(location.x(), location.y(), location.z()));
                        player.func_146105_b((IChatComponent)new ChatComponentText(LanguageUtility.getLocal((String)"chat.launcher.toolTargetSet")));
                    } else {
                        player.func_146105_b((IChatComponent)new ChatComponentText(LanguageUtility.getLocal((String)"chat.launcher.toolWorldNotMatch")));
                    }
                } else {
                    player.func_146105_b((IChatComponent)new ChatComponentText(LanguageUtility.getLocal((String)"chat.launcher.noTargetInTool")));
                }
            } else {
                player.openGui((Object)ICBMClassic.INSTANCE, 0, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
        return true;
    }

    @Override
    public boolean targetWithYValue() {
        return true;
    }

    public boolean func_94041_b(int slotID, ItemStack itemStack) {
        Explosion missile;
        return itemStack != null && itemStack.func_77973_b() instanceof ItemMissile && this.func_70301_a(slotID) == null && Explosives.get((int)itemStack.func_77960_j()).handler instanceof Explosion && (missile = (Explosion)Explosives.get((int)itemStack.func_77960_j()).handler).isCruise() && missile.getTier() <= 3;
    }

    public ILauncherController getController() {
        return this;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)this.field_145848_d, (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1));
    }

    public void genRecipes(List<IRecipe> recipes) {
        recipes.add((IRecipe)new ShapedOreRecipe(new ItemStack(ICBMClassic.blockCruiseLauncher), new Object[]{"RL ", "PPP", Character.valueOf('R'), new ItemStack(ICBMClassic.blockLaunchSupport, 1, 2), Character.valueOf('L'), new ItemStack(ICBMClassic.blockLaunchBase, 1, 2), Character.valueOf('P'), UniversalRecipe.PRIMARY_METAL.get()}));
    }

    public Object getServerGuiElement(int ID, EntityPlayer player) {
        return new ContainerCruiseLauncher(player, this);
    }

    public Object getClientGuiElement(int ID, EntityPlayer player) {
        return null;
    }
}

