/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.machines.launcher.screen;

import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.api.items.tools.IWorldPosItem;
import com.builtbroken.mc.api.map.radio.IRadioWaveSender;
import com.builtbroken.mc.api.tile.access.IGuiTile;
import com.builtbroken.mc.api.tile.provider.IInventoryProvider;
import com.builtbroken.mc.core.network.IPacketIDReceiver;
import com.builtbroken.mc.core.network.packet.PacketTile;
import com.builtbroken.mc.core.network.packet.PacketType;
import com.builtbroken.mc.core.registry.implement.IRecipeContainer;
import com.builtbroken.mc.imp.transform.vector.Location;
import com.builtbroken.mc.imp.transform.vector.Pos;
import com.builtbroken.mc.lib.helper.LanguageUtility;
import com.builtbroken.mc.lib.helper.recipe.UniversalRecipe;
import com.builtbroken.mc.prefab.gui.ContainerDummy;
import com.builtbroken.mc.prefab.hz.FakeRadioSender;
import com.builtbroken.mc.prefab.items.ItemBlockSubTypes;
import com.builtbroken.mc.prefab.tile.Tile;
import com.builtbroken.mc.prefab.tile.module.TileModuleInventory;
import icbm.classic.ICBMClassic;
import icbm.classic.content.items.ItemRemoteDetonator;
import icbm.classic.content.machines.launcher.TileLauncherPrefab;
import icbm.classic.content.machines.launcher.base.TileLauncherBase;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.ShapedOreRecipe;
import resonant.api.ITier;
import resonant.api.explosion.ILauncherController;
import resonant.api.explosion.LauncherType;

public class TileLauncherScreen
extends TileLauncherPrefab
implements ITier,
IPacketIDReceiver,
ILauncherController,
IRecipeContainer,
IGuiTile {
    private int tier = 0;
    public TileLauncherBase laucherBase = null;
    public short lockHeight = (short)3;

    public TileLauncherScreen() {
        super("launcherScreen", Material.field_151573_f);
        this.itemBlock = ItemBlockSubTypes.class;
        this.hardness = 10.0f;
        this.resistance = 10.0f;
        this.isOpaque = false;
    }

    protected IInventory createInventory() {
        return new TileModuleInventory((IInventoryProvider)this, 2);
    }

    public Tile newTile() {
        return new TileLauncherScreen();
    }

    @Override
    public void update() {
        super.update();
        if (this.laucherBase == null || this.laucherBase.func_145837_r()) {
            this.laucherBase = null;
            for (int i = 2; i < 6; i = (int)((byte)(i + 1))) {
                Pos position = (Pos)this.toPos().add(ForgeDirection.getOrientation((int)i));
                TileEntity tileEntity = position.getTileEntity((IBlockAccess)this.oldWorld());
                if (tileEntity == null || !(tileEntity instanceof TileLauncherBase)) continue;
                this.laucherBase = (TileLauncherBase)tileEntity;
                if (!this.isServer()) continue;
                this.setFacing(ForgeDirection.getOrientation((int)i).getOpposite());
                this.updateClient = true;
            }
        }
        if (this.isServer()) {
            if (this.ticks % 100L == 0L && this.isIndirectlyPowered()) {
                this.launch();
            }
            if (this.ticks % 3L == 0L) {
                this.sendDescPacket();
            }
        }
    }

    public boolean onPlayerActivated(EntityPlayer player, int side, Pos hit) {
        if (this.isServer()) {
            boolean notNull;
            boolean bl = notNull = player.func_70694_bm() != null;
            if (notNull && player.func_70694_bm().func_77973_b() == Items.field_151137_ax) {
                if (this.canLaunch()) {
                    this.launch();
                } else {
                    player.func_146105_b((IChatComponent)new ChatComponentText(LanguageUtility.getLocal((String)"chat.launcher.failedToFire")));
                    String translation = LanguageUtility.getLocal((String)"chat.launcher.status");
                    translation = translation.replace("%1", this.getStatus());
                    player.func_146105_b((IChatComponent)new ChatComponentText(translation));
                }
            } else if (notNull && player.func_70694_bm().func_77973_b() instanceof ItemRemoteDetonator) {
                ((ItemRemoteDetonator)player.func_70694_bm().func_77973_b()).setBroadCastHz(player.func_70694_bm(), this.getFrequency());
                player.func_146105_b((IChatComponent)new ChatComponentText(LanguageUtility.getLocal((String)"chat.launcher.toolFrequencySet").replace("%1", "" + this.getFrequency())));
            } else if (notNull && player.func_70694_bm().func_77973_b() instanceof IWorldPosItem) {
                Location location = ((IWorldPosItem)player.func_70694_bm().func_77973_b()).getLocation(player.func_70694_bm());
                if (location != null) {
                    if (location.oldWorld() == this.oldWorld()) {
                        this.setTarget(new Pos(location.x(), location.y(), location.z()));
                        player.func_146105_b((IChatComponent)new ChatComponentText(LanguageUtility.getLocal((String)"chat.launcher.toolTargetSet")));
                    } else {
                        player.func_146105_b((IChatComponent)new ChatComponentText(LanguageUtility.getLocal((String)"chat.launcher.toolWorldNotMatch")));
                    }
                } else {
                    player.func_146105_b((IChatComponent)new ChatComponentText(LanguageUtility.getLocal((String)"chat.launcher.noTargetInTool")));
                }
            } else {
                player.openGui((Object)ICBMClassic.INSTANCE, 0, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
        return true;
    }

    public PacketTile getDescPacket() {
        return new PacketTile((TileEntity)this, new Object[]{0, this.tier, this.getEnergy(), this.getFrequency(), this.lockHeight, this.getTarget().xi(), this.getTarget().yi(), this.getTarget().zi()});
    }

    @Override
    public PacketTile getGUIPacket() {
        return new PacketTile((TileEntity)this, new Object[]{4, this.getEnergy(), this.getTarget().xi(), this.getTarget().yi(), this.getTarget().zi()});
    }

    public void placeMissile(ItemStack itemStack) {
        if (this.laucherBase != null && !this.laucherBase.func_145837_r()) {
            this.laucherBase.func_70299_a(0, itemStack);
        }
    }

    public boolean read(ByteBuf data, int id, EntityPlayer player, PacketType packet) {
        if (!super.read(data, id, player, packet)) {
            switch (id) {
                case 0: {
                    this.tier = data.readInt();
                    this.setEnergy(data.readInt());
                    this.setFrequency(data.readInt());
                    this.lockHeight = data.readShort();
                    this.setTarget(new Pos((double)data.readInt(), (double)data.readInt(), (double)data.readInt()));
                    return true;
                }
                case 1: {
                    this.setFrequency(data.readInt());
                    return true;
                }
                case 2: {
                    this.setTarget(new Pos((double)data.readInt(), (double)data.readInt(), (double)data.readInt()));
                    return true;
                }
                case 3: {
                    this.lockHeight = (short)Math.max(Math.min(data.readShort(), Short.MAX_VALUE), 3);
                    return true;
                }
                case 4: {
                    this.setEnergy(data.readInt());
                    this.setTarget(new Pos((double)data.readInt(), (double)data.readInt(), (double)data.readInt()));
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public boolean canLaunch() {
        if (this.laucherBase != null && this.laucherBase.getMissileStack() != null && this.checkExtract()) {
            return this.laucherBase.isInRange(this.getTarget());
        }
        return false;
    }

    public void launch() {
        if (this.canLaunch() && this.laucherBase.launchMissile(this.getTarget(), this.lockHeight)) {
            this.extractEnergy();
            this.updateClient = true;
        }
    }

    @Override
    public String getStatus() {
        String color = "\u00a74";
        String status = LanguageUtility.getLocal((String)"gui.misc.idle");
        if (this.laucherBase == null) {
            status = LanguageUtility.getLocal((String)"gui.launcherScreen.statusMissing");
        } else if (!this.checkExtract()) {
            status = LanguageUtility.getLocal((String)"gui.launcherScreen.statusNoPower");
        } else if (this.laucherBase.getMissileStack() == null) {
            status = LanguageUtility.getLocal((String)"gui.launcherScreen.statusEmpty");
        } else if (this.getTarget() == null) {
            status = LanguageUtility.getLocal((String)"gui.launcherScreen.statusInvalid");
        } else if (this.laucherBase.isTargetTooClose(this.getTarget())) {
            status = LanguageUtility.getLocal((String)"gui.launcherScreen.statusClose");
        } else if (this.laucherBase.isTargetTooFar(this.getTarget())) {
            status = LanguageUtility.getLocal((String)"gui.launcherScreen.statusFar");
        } else {
            color = "\u00a72";
            status = LanguageUtility.getLocal((String)"gui.launcherScreen.statusReady");
        }
        return color + status;
    }

    @Override
    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        this.tier = par1NBTTagCompound.func_74762_e("tier");
        this.lockHeight = par1NBTTagCompound.func_74765_d("targetHeight");
    }

    @Override
    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("tier", this.tier);
        par1NBTTagCompound.func_74777_a("targetHeight", this.lockHeight);
    }

    public int getTier() {
        return this.tier;
    }

    public void setTier(int tier) {
        this.tier = tier;
        this.updateClient = true;
    }

    @Override
    public int getEnergyConsumption() {
        switch (this.getTier()) {
            case 0: {
                return 50000;
            }
            case 1: {
                return 80000;
            }
        }
        return 100000;
    }

    @Override
    public int getEnergyBufferSize() {
        return this.getEnergyConsumption() * 2;
    }

    public LauncherType getLauncherType() {
        return LauncherType.TRADITIONAL;
    }

    public void genRecipes(List<IRecipe> recipes) {
        recipes.add((IRecipe)new ShapedOreRecipe(new ItemStack(ICBMClassic.blockLaunchScreen, 1, 0), new Object[]{"!!!", "!#!", "!?!", Character.valueOf('#'), UniversalRecipe.CIRCUIT_T1.get(), Character.valueOf('!'), Blocks.field_150359_w, Character.valueOf('?'), UniversalRecipe.WIRE.get()}));
        recipes.add((IRecipe)new ShapedOreRecipe(new ItemStack(ICBMClassic.blockLaunchScreen, 1, 1), new Object[]{"!$!", "!#!", "!?!", Character.valueOf('#'), UniversalRecipe.CIRCUIT_T2.get(), Character.valueOf('!'), UniversalRecipe.PRIMARY_METAL.get(), Character.valueOf('?'), UniversalRecipe.WIRE.get(), Character.valueOf('$'), new ItemStack(ICBMClassic.blockLaunchScreen, 1, 0)}));
        recipes.add((IRecipe)new ShapedOreRecipe(new ItemStack(ICBMClassic.blockLaunchScreen, 1, 2), new Object[]{"!$!", "!#!", "!?!", Character.valueOf('#'), UniversalRecipe.CIRCUIT_T3.get(), Character.valueOf('!'), Items.field_151043_k, Character.valueOf('?'), UniversalRecipe.WIRE.get(), Character.valueOf('$'), new ItemStack(ICBMClassic.blockLaunchScreen, 1, 1)}));
    }

    public void onPlaced(EntityLivingBase entityLiving, ItemStack itemStack) {
        super.onPlaced(entityLiving, itemStack);
        this.setTier(itemStack.func_77960_j());
    }

    public void getSubBlocks(Item item, CreativeTabs creativeTabs, List list) {
        list.add(new ItemStack(item, 1, 0));
        list.add(new ItemStack(item, 1, 1));
        list.add(new ItemStack(item, 1, 2));
    }

    public Object getServerGuiElement(int ID, EntityPlayer player) {
        return new ContainerDummy();
    }

    public Object getClientGuiElement(int ID, EntityPlayer player) {
        return null;
    }

    @Override
    public void receiveRadioWave(float hz, IRadioWaveSender sender, String messageHeader, Object[] data) {
        int frequency = (int)Math.floor(hz);
        if (this.getTier() == 2 && frequency == this.getFrequency() && this.laucherBase != null) {
            if (messageHeader.equals("activateLauncherWithTarget")) {
                Pos pos = (Pos)data[0];
                if (this.toPos().distance((IPos3D)pos) < this.laucherBase.getRange()) {
                    this.setTarget(pos);
                    this.launch();
                    ((FakeRadioSender)sender).player.func_146105_b((IChatComponent)new ChatComponentText("Firing missile at " + pos));
                }
            } else if (messageHeader.equals("activateLauncher")) {
                ((FakeRadioSender)sender).player.func_146105_b((IChatComponent)new ChatComponentText("Firing missile at " + this.getTarget()));
                this.launch();
            }
        }
    }

    public int metadataDropped(int meta, int fortune) {
        return this.tier;
    }

    @Override
    protected boolean useMetaForFacing() {
        return true;
    }
}

