/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.machines.radarstation;

import com.builtbroken.jlib.data.vector.IPos2D;
import com.builtbroken.mc.api.data.IPacket;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.core.network.packet.PacketTile;
import com.builtbroken.mc.imp.transform.region.Rectangle;
import com.builtbroken.mc.imp.transform.vector.Point;
import com.builtbroken.mc.lib.helper.LanguageUtility;
import cpw.mods.fml.client.FMLClientHandler;
import icbm.classic.content.entity.EntityMissile;
import icbm.classic.content.gui.GuiICBM;
import icbm.classic.content.machines.radarstation.TileRadarStation;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiRadarStation
extends GuiICBM {
    public static final ResourceLocation TEXTURE = new ResourceLocation("icbmclassic", "textures/gui/gui_radar.png");
    public static final ResourceLocation TEXTURE_RED_DOT = new ResourceLocation("icbmclassic", "textures/gui/reddot.png");
    public static final ResourceLocation TEXTURE_YELLOW_DOT = new ResourceLocation("icbmclassic", "textures/gui/yellowdot.png");
    public static final ResourceLocation TEXTURE_WHITE_DOT = new ResourceLocation("icbmclassic", "textures/gui/whitedot.png");
    private TileRadarStation tileEntity;
    private int containerPosX;
    private int containerPosY;
    private GuiTextField textFieldAlarmRange;
    private GuiTextField textFieldSafetyZone;
    private GuiTextField textFieldFrequency;
    private Point mouseOverCoords = new Point();
    private Point mousePosition = new Point();
    private Point radarCenter;
    private float radarMapRadius;
    private String info = "";
    private String info2;

    public GuiRadarStation(TileRadarStation tileEntity) {
        this.tileEntity = tileEntity;
        this.mouseOverCoords = new Point((double)this.tileEntity.field_145851_c, (double)this.tileEntity.field_145849_e);
        this.field_147000_g = 166;
        this.field_146999_f = 256;
        this.radarCenter = new Point((double)(this.containerPosX + this.field_146999_f / 3 - 14), (double)(this.containerPosY + this.field_147000_g / 2 + 4));
        this.radarMapRadius = 7.836991f;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.textFieldSafetyZone = new GuiTextField(this.field_146289_q, 210, 67, 30, 12);
        this.textFieldSafetyZone.func_146203_f(3);
        this.textFieldSafetyZone.func_146180_a(this.tileEntity.safetyRange + "");
        this.textFieldAlarmRange = new GuiTextField(this.field_146289_q, 210, 82, 30, 12);
        this.textFieldAlarmRange.func_146203_f(3);
        this.textFieldAlarmRange.func_146180_a(this.tileEntity.alarmRange + "");
        this.textFieldFrequency = new GuiTextField(this.field_146289_q, 155, 112, 50, 12);
        this.textFieldFrequency.func_146203_f(6);
        this.textFieldFrequency.func_146180_a(this.tileEntity.getFrequency() + "");
    }

    public void func_146281_b() {
        super.func_146281_b();
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b("\u00a77" + LanguageUtility.getLocal((String)"tile.icbmclassic:radarStation.name"), this.field_146999_f / 2 - 30, 6, 0x404040);
        this.field_146289_q.func_78276_b(LanguageUtility.getLocal((String)"gui.radar.coords"), 155, 18, 0x404040);
        this.field_146289_q.func_78276_b(LanguageUtility.getLocal((String)"gui.misc.x") + " " + (int)Math.round(this.mouseOverCoords.x()) + " " + LanguageUtility.getLocal((String)"gui.misc.z") + " " + (int)Math.round(this.mouseOverCoords.y()), 155, 30, 0x404040);
        this.field_146289_q.func_78276_b("\u00a76" + this.info, 155, 42, 0x404040);
        this.field_146289_q.func_78276_b("\u00a74" + this.info2, 155, 54, 0x404040);
        this.field_146289_q.func_78276_b(LanguageUtility.getLocal((String)"gui.radar.zoneSafe"), 152, 70, 0x404040);
        this.textFieldSafetyZone.func_146194_f();
        this.field_146289_q.func_78276_b(LanguageUtility.getLocal((String)"gui.radar.zoneAlarm"), 150, 85, 0x404040);
        this.textFieldAlarmRange.func_146194_f();
        this.field_146289_q.func_78276_b(LanguageUtility.getLocal((String)"gui.misc.freq"), 155, 100, 0x404040);
        this.textFieldFrequency.func_146194_f();
        String color = "\u00a74";
        String status = LanguageUtility.getLocal((String)"gui.misc.idle");
        if (this.tileEntity.hasPower()) {
            color = "\u00a72";
            status = LanguageUtility.getLocal((String)"gui.radar.on");
        } else {
            status = LanguageUtility.getLocal((String)"gui.radar.nopower");
        }
        this.field_146289_q.func_78276_b(color + status, 155, 150, 0x404040);
    }

    public void func_73869_a(char par1, int par2) {
        super.func_73869_a(par1, par2);
        this.textFieldSafetyZone.func_146201_a(par1, par2);
        this.textFieldAlarmRange.func_146201_a(par1, par2);
        this.textFieldFrequency.func_146201_a(par1, par2);
        try {
            int newSafetyRadius;
            this.tileEntity.safetyRange = newSafetyRadius = Math.min(500, Math.max(0, Integer.parseInt(this.textFieldSafetyZone.func_146179_b())));
            Engine.packetHandler.sendToServer((IPacket)new PacketTile((TileEntity)this.tileEntity, new Object[]{2, this.tileEntity.safetyRange}));
        }
        catch (NumberFormatException newSafetyRadius) {
            // empty catch block
        }
        try {
            int newAlarmRadius;
            this.tileEntity.alarmRange = newAlarmRadius = Math.min(500, Math.max(0, Integer.parseInt(this.textFieldAlarmRange.func_146179_b())));
            Engine.packetHandler.sendToServer((IPacket)new PacketTile((TileEntity)this.tileEntity, new Object[]{3, this.tileEntity.alarmRange}));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.tileEntity.setFrequency(Integer.parseInt(this.textFieldFrequency.func_146179_b()));
            Engine.packetHandler.sendToServer((IPacket)new PacketTile((TileEntity)this.tileEntity, new Object[]{4, this.tileEntity.getFrequency()}));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void func_73864_a(int par1, int par2, int par3) {
        super.func_73864_a(par1, par2, par3);
        this.textFieldAlarmRange.func_146192_a(par1 - this.containerPosX, par2 - this.containerPosY, par3);
        this.textFieldSafetyZone.func_146192_a(par1 - this.containerPosX, par2 - this.containerPosY, par3);
        this.textFieldFrequency.func_146192_a(par1 - this.containerPosX, par2 - this.containerPosY, par3);
    }

    @Override
    protected void func_146976_a(float f, int mouseX, int mouseY) {
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(TEXTURE);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.containerPosX = (this.field_146294_l - this.field_146999_f) / 2;
        this.containerPosY = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(this.containerPosX, this.containerPosY, 0, 0, this.field_146999_f, this.field_147000_g);
        this.radarCenter = new Point((double)(this.containerPosX + this.field_146999_f / 3 - 10), (double)(this.containerPosY + this.field_147000_g / 2 + 4));
        this.radarMapRadius = 7.0422535f;
        this.info = "";
        this.info2 = "";
        if (this.tileEntity.hasPower()) {
            int range = 4;
            for (Entity entity : this.tileEntity.detectedEntities) {
                Point position = new Point(this.radarCenter.x() + (entity.field_70165_t - (double)this.tileEntity.field_145851_c) / (double)this.radarMapRadius, this.radarCenter.y() - (entity.field_70161_v - (double)this.tileEntity.field_145849_e) / (double)this.radarMapRadius);
                if (entity instanceof EntityMissile) {
                    if (this.tileEntity.isMissileGoingToHit((EntityMissile)entity)) {
                        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(TEXTURE_RED_DOT);
                    } else {
                        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(TEXTURE_YELLOW_DOT);
                    }
                } else {
                    FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(TEXTURE_WHITE_DOT);
                }
                this.func_73729_b(position.xi(), position.yi(), 0, 0, 2, 2);
                Point minPosition = (Point)position.clone();
                minPosition.add((double)(-range));
                Point maxPosition = (Point)position.clone();
                maxPosition.add((double)range);
                if (!new Rectangle(minPosition, maxPosition).isWithin((IPos2D)this.mousePosition)) continue;
                this.info = entity.func_70005_c_();
                if (entity instanceof EntityPlayer) {
                    this.info = "\u00a71" + this.info;
                }
                if (!(entity instanceof EntityMissile) || ((EntityMissile)entity).targetVector == null) continue;
                this.info2 = "(" + ((EntityMissile)entity).targetVector.xi() + ", " + ((EntityMissile)entity).targetVector.zi() + ")";
            }
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (Mouse.isInsideWindow() && Mouse.getEventButton() == -1) {
            this.mousePosition = new Point((double)(Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c), (double)(this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1));
            float difference = 500.0f / this.radarMapRadius;
            if (this.mousePosition.x() > this.radarCenter.x() - (double)difference && this.mousePosition.x() < this.radarCenter.x() + (double)difference && this.mousePosition.y() > this.radarCenter.y() - (double)difference && this.mousePosition.y() < this.radarCenter.y() + (double)difference) {
                int xDifference = (int)(this.mousePosition.x() - this.radarCenter.x());
                int yDifference = (int)(this.mousePosition.y() - this.radarCenter.y());
                int xBlockDistance = (int)((float)xDifference * this.radarMapRadius);
                int yBlockDistance = (int)((float)yDifference * this.radarMapRadius);
                this.mouseOverCoords = new Point((double)(this.tileEntity.field_145851_c + xBlockDistance), (double)(this.tileEntity.field_145849_e - yBlockDistance));
            }
        }
        if (!this.textFieldSafetyZone.func_146206_l()) {
            this.textFieldSafetyZone.func_146180_a(this.tileEntity.safetyRange + "");
        }
        if (!this.textFieldAlarmRange.func_146206_l()) {
            this.textFieldAlarmRange.func_146180_a(this.tileEntity.alarmRange + "");
        }
    }
}

