/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render;

import codechicken.lib.colour.ColourRGBA;
import codechicken.lib.render.CCRenderState;

public class ColourMultiplier
implements CCRenderState.IVertexOperation {
    public static final int operationIndex = CCRenderState.registerOperation();
    private static ColourMultiplier instance = new ColourMultiplier(-1);
    public int colour;

    public ColourMultiplier(int colour) {
        this.colour = colour;
    }

    public static ColourMultiplier instance(int colour) {
        ColourMultiplier.instance.colour = colour;
        return instance;
    }

    @Override
    public boolean load() {
        if (this.colour == -1) {
            CCRenderState.setColour(-1);
            return false;
        }
        CCRenderState.pipeline.addDependency(CCRenderState.colourAttrib);
        return true;
    }

    @Override
    public void operate() {
        CCRenderState.setColour(ColourRGBA.multiply(CCRenderState.colour, this.colour));
    }

    @Override
    public int operationID() {
        return operationIndex;
    }
}

