/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack;

import com.darkona.adventurebackpack.CreativeTabAB;
import com.darkona.adventurebackpack.config.ConfigHandler;
import com.darkona.adventurebackpack.fluids.FluidEffectRegistry;
import com.darkona.adventurebackpack.handlers.ClientEventHandler;
import com.darkona.adventurebackpack.handlers.GeneralEventHandler;
import com.darkona.adventurebackpack.handlers.GuiHandler;
import com.darkona.adventurebackpack.handlers.PlayerEventHandler;
import com.darkona.adventurebackpack.init.ConditionalFluidEffect;
import com.darkona.adventurebackpack.init.ModBlocks;
import com.darkona.adventurebackpack.init.ModEntities;
import com.darkona.adventurebackpack.init.ModFluids;
import com.darkona.adventurebackpack.init.ModItems;
import com.darkona.adventurebackpack.init.ModNetwork;
import com.darkona.adventurebackpack.init.ModRecipes;
import com.darkona.adventurebackpack.init.ModWorldGen;
import com.darkona.adventurebackpack.proxy.IProxy;
import com.darkona.adventurebackpack.util.LogHelper;
import com.darkona.adventurebackpack.util.Utils;
import com.darkona.adventurebackpack.util.calendar.ChineseCalendar;
import com.darkona.adventurebackpack.util.calendar.JewishCalendar;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import java.util.Calendar;
import net.minecraftforge.common.MinecraftForge;

@Mod(modid="adventurebackpack", name="Adventure Backpack", version="1.7.10-0.8b", guiFactory="com.darkona.adventurebackpack.client.gui.GuiFactory")
public class AdventureBackpack {
    @SidedProxy(clientSide="com.darkona.adventurebackpack.proxy.ClientProxy", serverSide="com.darkona.adventurebackpack.proxy.ServerProxy")
    public static IProxy proxy;
    @Mod.Instance(value="adventurebackpack")
    public static AdventureBackpack instance;
    public static CreativeTabAB creativeTab;
    public boolean chineseNewYear;
    public boolean hannukah;
    public String Holiday;
    PlayerEventHandler playerEventHandler;
    ClientEventHandler clientEventHandler;
    GeneralEventHandler generalEventHandler;
    GuiHandler guiHandler;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        int year = Calendar.getInstance().get(1);
        int month = Calendar.getInstance().get(2) + 1;
        int day = Calendar.getInstance().get(5);
        FMLCommonHandler.instance().bus().register((Object)new ConfigHandler());
        ConfigHandler.init(event.getSuggestedConfigurationFile());
        this.chineseNewYear = ChineseCalendar.isChineseNewYear(year, month, day);
        this.hannukah = JewishCalendar.isHannukah(year, month, day);
        this.Holiday = Utils.getHoliday();
        ModItems.init();
        ModBlocks.init();
        ModFluids.init();
        FluidEffectRegistry.init();
        ModEntities.init();
        ModNetwork.init();
        proxy.initNetwork();
        this.playerEventHandler = new PlayerEventHandler();
        this.generalEventHandler = new GeneralEventHandler();
        this.clientEventHandler = new ClientEventHandler();
        MinecraftForge.EVENT_BUS.register((Object)this.generalEventHandler);
        MinecraftForge.EVENT_BUS.register((Object)this.clientEventHandler);
        MinecraftForge.EVENT_BUS.register((Object)this.playerEventHandler);
        FMLCommonHandler.instance().bus().register((Object)this.playerEventHandler);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init();
        ModRecipes.init();
        ModWorldGen.init();
        this.guiHandler = new GuiHandler();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)this.guiHandler);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ConfigHandler.IS_BAUBLES = Loader.isModLoaded((String)"Baubles");
        ConfigHandler.IS_TINKERS = Loader.isModLoaded((String)"TConstruct");
        ConfigHandler.IS_THAUM = Loader.isModLoaded((String)"Thaumcraft");
        ConfigHandler.IS_TWILIGHT = Loader.isModLoaded((String)"TwilightForest");
        ConfigHandler.IS_ENVIROMINE = Loader.isModLoaded((String)"EnviroMine");
        ConfigHandler.IS_BUILDCRAFT = Loader.isModLoaded((String)"BuildCraft|Core");
        ConfigHandler.IS_RAILCRAFT = Loader.isModLoaded((String)"Railcraft");
        if (ConfigHandler.IS_BAUBLES) {
            LogHelper.info("Baubles is present. Acting accordingly");
        }
        if (ConfigHandler.IS_BUILDCRAFT) {
            LogHelper.info("Buildcraft is present. Acting accordingly");
        }
        if (ConfigHandler.IS_TWILIGHT) {
            LogHelper.info("Twilight Forest is present. Acting accordingly");
        }
        ConditionalFluidEffect.init();
        ModItems.conditionalInit();
        ModRecipes.conditionalInit();
    }

    static {
        creativeTab = new CreativeTabAB();
    }
}

