/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.inventory;

import com.darkona.adventurebackpack.common.IInventoryAdventureBackpack;
import com.darkona.adventurebackpack.inventory.IInventoryTanks;
import com.darkona.adventurebackpack.util.FluidUtils;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class InventoryActions {
    public static boolean transferContainerTank(IInventoryTanks inventory, FluidTank tank, int slotIn) {
        int fill;
        ItemStack stackIn = inventory.func_70301_a(slotIn);
        if (tank == null || stackIn == null) {
            return false;
        }
        int slotOut = slotIn + 1;
        if (FluidContainerRegistry.isFilledContainer((ItemStack)stackIn) && (fill = tank.fill(FluidContainerRegistry.getFluidForFilledItem((ItemStack)stackIn), false)) > 0) {
            int maxStack;
            ItemStack stackOut = FluidContainerRegistry.drainFluidContainer((ItemStack)stackIn);
            if (inventory.func_70301_a(slotOut) == null || stackOut == null) {
                tank.fill(FluidContainerRegistry.getFluidForFilledItem((ItemStack)stackIn), true);
                inventory.decrStackSizeNoSave(slotIn, 1);
                inventory.setInventorySlotContentsNoSave(slotOut, stackOut);
                return true;
            }
            if (inventory.func_70301_a(slotOut).func_77973_b() == stackOut.func_77973_b() && (maxStack = inventory.func_70301_a(slotOut).func_77976_d()) > 1 && inventory.func_70301_a((int)slotOut).field_77994_a + 1 <= maxStack) {
                tank.fill(FluidContainerRegistry.getFluidForFilledItem((ItemStack)stackIn), true);
                inventory.decrStackSizeNoSave(slotIn, 1);
                ++inventory.func_70301_a((int)slotOut).field_77994_a;
                return true;
            }
        }
        if (tank.getFluid() != null && tank.getFluidAmount() > 0 && FluidUtils.isEmptyContainerForFluid(stackIn, tank.getFluid().getFluid())) {
            int amount = FluidContainerRegistry.getContainerCapacity((FluidStack)tank.getFluid(), (ItemStack)stackIn);
            FluidStack drain = tank.drain(amount, false);
            ItemStack stackOut = FluidContainerRegistry.fillFluidContainer((FluidStack)drain, (ItemStack)stackIn);
            if (drain.amount == amount) {
                int maxStack;
                if (inventory.func_70301_a(slotOut) == null) {
                    tank.drain(amount, true);
                    inventory.decrStackSizeNoSave(slotIn, 1);
                    inventory.setInventorySlotContentsNoSave(slotOut, stackOut);
                    return true;
                }
                if (stackOut.func_77973_b() != null && stackOut.func_77973_b() == inventory.func_70301_a(slotOut).func_77973_b() && (maxStack = inventory.func_70301_a(slotOut).func_77976_d()) > 1 && inventory.func_70301_a((int)slotOut).field_77994_a + 1 <= maxStack) {
                    tank.drain(amount, true);
                    inventory.decrStackSizeNoSave(slotIn, 1);
                    ++inventory.func_70301_a((int)slotOut).field_77994_a;
                    return true;
                }
            }
        }
        return false;
    }

    public static void consumeItemInInventory(IInventory backpack, Item item) {
        int i = -1;
        for (int j = 0; j < 38; ++j) {
            if (backpack.func_70301_a(j) == null || backpack.func_70301_a(j).func_77973_b() != item) continue;
            i = j;
            break;
        }
        if (i >= 0) {
            backpack.func_70298_a(i, 1);
        }
    }

    public static boolean hasItem(IInventoryAdventureBackpack backpack, Item item) {
        ItemStack[] inventory = backpack.getInventory();
        for (int i = 0; i < inventory.length; ++i) {
            if (inventory[i] == null || !inventory[i].func_77973_b().equals(item)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasBlockItem(IInventoryAdventureBackpack backpack, Block item) {
        ItemStack[] inventory = backpack.getInventory();
        for (int i = 0; i < inventory.length; ++i) {
            if (inventory[i] == null || !inventory[i].func_77973_b().equals(Item.func_150898_a((Block)item))) continue;
            return true;
        }
        return false;
    }
}

