/*
 * Decompiled with CFR 0.152.
 */
package airbreather.mods.yafm;

import airbreather.mods.airbreathercore.item.ItemDefinition;
import airbreather.mods.airbreathercore.mod.IModule;
import airbreather.mods.airbreathercore.recipe.Recipe;
import airbreather.mods.airbreathercore.recipe.SmeltingRecipe;
import com.google.common.base.Preconditions;
import cpw.mods.fml.common.registry.GameData;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

final class MCAAddons {
    private static final Logger logger = LogManager.getLogger();
    private final IModule module;

    public MCAAddons(IModule module) {
        this.module = (IModule)Preconditions.checkNotNull((Object)module, (Object)"module");
    }

    public void Register() {
        Class<?> cookableFoodClass = null;
        Class<?> choreRegistryClass = null;
        try {
            cookableFoodClass = Class.forName("mca.api.chores.CookableFood");
            choreRegistryClass = Class.forName("mca.api.registries.ChoreRegistry");
        }
        catch (Throwable _) {
            // empty catch block
        }
        if (cookableFoodClass == null || choreRegistryClass == null) {
            logger.info("MCA not detected.  Skipping adding MCA chores to cook YAFM food items");
            return;
        }
        logger.info("MCA detected.  Adding MCA chores to cook YAFM food items");
        try {
            MCAAddons.LogMCACookingEntries(choreRegistryClass, cookableFoodClass, "before");
            for (Recipe recipe : this.module.GetCustomConfiguration().GetRecipeConfiguration().GetRecipes()) {
                if (!(recipe instanceof SmeltingRecipe)) continue;
                SmeltingRecipe smeltingRecipe = (SmeltingRecipe)recipe;
                ItemDefinition input = smeltingRecipe.GetInput();
                ItemDefinition output = smeltingRecipe.GetResult().GetItemDefinition();
                this.RegisterMCACookableFood(cookableFoodClass, choreRegistryClass, input, output);
            }
            MCAAddons.LogMCACookingEntries(choreRegistryClass, cookableFoodClass, "after ");
        }
        catch (Throwable exception) {
            logger.error("Unexpected problem occurred when trying to register MCA chores for YAFM food.", exception);
        }
    }

    private <TCookableFood> void RegisterMCACookableFood(Class<TCookableFood> cookableFoodClass, Class<?> choreRegistryClass, ItemDefinition rawItemDefinition, ItemDefinition cookedItemDefinition) throws Throwable {
        Item rawItem = this.module.GetItemRegistry().FetchItem(rawItemDefinition);
        Item cookedItem = this.module.GetItemRegistry().FetchItem(cookedItemDefinition);
        Constructor<TCookableFood> cookableFoodConstructor = cookableFoodClass.getConstructor(Item.class, Item.class);
        TCookableFood cookableFood = cookableFoodConstructor.newInstance(rawItem, cookedItem);
        Method registerMethod = choreRegistryClass.getMethod("registerChoreEntry", Object.class);
        registerMethod.invoke(null, cookableFood);
    }

    private static <TCookableFood> void LogMCACookingEntries(Class<?> choreRegistryClass, Class<TCookableFood> cookableFoodClass, String stage) {
        try {
            Method getCookingEntriesMethod = choreRegistryClass.getMethod("getCookingEntries", new Class[0]);
            List cookingEntries = (List)getCookingEntriesMethod.invoke(null, new Object[0]);
            Method getRawFoodMethod = cookableFoodClass.getMethod("getRawFoodItem", new Class[0]);
            Method getCookedFoodMethod = cookableFoodClass.getMethod("getCookedFoodItem", new Class[0]);
            ArrayList<String> cookingEntryStrings = new ArrayList<String>();
            for (Object cookingEntryObj : cookingEntries) {
                if (!cookableFoodClass.isInstance(cookingEntryObj)) {
                    logger.error("Expected CookableFood, not %s", new Object[]{cookingEntryObj.getClass()});
                    continue;
                }
                TCookableFood cookingEntry = cookableFoodClass.cast(cookingEntryObj);
                Item rawFoodItem = (Item)getRawFoodMethod.invoke(cookingEntry, new Object[0]);
                Item cookedFoodItem = (Item)getCookedFoodMethod.invoke(cookingEntry, new Object[0]);
                String cookingEntryString = "[" + GameData.itemRegistry.func_148750_c((Object)rawFoodItem) + " --> " + GameData.itemRegistry.func_148750_c((Object)cookedFoodItem) + "]";
                cookingEntryStrings.add(cookingEntryString);
            }
            logger.debug(String.format("MCA cookable food entries %s: %s", stage, cookingEntryStrings));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

