/*
 * Decompiled with CFR 0.152.
 */
package airbreather.mods.yafm;

import airbreather.mods.airbreathercore.event.EventConfiguration;
import airbreather.mods.airbreathercore.event.EventType;
import airbreather.mods.yafm.YafmSheepDropEventHandler;
import airbreather.mods.yafm.YafmSquidDropEventHandler;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import cpw.mods.fml.common.eventhandler.IEventListener;

final class YafmEventConfiguration
implements EventConfiguration {
    private final YafmSheepDropEventHandler sheepHandler;
    private final YafmSquidDropEventHandler squidHandler;
    private boolean enableRawMuttonDrops = false;
    private boolean enableRawSquidDrops = false;

    public YafmEventConfiguration(YafmSheepDropEventHandler sheepHandler, YafmSquidDropEventHandler squidHandler) {
        this.sheepHandler = (YafmSheepDropEventHandler)Preconditions.checkNotNull((Object)sheepHandler, (Object)"sheepHandler");
        this.squidHandler = (YafmSquidDropEventHandler)Preconditions.checkNotNull((Object)squidHandler, (Object)"squidHandler");
    }

    public void EnableRawMuttonDrops() {
        this.enableRawMuttonDrops = true;
    }

    public void EnableRawSquidDrops() {
        this.enableRawSquidDrops = true;
    }

    @Override
    public Iterable<EventType> GetRecognizedEventTypes() {
        return ImmutableList.of((Object)((Object)EventType.LivingDrops));
    }

    @Override
    public Iterable<IEventListener> GetEventHandlers(EventType eventType) {
        switch (eventType) {
            case LivingDrops: {
                return this.GetLivingDropsEventHandlers();
            }
        }
        return ImmutableList.of();
    }

    private Iterable<IEventListener> GetLivingDropsEventHandlers() {
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        if (this.enableRawMuttonDrops) {
            resultBuilder.add((Object)this.sheepHandler);
        }
        if (this.enableRawSquidDrops) {
            resultBuilder.add((Object)this.squidHandler);
        }
        return resultBuilder.build();
    }
}

