/*
 * Decompiled with CFR 0.152.
 */
package airbreather.mods.yafm;

import airbreather.mods.airbreathercore.item.ItemDefinition;
import airbreather.mods.airbreathercore.recipe.Recipe;
import airbreather.mods.airbreathercore.recipe.RecipeConfiguration;
import airbreather.mods.airbreathercore.recipe.RecipeResult;
import airbreather.mods.airbreathercore.recipe.ShapelessCraftingRecipe;
import airbreather.mods.airbreathercore.recipe.SmeltingRecipe;
import airbreather.mods.yafm.YafmConstants;
import com.google.common.collect.ImmutableList;

final class YafmRecipeConfiguration
implements RecipeConfiguration {
    private static final float FoodSmeltingExperience = 0.35f;
    private boolean enableFriedEggRecipe = false;
    private boolean enableCookedMuttonRecipe = false;
    private boolean enableCookedSquidRecipe = false;
    private boolean enableCarrotSoupRecipe = false;

    YafmRecipeConfiguration() {
    }

    public void EnableFriedEggRecipe() {
        this.enableFriedEggRecipe = true;
    }

    public void EnableCarrotSoupRecipe() {
        this.enableCarrotSoupRecipe = true;
    }

    public void EnableCookedMuttonRecipe() {
        this.enableCookedMuttonRecipe = true;
    }

    public void EnableCookedSquidRecipe() {
        this.enableCookedSquidRecipe = true;
    }

    @Override
    public Iterable<Recipe> GetRecipes() {
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        if (this.enableFriedEggRecipe) {
            ItemDefinition egg = YafmConstants.EggItemDefinition;
            ItemDefinition friedEgg = YafmConstants.FriedEggItemDefinition;
            RecipeResult friedEggResult = new RecipeResult(friedEgg);
            SmeltingRecipe friedEggRecipe = new SmeltingRecipe(friedEggResult, egg, 0.35f);
            resultBuilder.add((Object)friedEggRecipe);
        }
        if (this.enableCarrotSoupRecipe) {
            ItemDefinition carrot = YafmConstants.CarrotItemDefinition;
            ItemDefinition bowl = YafmConstants.BowlItemDefinition;
            ItemDefinition carrotSoup = YafmConstants.CarrotSoupItemDefinition;
            RecipeResult carrotSoupResult = new RecipeResult(carrotSoup);
            ImmutableList inputs = ImmutableList.of((Object)carrot, (Object)carrot, (Object)bowl);
            ShapelessCraftingRecipe carrotSoupRecipe = new ShapelessCraftingRecipe(carrotSoupResult, (Iterable<ItemDefinition>)inputs);
            resultBuilder.add((Object)carrotSoupRecipe);
        }
        if (this.enableCookedMuttonRecipe) {
            ItemDefinition rawMutton = YafmConstants.RawMuttonItemDefinition;
            ItemDefinition cookedMutton = YafmConstants.CookedMuttonItemDefinition;
            RecipeResult cookedMuttonResult = new RecipeResult(cookedMutton);
            SmeltingRecipe cookedMuttonRecipe = new SmeltingRecipe(cookedMuttonResult, rawMutton, 0.35f);
            resultBuilder.add((Object)cookedMuttonRecipe);
        }
        if (this.enableCookedSquidRecipe) {
            ItemDefinition rawSquid = YafmConstants.RawSquidItemDefinition;
            ItemDefinition cookedSquid = YafmConstants.CookedSquidItemDefinition;
            RecipeResult cookedSquidResult = new RecipeResult(cookedSquid);
            SmeltingRecipe cookedSquidRecipe = new SmeltingRecipe(cookedSquidResult, rawSquid, 0.35f);
            resultBuilder.add((Object)cookedSquidRecipe);
        }
        return resultBuilder.build();
    }
}

