/*
 * Decompiled with CFR 0.152.
 */
package cavebiomes;

import cavebiomes.CaveBiomesAPI;
import cavebiomes.EventListener;
import cavebiomes.WTFCaveBiomesConfig;
import cavebiomes.api.APICaveBiomes;
import cavebiomes.api.CaveType;
import cavebiomes.api.DungeonType;
import cavebiomes.blocks.CaveBlocks;
import cavebiomes.entities.Entities;
import cavebiomes.items.ArmorRegistry;
import cavebiomes.proxy.CommonProxy;
import cavebiomes.renderers.RenderRegisterer;
import cavebiomes.utilities.gencores.GenCoreProvider;
import cavebiomes.worldgeneration.CaveBiomesChunkScanner;
import cavebiomes.worldgeneration.dungeontypes.DungeonTypeRegister;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraftforge.common.MinecraftForge;
import wtfcore.InterModBlocks;
import wtfcore.WTFCore;
import wtfcore.WTFCoreConfig;
import wtfcore.worldgen.WorldGenListener;

@Mod(modid="CaveBiomes", name="WhiskyTangoFox's Cave Biomes", version="1.6", dependencies="after:UndergroundBiomes;required-after:WTFCore@[1.7,);required-after:TextureGeneratorLib")
public class CaveBiomes {
    public static final String modid = "CaveBiomes";
    @Mod.Instance(value="CaveBiomes")
    public static CaveBiomes instance;
    @SidedProxy(clientSide="cavebiomes.proxy.CBClientProxy", serverSide="cavebiomes.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static String alphaMaskDomain;
    public static String overlayDomain;
    public static CreativeTabs tabCaveDecorations;

    @Mod.EventHandler
    public void PreInit(FMLPreInitializationEvent preEvent) {
        APICaveBiomes.CAVEBIOMESAPI = new CaveBiomesAPI();
        WTFCaveBiomesConfig.customConfig();
        Entities.RegisterEntityList();
        proxy.registerRenderers();
        RenderRegisterer.RegisterCustomRenderers();
        ArmorRegistry.registerArmorTypes();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        CaveBlocks.BlockRegister();
        MinecraftForge.EVENT_BUS.register((Object)new EventListener());
        DungeonTypeRegister.AddDungeonTypes();
    }

    @Mod.EventHandler
    public void PostInit(FMLPostInitializationEvent postEvent) {
        CaveType.gen = GenCoreProvider.getGenCore();
        DungeonType.gen = GenCoreProvider.getGenCore();
        InterModBlocks.gen = GenCoreProvider.getGenCore();
        Iterator iterator = WTFCoreConfig.overworlds.iterator();
        while (iterator.hasNext()) {
            int dimensionID = (Integer)iterator.next();
            WorldGenListener.GetScanner.put(dimensionID, new CaveBiomesChunkScanner());
            WTFCore.log.info("Adding CaveBiomes Overworld scanner for dimension " + dimensionID);
        }
    }

    static {
        alphaMaskDomain = "cavebiomes:textures/blocks/alphamasks/";
        overlayDomain = "cavebiomes:textures/blocks/overlays/";
        tabCaveDecorations = new CreativeTabs("CaveDecorations"){

            @SideOnly(value=Side.CLIENT)
            public Item func_78016_d() {
                return Item.func_150898_a((Block)CaveBlocks.GlowstoneStalactite);
            }
        };
    }
}

