/*
 * Decompiled with CFR 0.152.
 */
package cavebiomes.blocks;

import cavebiomes.CaveBiomes;
import cavebiomes.blocks.CaveBlocks;
import cavebiomes.blocks.FrozenBlock;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import texturegeneratorlib.TextureGeneratorLib;
import wtfcore.blocks.ChildBlockCarryMetadata;
import wtfcore.items.ItemMetadataSubblock;

public class BlockSpeleothems
extends ChildBlockCarryMetadata {
    public Block parentBlock;
    public static Block blockToRegister;
    protected int speleothemType;
    private IIcon[] textures;
    protected String[] textureNames;
    protected String[] parentLocations;
    protected String[] maskType;
    public static final int stalactitesmall = 0;
    public static final int stalactitelargebase = 1;
    public static final int stalactitelargetip = 2;
    public static final int largecolumn = 3;
    public static final int stalagmitesmall = 4;
    public static final int stalagmitelargebase = 5;
    public static final int stalagmitelargetip = 6;
    public static String[] formationList;

    protected BlockSpeleothems(Block block, int type, String[] stoneNames, String domain) {
        super(block);
        this.func_149647_a(CaveBiomes.tabCaveDecorations);
        this.parentBlock = block;
        this.speleothemType = type;
        this.loadTextureStrings(stoneNames, domain);
    }

    public static void registerSpeleothemSet(Block block, String unlocalisedName, String[] stoneNames, String domain) {
        BlockSpeleothems[] blockArray = new BlockSpeleothems[8];
        FrozenBlock[] frozenblockArray = new FrozenBlock[8];
        for (int formationTypeLoop = 0; formationTypeLoop < formationList.length; ++formationTypeLoop) {
            String name = unlocalisedName + "_" + formationList[formationTypeLoop];
            blockToRegister = new BlockSpeleothems(block, formationTypeLoop, stoneNames, domain).func_149663_c(name);
            GameRegistry.registerBlock((Block)blockToRegister, ItemMetadataSubblock.class, (String)name);
            String[] frozenstoneNames = new String[stoneNames.length];
            for (int loop = 0; loop < stoneNames.length; ++loop) {
                frozenstoneNames[loop] = stoneNames[loop] + "_" + formationList[formationTypeLoop];
            }
            Block frozenBlockToRegister = new FrozenBlock(Blocks.field_150432_aD, blockToRegister, frozenstoneNames, "overlays").func_149663_c("frozen_" + name);
            GameRegistry.registerBlock((Block)frozenBlockToRegister, ItemMetadataSubblock.class, (String)("frozen_" + name));
            frozenblockArray[formationTypeLoop] = (FrozenBlock)frozenBlockToRegister;
            blockArray[formationTypeLoop] = (BlockSpeleothems)blockToRegister;
        }
        if (block == Blocks.field_150451_bX) {
            CaveBlocks.speleothemMap.put(Blocks.field_150450_ax, blockArray);
            CaveBlocks.frozenspeleothemMap.put(Blocks.field_150450_ax, frozenblockArray);
        }
        CaveBlocks.speleothemMap.put(block, blockArray);
        CaveBlocks.frozenspeleothemMap.put(block, frozenblockArray);
    }

    public void loadTextureStrings(String[] stoneNames, String domain) {
        String[] tempTextureNames = new String[stoneNames.length];
        String[] tempParentLocations = new String[stoneNames.length];
        for (int loop = 0; loop < stoneNames.length; ++loop) {
            tempTextureNames[loop] = stoneNames[loop] + "_" + formationList[this.speleothemType];
            tempParentLocations[loop] = domain + ":" + stoneNames[loop];
        }
        this.textureNames = tempTextureNames;
        this.parentLocations = tempParentLocations;
        this.maskType = formationList;
    }

    public boolean canSilkHarvest(World world, EntityPlayer player, int x, int y, int z, int metadata) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < this.textureNames.length; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return 1;
    }

    public void func_149651_a(IIconRegister iconRegister) {
        this.textures = new IIcon[16];
        for (int loop = 0; loop < this.textureNames.length; ++loop) {
            this.textures[loop] = iconRegister.func_94245_a("CaveBiomes:" + this.textureNames[loop]);
            TextureGeneratorLib.registerBlockOverlay((Block)this, (String)this.textureNames[loop], (String)this.parentLocations[loop], (String)this.maskType[this.speleothemType], (String)CaveBiomes.alphaMaskDomain, (boolean)true);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.textures[meta];
    }

    public AxisAlignedBB func_149668_a(World p_149668_1_, int p_149668_2_, int p_149668_3_, int p_149668_4_) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess p_149673_1_, int p_149673_2_, int p_149673_3_, int p_149673_4_, int p_149673_5_) {
        return this.func_149691_a(p_149673_5_, p_149673_1_.func_72805_g(p_149673_2_, p_149673_3_, p_149673_4_));
    }

    public int getSpeleothemType() {
        return this.speleothemType;
    }

    public void func_149719_a(IBlockAccess p_149719_1_, int p_149719_2_, int p_149719_3_, int p_149719_4_) {
        switch (this.getSpeleothemType()) {
            case 0: {
                this.func_149676_a(0.2f, 0.2f, 0.2f, 0.8f, 1.0f, 0.8f);
                break;
            }
            case 1: {
                this.func_149676_a(0.2f, 0.0f, 0.2f, 0.8f, 1.0f, 0.8f);
                break;
            }
            case 2: {
                this.func_149676_a(0.3f, 0.4f, 0.3f, 0.7f, 1.0f, 0.7f);
                break;
            }
            case 3: {
                this.func_149676_a(0.3f, 0.0f, 0.3f, 0.7f, 1.0f, 0.7f);
                break;
            }
            case 4: {
                this.func_149676_a(0.2f, 0.0f, 0.2f, 0.8f, 0.8f, 0.8f);
                break;
            }
            case 5: {
                this.func_149676_a(0.2f, 0.0f, 0.2f, 0.8f, 1.0f, 0.8f);
                break;
            }
            case 6: {
                this.func_149676_a(0.3f, 0.0f, 0.3f, 0.7f, 0.7f, 0.7f);
            }
        }
    }

    static {
        formationList = new String[]{"stalactite_small", "stalactite_base", "stalactite_tip", "column", "stalagmite_small", "stalagmite_base", "stalagmite_tip"};
    }
}

