/*
 * Decompiled with CFR 0.152.
 */
package cavebiomes.blocks;

import cavebiomes.CaveBiomes;
import cavebiomes.WTFCaveBiomesConfig;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import wtfcore.api.BlockInfo;
import wtfcore.api.BlockSets;
import wtfcore.blocks.ChildBlockCarryMetadata;
import wtfcore.items.ItemMetadataSubblock;

public class DrippingBlock
extends ChildBlockCarryMetadata {
    boolean isWater;
    int dripFreq;
    private int numsubblocks;

    protected DrippingBlock(Block block, int subblocks, BlockSets.Modifier drip, int freq) {
        super(block);
        this.dripFreq = freq;
        this.isWater = drip == BlockSets.Modifier.waterDrippingStone || drip == BlockSets.Modifier.WaterRainStone;
        this.func_149675_a(WTFCaveBiomesConfig.enableDrippingBlocks);
        this.numsubblocks = subblocks;
        this.func_149647_a(CaveBiomes.tabCaveDecorations);
    }

    public static void registerDrippingStoneSet(Block block, String name, int subBlocks, boolean water, boolean lava) {
        if (!name.endsWith("stone")) {
            name = name + "_stone";
        }
        if (water) {
            DrippingBlock.registerDrippingBlock(block, subBlocks, BlockSets.Modifier.waterDrippingStone, 1, "dripping_water_" + name);
            DrippingBlock.registerDrippingBlock(block, subBlocks, BlockSets.Modifier.WaterRainStone, 20, "raining_water_" + name);
        }
        if (lava) {
            DrippingBlock.registerDrippingBlock(block, subBlocks, BlockSets.Modifier.lavaDrippinStone, 1, "dripping_lava_" + name);
            DrippingBlock.registerDrippingBlock(block, subBlocks, BlockSets.Modifier.LavaRainStone, 20, "raining_lava_" + name);
        }
    }

    public static void registerDrippingBlock(Block block, int numSubBlocks, BlockSets.Modifier fluid, int frequency, String name) {
        Block blockToRegister = new DrippingBlock(block, numSubBlocks, fluid, frequency).func_149663_c(name);
        GameRegistry.registerBlock((Block)blockToRegister, ItemMetadataSubblock.class, (String)name);
        for (int loop = 0; loop < 8; ++loop) {
            BlockSets.blockTransformer.put(new BlockInfo(block, loop, fluid), blockToRegister);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < this.numsubblocks + 1; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random random) {
        if (random.nextInt(20) < this.dripFreq && world.func_147439_a(x, y - 1, z).func_149662_c() && WTFCaveBiomesConfig.enableDrippingBlocks) {
            double d5 = (float)x + random.nextFloat();
            double d6 = (double)y - 0.05;
            double d7 = (float)z + random.nextFloat();
            if (this.isWater) {
                world.func_72869_a("dripWater", d5, d6, d7, 0.0, 0.0, 0.0);
            } else {
                world.func_72869_a("dripLava", d5, d6, d7, 0.0, 0.0, 0.0);
            }
        }
    }

    public boolean canSilkHarvest(World world, EntityPlayer player, int x, int y, int z, int metadata) {
        return true;
    }
}

