/*
 * Decompiled with CFR 0.152.
 */
package cavebiomes.blocks;

import cavebiomes.proxy.CBClientProxy;
import cavebiomes.renderers.RenderRegisterer;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPackedIce;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.ForgeDirection;
import wtfcore.api.BlockSets;

public class FrozenBlock
extends BlockPackedIce {
    public Block outterBlock;
    public Block innerBlock;
    private IIcon[] textures;
    protected String[] textureNames;
    protected String[] parentLocations;

    protected FrozenBlock(Block outter, Block inner, String[] parentNames, String domain) {
        this.outterBlock = outter;
        this.innerBlock = inner;
        this.func_149672_a(outter.field_149762_H);
        this.func_149676_a((float)outter.func_149704_x(), (float)outter.func_149665_z(), (float)outter.func_149706_B(), (float)outter.func_149753_y(), (float)outter.func_149669_A(), (float)outter.func_149693_C());
        this.loadTextureStrings(parentNames, domain);
    }

    public void loadTextureStrings(String[] stoneNames, String domain) {
        String[] tempTextureNames = new String[stoneNames.length];
        String[] tempParentLocations = new String[stoneNames.length];
        for (int loop = 0; loop < stoneNames.length; ++loop) {
            tempTextureNames[loop] = "frozen_" + stoneNames[loop];
            tempParentLocations[loop] = domain + ":" + stoneNames[loop];
        }
        this.textureNames = stoneNames;
        this.parentLocations = tempParentLocations;
    }

    public int func_149660_a(World p_149660_1_, int p_149660_2_, int p_149660_3_, int p_149660_4_, int p_149660_5_, float p_149660_6_, float p_149660_7_, float p_149660_8_, int p_149660_9_) {
        return this.innerBlock.func_149660_a(p_149660_1_, p_149660_2_, p_149660_3_, p_149660_4_, p_149660_5_, p_149660_6_, p_149660_7_, p_149660_8_, p_149660_9_);
    }

    public void func_149689_a(World p_149689_1_, int p_149689_2_, int p_149689_3_, int p_149689_4_, EntityLivingBase p_149689_5_, ItemStack p_149689_6_) {
        this.innerBlock.func_149689_a(p_149689_1_, p_149689_2_, p_149689_3_, p_149689_4_, p_149689_5_, p_149689_6_);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < 8; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        if (world.func_147439_a(x, y, z) instanceof FrozenBlock) {
            return false;
        }
        return side == 0 && this.field_149760_C > 0.0 ? true : (side == 1 && this.field_149756_F < 1.0 ? true : (side == 2 && this.field_149754_D > 0.0 ? true : (side == 3 && this.field_149757_G < 1.0 ? true : (side == 4 && this.field_149759_B > 0.0 ? true : (side == 5 && this.field_149755_E < 1.0 ? true : !world.func_147439_a(x, y, z).func_149662_c())))));
    }

    public boolean canSilkHarvest(World world, EntityPlayer player, int x, int y, int z, int metadata) {
        return true;
    }

    public AxisAlignedBB func_149668_a(World p_149668_1_, int p_149668_2_, int p_149668_3_, int p_149668_4_) {
        return this.outterBlock.func_149668_a(p_149668_1_, p_149668_2_, p_149668_3_, p_149668_4_);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int p_149691_1_, int p_149691_2_) {
        return this.outterBlock.func_149691_a(p_149691_1_, p_149691_2_);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        return this.outterBlock.func_149691_a(side, world.func_72805_g(x, y, z));
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149645_b() {
        return RenderRegisterer.FrozenBlockRenderType;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        world.func_147464_a(x, y, z, (Block)this, 20);
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        this.checkAndDropBlock(world, x, y, z);
    }

    protected void checkAndDropBlock(World world, int x, int y, int z) {
        if (!this.func_149718_j(world, x, y, z)) {
            world.func_147449_b(x, y, z, this.innerBlock);
        }
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        if (BlockSets.meltBlocks.contains(world.func_147439_a(x, y - 1, z))) {
            return false;
        }
        if (BlockSets.meltBlocks.contains(world.func_147439_a(x + 1, y, z))) {
            return false;
        }
        if (BlockSets.meltBlocks.contains(world.func_147439_a(x - 1, y, z))) {
            return false;
        }
        if (BlockSets.meltBlocks.contains(world.func_147439_a(x, y, z + 1))) {
            return false;
        }
        if (BlockSets.meltBlocks.contains(world.func_147439_a(x + 1, y, z - 1))) {
            return false;
        }
        return !BlockSets.meltBlocks.contains(world.func_147439_a(x, y + 1, z));
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149701_w() {
        return 1;
    }

    public Item func_149650_a(int metadata, Random random, int fortune) {
        return this.outterBlock.func_149650_a(metadata, random, fortune);
    }

    public void func_149749_a(World p_149749_1_, int p_149749_2_, int p_149749_3_, int p_149749_4_, Block p_149749_5_, int p_149749_6_) {
        this.outterBlock.func_149749_a(p_149749_1_, p_149749_2_, p_149749_3_, p_149749_4_, p_149749_5_, p_149749_6_);
    }

    public float func_149737_a(EntityPlayer p_149737_1_, World p_149737_2_, int p_149737_3_, int p_149737_4_, int p_149737_5_) {
        return ForgeHooks.blockStrength((Block)this.outterBlock, (EntityPlayer)p_149737_1_, (World)p_149737_2_, (int)p_149737_3_, (int)p_149737_4_, (int)p_149737_5_);
    }

    public void func_149657_c(World p_149657_1_, int p_149657_2_, int p_149657_3_, int p_149657_4_, int p_149657_5_) {
        this.outterBlock.func_149657_c(p_149657_1_, p_149657_2_, p_149657_3_, p_149657_4_, p_149657_5_);
    }

    public float func_149638_a(Entity p_149638_1_) {
        return this.outterBlock.func_149638_a(p_149638_1_);
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        if (!EnchantmentHelper.func_77502_d((EntityLivingBase)player)) {
            world.func_147465_d(x, y, z, this.innerBlock, world.func_72805_g(x, y, z), 3);
        } else {
            world.func_147468_f(x, y, z);
        }
        return true;
    }

    public int func_149692_a(int metadata) {
        return this.outterBlock.func_149692_a(metadata);
    }

    public boolean canRenderInPass(int pass) {
        CBClientProxy.renderPass = pass;
        return true;
    }

    public float func_149712_f(World world, int x, int y, int z) {
        return this.outterBlock.func_149712_f(world, x, y, z);
    }

    public String getHarvestTool(int metadata) {
        return this.outterBlock.getHarvestTool(metadata);
    }

    public int getHarvestLevel(int metadata) {
        return this.outterBlock.getHarvestLevel(metadata);
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return Blocks.field_150480_ab.getFlammability(this.outterBlock);
    }

    public boolean isFlammable(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return this.outterBlock.getFlammability(world, x, y, z, face) > 0;
    }

    public int getFireSpreadSpeed(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return this.outterBlock.getFireSpreadSpeed(world, x, y, z, face);
    }

    public boolean canHarvestBlock(EntityPlayer player, int meta) {
        return this.outterBlock.canHarvestBlock(player, meta);
    }
}

