/*
 * Decompiled with CFR 0.152.
 */
package cavebiomes.entities;

import cavebiomes.CaveBiomes;
import cavebiomes.entities.SpawnerBlock;
import cavebiomes.entities.SpawnerBlockEntity;
import cavebiomes.entities.skeleton.SkeletonMage;
import cavebiomes.items.ArmorRegistry;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class Entities {
    static int counter = 1;
    public static Entities entities = new Entities();

    public static void RegisterEntityList() {
        GameRegistry.registerTileEntity(SpawnerBlockEntity.class, (String)"CustomMobSpawner");
        Entities.registerEntity(SkeletonMage.class, "SkeletonMage");
        for (CustomMobTypes type : CustomMobTypes.values()) {
            GameRegistry.registerBlock((Block)type.getSpawner(), (String)(type.toString() + "_spawner"));
        }
    }

    public static void registerEntity(Class entityClass, String name) {
        int entityId = counter++;
        EntityRegistry.registerModEntity((Class)entityClass, (String)name, (int)entityId, (Object)CaveBiomes.instance, (int)64, (int)1, (boolean)true);
    }

    public class CustomWitch
    implements ICustomMob {
        @Override
        public EntityLiving getMob(World world) {
            EntityWitch mob = new EntityWitch(world);
            return mob;
        }
    }

    public class CustomDerangedGolem
    implements ICustomMob {
        @Override
        public EntityLiving getMob(World world) {
            EntityIronGolem mob = new EntityIronGolem(world);
            mob.field_70714_bg.field_75782_a.clear();
            mob.field_70715_bh.field_75782_a.clear();
            mob.func_70661_as().func_75491_a(true);
            mob.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)mob, EntityPlayer.class, 1.0, false));
            mob.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)mob, 1.0));
            mob.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)mob, EntityPlayer.class, 8.0f));
            mob.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)mob));
            mob.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)mob, true));
            mob.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)mob, EntityPlayer.class, 0, true));
            mob.func_70661_as().func_75495_e(false);
            return mob;
        }
    }

    public class CustomSkeletonMage
    implements ICustomMob {
        @Override
        public EntityLiving getMob(World world) {
            SkeletonMage mob = new SkeletonMage(world);
            return mob;
        }
    }

    public class CustomSkeletonKnight
    implements ICustomMob {
        @Override
        public EntityLiving getMob(World world) {
            EntitySkeleton mob = new EntitySkeleton(world);
            mob.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)mob, 1.0));
            mob.func_70062_b(3, new ItemStack((Item)Items.field_151023_V));
            mob.func_70062_b(0, new ItemStack(Items.field_151040_l));
            return mob;
        }
    }

    public class CustomPharoh
    implements ICustomMob {
        @Override
        public EntityLiving getMob(World world) {
            EntityZombie mob = new EntityZombie(world);
            mob.func_70062_b(4, new ItemStack(ArmorRegistry.pharaohHelmet));
            mob.func_70062_b(3, new ItemStack(ArmorRegistry.pharaohChestplate));
            mob.func_70062_b(2, new ItemStack(ArmorRegistry.pharaohLeggings));
            mob.func_70062_b(1, new ItemStack(ArmorRegistry.pharaohBoots));
            mob.func_96120_a(4, 0.0f);
            mob.func_96120_a(3, 0.0f);
            mob.func_96120_a(2, 0.0f);
            mob.func_96120_a(1, 0.0f);
            return mob;
        }
    }

    public class CustomMummy
    implements ICustomMob {
        @Override
        public EntityLiving getMob(World world) {
            EntityZombie mob = new EntityZombie(world);
            mob.func_70062_b(4, new ItemStack(ArmorRegistry.mummyHelmet));
            mob.func_70062_b(3, new ItemStack(ArmorRegistry.mummyChestplate));
            mob.func_70062_b(2, new ItemStack(ArmorRegistry.mummyLeggings));
            mob.func_70062_b(1, new ItemStack(ArmorRegistry.mummyBoots));
            mob.func_96120_a(4, 0.0f);
            mob.func_96120_a(3, 0.0f);
            mob.func_96120_a(2, 0.0f);
            mob.func_96120_a(1, 0.0f);
            return mob;
        }
    }

    public static enum CustomMobTypes {
        Mummy(entities.new CustomMummy()),
        Pharoh(entities.new CustomPharoh()),
        SkeletonKnight(entities.new CustomSkeletonKnight()),
        SkeletonMage(entities.new CustomSkeletonMage()),
        DerangedGolem(entities.new CustomDerangedGolem()),
        Witch(entities.new CustomWitch());

        private final ICustomMob custommob;

        private CustomMobTypes(ICustomMob customMob) {
            this.custommob = customMob;
        }

        public EntityLiving getMob(World world) {
            return this.custommob.getMob(world);
        }

        public Block getSpawner() {
            return new SpawnerBlock(this).func_149663_c(this.toString() + "_spawner");
        }
    }

    public static interface ICustomMob {
        public EntityLiving getMob(World var1);
    }
}

