/*
 * Decompiled with CFR 0.152.
 */
package cavebiomes.worldgeneration;

import cavebiomes.WTFCaveBiomesConfig;
import cavebiomes.api.CaveType;
import cavebiomes.utilities.gencores.GenCoreProvider;
import cavebiomes.utilities.gencores.VanillaGen;
import cavebiomes.worldgeneration.CaveGen;
import cavebiomes.worldgeneration.CaveTypeRegister;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.block.Block;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import wtfcore.api.BlockSets;
import wtfcore.utilities.CavePosition;
import wtfcore.utilities.SurfacePos;
import wtfcore.worldgen.OverworldScanner;
import wtfcore.worldgen.WorldGenListener;

public class CaveBiomesChunkScanner
extends OverworldScanner {
    public VanillaGen gen = GenCoreProvider.getGenCore();

    public void generate(World world, Random rand, int chunkX, int chunkZ) {
        rand = ThreadLocalRandom.current();
        ArrayList<CavePosition> cavepositions = new ArrayList<CavePosition>();
        ArrayList<CavePosition> dungeonposition = new ArrayList<CavePosition>();
        ArrayList<SurfacePos> surfacepositions = new ArrayList<SurfacePos>();
        Chunk chunk = world.func_72938_d(chunkX, chunkZ);
        int lastY = 70;
        int surfaceaverage = 0;
        for (int xloop = 0; xloop < 16; ++xloop) {
            int x = chunkX + xloop;
            for (int zloop = 0; zloop < 16; ++zloop) {
                int z = chunkZ + zloop;
                int y = this.scanForSurface(chunk, x, lastY, z);
                surfacepositions.add(new SurfacePos(x, y, z));
                lastY = y;
                surfaceaverage += y;
                int ceiling = -1;
                boolean wasAir = false;
                while (y > 10) {
                    if (this.isAirAndCheck(chunk, x, y, z)) {
                        if (!wasAir && ceiling == -1) {
                            ceiling = y + 1;
                        }
                        wasAir = true;
                    } else {
                        if (ceiling != -1) {
                            cavepositions.add(new CavePosition(x, ceiling, y, z));
                            dungeonposition.add(new CavePosition(x, ceiling, y, z));
                            ceiling = -1;
                            --y;
                        }
                        wasAir = false;
                    }
                    --y;
                }
            }
        }
        surfaceaverage /= 256;
        if (WorldGenListener.generator != null) {
            WorldGenListener.generator.generate(world, surfaceaverage, chunkX, chunkZ, rand, cavepositions);
        }
        int deepmax = surfaceaverage / 3;
        int midmax = surfaceaverage * 2 / 3;
        CaveType shallowtype = CaveTypeRegister.GetShallowCaveType(world, chunkX, chunkZ);
        CaveType midtype = CaveTypeRegister.GetMidCaveType(world, chunkX, chunkZ);
        CaveType deeptype = CaveTypeRegister.GetDeepCaveType(world, chunkX, chunkZ);
        if (WTFCaveBiomesConfig.generateCaveSubtypes) {
            for (CavePosition position : dungeonposition) {
                if (position.floor >= surfaceaverage - 5) continue;
                if (position.floor < deepmax) {
                    if (rand.nextInt(deeptype.DungeonWeight) != 1) continue;
                    CaveGen.generateDungeon(deeptype, world, rand, position.x, position.z, position.ceiling, position.floor);
                    continue;
                }
                if (position.floor < midmax) {
                    if (rand.nextInt(midtype.DungeonWeight) != 1) continue;
                    CaveGen.generateDungeon(midtype, world, rand, position.x, position.z, position.ceiling, position.floor);
                    continue;
                }
                if (rand.nextInt(shallowtype.DungeonWeight) != 1) continue;
                CaveGen.generateDungeon(shallowtype, world, rand, position.x, position.z, position.ceiling, position.floor);
            }
        }
        for (CavePosition position : cavepositions) {
            if (position.floor < deepmax) {
                CaveGen.generateCaveType(deeptype, world, rand, position.x, position.floor, position.ceiling, position.z);
                continue;
            }
            if (position.floor < midmax) {
                CaveGen.generateCaveType(midtype, world, rand, position.x, position.floor, position.ceiling, position.z);
                continue;
            }
            CaveGen.generateCaveType(shallowtype, world, rand, position.x, position.floor, position.ceiling, position.z);
        }
        if (WorldGenListener.treehandler != null) {
            WorldGenListener.treehandler.generateTrees(world, surfacepositions, chunkX, chunkZ);
        }
    }

    public boolean isAirAndCheck(Chunk chunk, int x, int y, int z) {
        Block block = chunk.func_150810_a(x & 0xF, y, z & 0xF);
        if (BlockSets.genReplace.containsKey(block)) {
            this.gen.replaceBlockDuringGen(chunk, block, x, y, z);
            return false;
        }
        return block.isAir((IBlockAccess)chunk.field_76637_e, x, y, z);
    }

    public boolean isSurfaceAndCheck(Chunk chunk, int x, int y, int z) {
        Block block = chunk.func_150810_a(x & 0xF, y, z & 0xF);
        if (BlockSets.genReplace.containsKey(block)) {
            this.gen.replaceBlockDuringGen(chunk, block, x, y, z);
        }
        return BlockSets.surfaceBlocks.contains(block);
    }
}

