/*
 * Decompiled with CFR 0.152.
 */
package cavebiomes.worldgeneration;

import cavebiomes.EventListener;
import cavebiomes.WTFCaveBiomesConfig;
import cavebiomes.api.CaveType;
import cavebiomes.api.DungeonType;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import wtfcore.WTFCore;
import wtfcore.utilities.DungeonBlockPosition;

public class CaveGen {
    public static void generateCaveType(CaveType cavetype, World world, Random random, int x, int floor, int ceiling, int z) {
        cavetype.generateFloor(world, random, x, floor, z);
        cavetype.generateCeiling(world, random, x, ceiling, z);
        if (random.nextInt(100) < cavetype.ceilingaddonchance) {
            cavetype.generateCeilingAddons(world, random, x, ceiling - 1, z);
        }
    }

    public static void generateDungeon(CaveType cavetype, World world, Random random, int x, int z, int ceiling, int floor) {
        int k;
        int i;
        DungeonType dungeon = cavetype.dungeons.getRandomDungeon(random);
        int y = floor + (ceiling - floor) / 2;
        int xpos = x + 1;
        boolean stop = false;
        for (int loop = 0; !stop && world.func_147437_c(xpos, y, z) && loop < dungeon.dungeonMaxSize; ++loop) {
            ++xpos;
        }
        int xneg = x - 1;
        for (int loop = 0; !stop && world.func_147437_c(xneg, y, z) && loop < dungeon.dungeonMaxSize; ++loop) {
            --xneg;
        }
        int xrange = xpos - xneg;
        if (xrange < dungeon.xClearance) {
            return;
        }
        x = xneg + xrange / 2;
        int zpos = z + 1;
        for (int loop = 0; !stop && world.func_147437_c(x, y, zpos) && loop < dungeon.dungeonMaxSize; ++loop) {
            ++zpos;
        }
        int zneg = z - 1;
        for (int loop = 0; !stop && world.func_147437_c(x, y, zneg) && loop < dungeon.dungeonMaxSize; ++loop) {
            --zneg;
        }
        int zrange = zpos - zneg;
        if (zrange < dungeon.zClearance) {
            return;
        }
        z = zneg + zrange / 2;
        if (stop) {
            return;
        }
        int ypos = y + 1;
        for (int loop = 0; world.func_147437_c(x, ypos, z) && loop < dungeon.dungeonMaxSize; ++loop) {
            ++ypos;
        }
        int yneg = y - 1;
        while (world.func_147437_c(x, yneg, z) && y > 0) {
            --yneg;
        }
        int yrange = ypos - yneg;
        if (yrange < dungeon.yClearance || yrange > 2 * dungeon.yClearance) {
            return;
        }
        y = yneg + yrange / 2;
        floor = yneg;
        ceiling = ypos;
        dungeon.wallStripe = y + 1;
        if (!dungeon.canSpawnHere(world, x, y, z, ceiling, floor)) {
            return;
        }
        if (WTFCaveBiomesConfig.logDungeons) {
            if (EventListener.thePlayer != null) {
                EventListener.thePlayer.func_145747_a((IChatComponent)new ChatComponentText("Generating " + dungeon.name + " @ " + x + " " + y + " " + z));
            }
            WTFCore.log.info("Generating Dungeon " + dungeon.name + " @ " + x + " " + floor + " " + z);
        }
        HashSet<DungeonBlockPosition> hashset = new HashSet<DungeonBlockPosition>();
        HashSet<DungeonBlockPosition> air = new HashSet<DungeonBlockPosition>();
        int xmin = (0 - xrange) / 2;
        int xmax = xrange / 2;
        int ymin = (0 - yrange) / 2;
        int ymax = yrange / 2;
        int zmin = (0 - zrange) / 2;
        int zmax = zrange / 2;
        double oriX = (double)x + 0.5;
        double oriY = floor + (ceiling - floor) / 2;
        double oriZ = (double)z + 0.5;
        for (int xloop = xmin; xloop < xmax + 1; ++xloop) {
            for (int yloop = ymin; yloop < ymax + 1; ++yloop) {
                for (int zloop = zmin; zloop < zmax + 1; ++zloop) {
                    if (xloop != xmin && xloop != xmax && yloop != ymin && yloop != ymax && zloop != zmin && zloop != zmax) continue;
                    double incX = 0 + xloop;
                    double incY = 0 + yloop;
                    double incZ = 0 + zloop;
                    double vectorLength = Math.sqrt(incX * incX + incY * incY + incZ * incZ);
                    incX /= vectorLength;
                    incY /= vectorLength;
                    incZ /= vectorLength;
                    int i2 = MathHelper.func_76128_c((double)oriX);
                    int j = MathHelper.func_76128_c((double)oriY);
                    int k2 = MathHelper.func_76128_c((double)oriZ);
                    int loop = 1;
                    while (world.func_147437_c(i2, j, k2) && (double)loop < vectorLength + 1.0) {
                        air.add(new DungeonBlockPosition(i2, j, k2, false));
                        i2 = MathHelper.func_76128_c((double)(oriX + incX * (double)loop));
                        j = MathHelper.func_76128_c((double)(oriY + incY * (double)loop));
                        k2 = MathHelper.func_76128_c((double)(oriZ + incZ * (double)loop));
                        ++loop;
                    }
                    if (world.func_147437_c(i2, j, k2)) continue;
                    hashset.add(new DungeonBlockPosition(i2, j, k2, false));
                }
            }
        }
        for (DungeonBlockPosition chunkposition : hashset) {
            i = chunkposition.field_151329_a;
            int j = chunkposition.field_151327_b;
            k = chunkposition.field_151328_c;
            if ((double)j < oriY && !world.func_147439_a(i, j + 1, k).func_149686_d()) {
                dungeon.generateFloor(world, random, i, j, k);
                continue;
            }
            if ((double)j > oriY && !world.func_147439_a(i, j - 1, k).func_149686_d()) {
                dungeon.generateCeiling(world, random, i, j, k);
                continue;
            }
            if (j == dungeon.wallStripe && dungeon.generateWallStripe(world, random, i, j, k)) continue;
            dungeon.generateWalls(world, random, i, j, k);
        }
        dungeon.generateCenter(world, random, x, y, z, ceiling, floor);
        for (DungeonBlockPosition chunkposition : air) {
            i = chunkposition.field_151329_a;
            int j = chunkposition.field_151327_b;
            k = chunkposition.field_151328_c;
            dungeon.generateFill(world, random, i, j, k);
        }
    }
}

