/*
 * Decompiled with CFR 0.152.
 */
package cavebiomes.worldgeneration.cavetypes.shallow;

import cavebiomes.api.CaveType;
import cavebiomes.api.DungeonSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import wtfcore.api.BlockSets;

public class CaveTypeJungleVolcano
extends CaveType {
    BlockSets.Modifier[] stonemodifier = new BlockSets.Modifier[]{BlockSets.Modifier.stoneMagmaCrust, BlockSets.Modifier.cobblestone};

    public CaveTypeJungleVolcano(int cavedepth, DungeonSet jungleSet) {
        super("Jungle", cavedepth, jungleSet);
    }

    @Override
    public void generateCeilingAddons(World world, Random random, int x, int y, int z) {
        gen.genStalactite(world, x, y, z, this.depth);
    }

    @Override
    public void generateFloor(World world, Random random, int x, int y, int z) {
        int height = MathHelper.func_76130_a((int)(MathHelper.func_76130_a((int)(x / 2)) % 10 / 2 - 5)) + MathHelper.func_76130_a((int)(MathHelper.func_76130_a((int)z) % 10 - 5)) + random.nextInt(3) - 6;
        if (height > 2) {
            if (random.nextBoolean()) {
                gen.replaceBlock(world, x, y, z, (Block)Blocks.field_150349_c, 0);
            } else {
                gen.replaceBlock(world, x, y, z, (Block)Blocks.field_150349_c, 0);
                gen.setBlockWithoutNotify(world, x, y + 1, z, (Block)Blocks.field_150329_H, 2);
            }
        } else if (height < -1) {
            if (gen.IsBlockSurrounded(world, x, y, z)) {
                gen.setFluid(world, x, y, z, Blocks.field_150353_l);
            }
        } else if (random.nextBoolean()) {
            gen.transformBlock(world, x, y, z, this.stonemodifier[random.nextInt(this.stonemodifier.length)]);
        } else if (this.shouldGenFloorAddon(random)) {
            gen.genStalagmite(world, x, y, z, this.depth);
        }
    }

    @Override
    public void generateCeiling(World world, Random random, int x, int y, int z) {
        if (random.nextBoolean()) {
            gen.GenVines(world, x, y - 1, z);
        }
    }
}

