/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.api.abstraction.tile;

import com.builtbroken.mc.api.abstraction.entity.IEntityData;
import com.builtbroken.mc.api.abstraction.tile.ITile;
import com.builtbroken.mc.api.abstraction.world.IWorld;
import com.builtbroken.mc.data.Direction;
import java.util.ArrayList;
import java.util.List;

public interface ITilePosition {
    public IWorld getWorld();

    public int xCoord();

    public int yCoord();

    public int zCoord();

    default public boolean isLoaded() {
        return this.getWorld().isLocationLoaded(this.xCoord(), this.yCoord(), this.zCoord());
    }

    default public ITile getTileData() {
        return this.getWorld().getTile(this.xCoord(), this.yCoord(), this.zCoord());
    }

    default public List<IEntityData> getEntitiesInRange(double range) {
        return this.getWorld().getEntitiesInRange((double)this.xCoord() + 0.5, (double)this.yCoord() + 0.5, (double)this.zCoord() + 0.5, range);
    }

    default public ITilePosition getPosition(int x, int y, int z) {
        return this.getWorld().getTilePosition(x, y, z);
    }

    default public ITilePosition getPosition(Direction direction) {
        return this.getPosition(this.xCoord() + direction.offsetX, this.yCoord() + direction.offsetY, this.zCoord() + direction.offsetZ);
    }

    default public List<ITilePosition> getAdjacentPositions() {
        ArrayList<ITilePosition> tiles = new ArrayList<ITilePosition>();
        for (Direction direction : Direction.DIRECTIONS) {
            ITilePosition position = this.getPosition(direction);
            if (position == null || !position.isLoaded()) continue;
            tiles.add(position);
        }
        return tiles;
    }

    default public ITilePosition[] getAdjacentPositions_Array() {
        ITilePosition[] tiles = new ITilePosition[6];
        for (Direction direction : Direction.DIRECTIONS) {
            ITilePosition position = this.getPosition(direction);
            if (position == null || !position.isLoaded()) continue;
            tiles[direction.ordinal()] = position;
        }
        return tiles;
    }
}

