/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.client.json.texture;

import com.builtbroken.mc.client.json.ClientDataHandler;
import com.builtbroken.mc.debug.IJsonDebugDisplay;
import com.builtbroken.mc.framework.json.imp.IJsonProcessor;
import com.builtbroken.mc.framework.json.processors.JsonGenData;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;

public class TextureData
extends JsonGenData
implements IJsonDebugDisplay {
    public final String domain;
    public final String key;
    public final String name;
    public final Type type;
    private ResourceLocation cachedLocation;
    @Deprecated
    private IIcon icon;

    public TextureData(IJsonProcessor processor, String key, String domain, String name, Type type) {
        super(processor);
        this.key = key;
        this.domain = domain;
        this.name = name;
        this.type = type;
    }

    public ResourceLocation getLocation() {
        if (this.cachedLocation == null) {
            this.cachedLocation = new ResourceLocation(this.domain, "textures/" + this.type.path + "/" + this.name + ".png");
        }
        return this.cachedLocation;
    }

    public IIcon getIcon() {
        return this.icon;
    }

    public void register(IIconRegister register) {
        this.icon = register.func_94245_a(this.domain + ":" + this.name);
    }

    @Override
    public void onCreated() {
        ClientDataHandler.INSTANCE.addTexture(this.key, this);
    }

    @Override
    public String getContentID() {
        return this.key;
    }

    @Override
    public String getUniqueID() {
        return this.key;
    }

    @Override
    public String getDisplayName() {
        return this.getContentID();
    }

    @Override
    public void addDebugLines(List<String> lines) {
        lines.add("Location = " + this.getLocation());
        if (this.type == Type.BLOCK || this.type == Type.ITEM) {
            lines.add("Icon = " + this.getIcon());
        }
        lines.add("Type = " + this.type.name().toLowerCase());
        lines.add("Domain = " + this.domain);
        lines.add("Path = " + this.name);
    }

    public static enum Type {
        BLOCK("blocks"),
        ITEM("items"),
        MODEL("models"),
        EFFECT("fx"),
        OVERLAY("overlay"),
        GUI("gui");

        public final String path;

        private Type(String path) {
            this.path = path;
        }

        public static Type get(String name) {
            for (Type type : Type.values()) {
                if (!type.path.equalsIgnoreCase(name) && !type.name().equalsIgnoreCase(name)) continue;
                return type;
            }
            return null;
        }
    }
}

