/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.codegen;

import com.builtbroken.mc.codegen.data.BuildData;
import com.builtbroken.mc.codegen.processor.Processor;
import com.builtbroken.mc.codegen.template.Parser;
import com.builtbroken.mc.codegen.utils.Utils;
import java.awt.GraphicsEnvironment;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Main {
    public static Pattern packagePattern = Pattern.compile("package(.*?);");

    public static void main(String ... args) {
        Main.out("VoltzEngine Code Generator v0.1.0");
        Main.out("Parsing arguments...");
        HashMap<String, String> launchSettings = Main.loadArgs(args);
        if (!launchSettings.containsKey("settings")) {
            if (launchSettings.containsKey("src") && launchSettings.containsKey("templates") && launchSettings.containsKey("output") && launchSettings.containsKey("processors")) {
                File outputFolder;
                String[] folders;
                File runFolder = new File(".");
                ArrayList<File> templateFolders = new ArrayList<File>();
                String path = launchSettings.get("src");
                File targetFolder = path.startsWith(".") ? new File(runFolder, path.substring(1, path.length())) : new File(path);
                for (String folder : folders = launchSettings.get("templates").split(",")) {
                    File file = folder.startsWith(".") ? new File(runFolder, folder.substring(1, folder.length())) : new File(folder);
                    if (!file.exists() || !file.isDirectory()) {
                        Main.error("The template folder '" + file + "' does not exist.");
                        continue;
                    }
                    templateFolders.add(file);
                }
                if (templateFolders.isEmpty()) {
                    Main.error("No template folders were loaded, can not continue as processors will have noting to generate.");
                }
                if ((outputFolder = (path = launchSettings.get("output")).startsWith(".") ? new File(runFolder, path.substring(1, path.length())) : new File(path)).exists() && !outputFolder.isDirectory()) {
                    Main.out("output folder is not a directory: " + outputFolder);
                    System.exit(1);
                }
                if (!outputFolder.exists()) {
                    outputFolder.mkdirs();
                } else {
                    Utils.cleanFolder(outputFolder);
                }
                if (targetFolder.exists() && targetFolder.isDirectory()) {
                    Main.out("");
                    ArrayList<Processor> processors = new ArrayList<Processor>();
                    String[] processorEntries = launchSettings.get("processors").split(",");
                    for (String processorEntry : processorEntries) {
                        try {
                            Class<?> clazz = Class.forName(processorEntry);
                            Processor processor = (Processor)clazz.newInstance();
                            processor.initialized(runFolder, launchSettings);
                            processors.add(processor);
                        }
                        catch (ClassNotFoundException e) {
                            Main.error("Failed to locate processor class " + processorEntry, e);
                        }
                        catch (InstantiationException e) {
                            Main.error("Failed to create processor object " + processorEntry, e);
                        }
                        catch (IllegalAccessException e) {
                            Main.error("Failed to access processor class " + processorEntry, e);
                        }
                    }
                    if (processors.isEmpty()) {
                        Main.error("No templates were loaded, can not continue with templates to use");
                    }
                    for (Processor processor : processors) {
                        Main.out("Initializing processor: " + processor);
                        for (File file : templateFolders) {
                            Main.out("Loading templates from " + file);
                            processor.loadTemplates(file, 0);
                        }
                    }
                    Main.out("");
                    Main.out("Loading classes from " + targetFolder);
                    Main.handleDirectory(targetFolder, processors, outputFolder, 0);
                    Main.out("");
                    Main.out("Finalizing data");
                    for (Processor processor : processors) {
                        processor.finalize(outputFolder);
                    }
                } else {
                    Main.error("The target folder does not exist. Folder: " + targetFolder);
                }
            } else if (GraphicsEnvironment.isHeadless()) {
                Main.error("In order for the program to function you need to specify in the program arguments: -src=\"path/to/source/files\" -templates=\"path/to/source/templates\" -output=\"path/to/source/output\"");
            }
        }
        Main.out("Exiting...");
    }

    public static void out(String msg) {
        System.out.println(msg);
    }

    public static void error(String msg, Throwable t) {
        System.err.println(msg);
        t.printStackTrace();
        System.exit(1);
    }

    public static void error(String msg) {
        System.err.println(msg);
        System.exit(1);
    }

    public static void warn(String msg) {
        System.err.println(msg);
    }

    public static void handleDirectory(File directory, List<Processor> processors, File outputFolder, int depth) {
        File[] files;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i <= depth; ++i) {
            builder.append("  ");
        }
        String spacer = builder.toString();
        Main.out(spacer + "*Directory: " + directory.getName());
        for (File file : files = directory.listFiles()) {
            if (file.isDirectory()) {
                Main.handleDirectory(file, processors, outputFolder, ++depth);
                continue;
            }
            Main.out("");
            Main.out(spacer + "--File: " + file.getName());
            Main.out(spacer + " |------------------------->");
            try {
                Main.handleFile(file, processors, outputFolder, spacer + " |");
            }
            catch (IOException e) {
                Main.error("Unexpected exception while parsing " + file, e);
                System.exit(1);
            }
            Main.out(spacer + " |------------------------->");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleFile(File file, List<Processor> allProcessors, File outputFolder, String spacer) throws IOException {
        if (file.getAbsolutePath().endsWith(".java")) {
            String fileClassName = file.getName();
            fileClassName = fileClassName.substring(0, fileClassName.length() - 5);
            String classPackage = null;
            ArrayList<String> annotations = new ArrayList<String>();
            try (BufferedReader br = new BufferedReader(new FileReader(file));){
                String line;
                while ((line = br.readLine()) != null) {
                    if (line.contains("import")) continue;
                    if (line.contains("package")) {
                        Matcher matcher = packagePattern.matcher(line);
                        if (!matcher.matches()) continue;
                        classPackage = matcher.group(1).trim();
                        continue;
                    }
                    if (line.contains("@")) {
                        annotations.addAll(Parser.getAnnotations(line));
                        continue;
                    }
                    if (!line.contains("{")) continue;
                    break;
                }
            }
            HashMap<String, String> annotationToData = new HashMap<String, String>();
            Main.out(spacer + "  Package: " + classPackage);
            Main.out(spacer + "  Annotations:");
            for (String string : annotations) {
                Main.out(spacer + "      " + string);
                int firstParn = string.indexOf("(");
                String annotation = string.substring(0, firstParn);
                String data = string.substring(firstParn + 1, string.length() - 1);
                annotationToData.put(annotation, data);
            }
            for (Processor processor : allProcessors) {
                if (!annotationToData.containsKey(processor.annotationKey)) continue;
                processor.handleFile(outputFolder, new BuildData(annotationToData, classPackage, fileClassName), spacer);
            }
        }
    }

    public static HashMap<String, String> loadArgs(String ... args) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (args != null) {
            String currentArg = null;
            String currentValue = "";
            for (int i = 0; i < args.length; ++i) {
                String next = args[i].trim();
                if (next == null) {
                    throw new IllegalArgumentException("Null argument detected in launch arguments");
                }
                if (next.startsWith("-")) {
                    if (currentArg != null) {
                        map.put(currentArg, currentValue);
                        currentValue = "";
                    }
                    if (next.contains("=")) {
                        String[] split = next.split("=");
                        currentArg = split[0].substring(1).trim();
                        currentValue = split[1].trim();
                        continue;
                    }
                    currentArg = next.substring(1).trim();
                    continue;
                }
                if (currentArg != null) {
                    if (!currentValue.isEmpty()) {
                        currentValue = currentValue + ",";
                    }
                    currentValue = currentValue + next.replace("\"", "").replace("'", "").trim();
                    continue;
                }
                throw new IllegalArgumentException("Value has no argument associated with it [" + next + "]");
            }
            if (currentArg != null) {
                map.put(currentArg, currentValue);
            }
        }
        return map;
    }
}

