/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.core.commands.json.visuals;

import com.builtbroken.mc.client.json.ClientDataHandler;
import com.builtbroken.mc.client.json.imp.IRenderState;
import com.builtbroken.mc.client.json.render.RenderData;
import com.builtbroken.mc.client.json.render.state.ModelState;
import com.builtbroken.mc.core.commands.prefab.SubCommand;
import com.builtbroken.mc.imp.transform.rotation.EulerAngle;
import com.builtbroken.mc.imp.transform.vector.Pos;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class CommandJsonRender
extends SubCommand {
    public RenderData loadedData;
    public ModelState loadedState;

    public CommandJsonRender() {
        super("render");
    }

    @Override
    public boolean handleEntityPlayerCommand(EntityPlayer player, String[] args) {
        if (args != null && args.length > 0 && !"help".equalsIgnoreCase(args[0])) {
            if (args[0].equalsIgnoreCase("loadData")) {
                if (args.length > 1) {
                    String id = args[1];
                    this.loadedState = null;
                    this.loadedData = ClientDataHandler.INSTANCE.getRenderData(id);
                    if (this.loadedData != null) {
                        player.func_145747_a((IChatComponent)new ChatComponentText("Loaded render data for id '" + id + "', data contains " + this.loadedData.renderStatesByName.size() + " render states."));
                    } else {
                        player.func_145747_a((IChatComponent)new ChatComponentText("Did not find render data with id '" + id + "'"));
                    }
                } else {
                    player.func_145747_a((IChatComponent)new ChatComponentText("Need to provide render data ID"));
                }
            } else if (this.loadedData != null) {
                if (args[0].equalsIgnoreCase("loadState")) {
                    if (args.length > 1) {
                        String id = args[1];
                        IRenderState state = this.loadedData.getState(id);
                        if (state instanceof ModelState) {
                            this.loadedState = (ModelState)state;
                            player.func_145747_a((IChatComponent)new ChatComponentText("Loaded render state for id '" + id + "'"));
                        } else if (state != null) {
                            player.func_145747_a((IChatComponent)new ChatComponentText("Only model state data is supported for command modification."));
                        } else {
                            player.func_145747_a((IChatComponent)new ChatComponentText("Did not find render state for id '" + id + "'"));
                        }
                    } else {
                        player.func_145747_a((IChatComponent)new ChatComponentText("Need to provide render state ID"));
                    }
                } else if (this.loadedState != null) {
                    if (args[0].equalsIgnoreCase("setRotation")) {
                        if (args.length > 3) {
                            try {
                                player.func_145747_a((IChatComponent)new ChatComponentText("Previous Rotation: " + this.loadedState.getRotation()));
                                this.loadedState.rotation = new EulerAngle(Double.parseDouble(args[1]), Double.parseDouble(args[2]), Double.parseDouble(args[3]));
                                player.func_145747_a((IChatComponent)new ChatComponentText("Rotation: " + this.loadedState.getRotation()));
                            }
                            catch (NumberFormatException e) {
                                player.func_145747_a((IChatComponent)new ChatComponentText("Error: could not parse numbers"));
                            }
                        }
                    } else if (args[0].equalsIgnoreCase("setOffset")) {
                        if (args.length > 3) {
                            try {
                                player.func_145747_a((IChatComponent)new ChatComponentText("Previous Offset: " + (Object)((Object)this.loadedState.getOffset())));
                                this.loadedState.offset = new Pos(Double.parseDouble(args[1]), Double.parseDouble(args[2]), Double.parseDouble(args[3]));
                                player.func_145747_a((IChatComponent)new ChatComponentText("Offset: " + (Object)((Object)this.loadedState.getOffset())));
                            }
                            catch (NumberFormatException e) {
                                player.func_145747_a((IChatComponent)new ChatComponentText("Error: could not parse numbers"));
                            }
                        }
                    } else if (args[0].equalsIgnoreCase("setScale")) {
                        if (args.length > 3) {
                            try {
                                player.func_145747_a((IChatComponent)new ChatComponentText("Previous Offset: " + (Object)((Object)this.loadedState.getOffset())));
                                this.loadedState.offset = new Pos(Double.parseDouble(args[1]), Double.parseDouble(args[2]), Double.parseDouble(args[3]));
                                player.func_145747_a((IChatComponent)new ChatComponentText("Offset: " + (Object)((Object)this.loadedState.getOffset())));
                            }
                            catch (NumberFormatException e) {
                                player.func_145747_a((IChatComponent)new ChatComponentText("Error: could not parse numbers"));
                            }
                        } else if (args.length > 1) {
                            try {
                                player.func_145747_a((IChatComponent)new ChatComponentText("Previous Scale: " + (Object)((Object)this.loadedState.getScale())));
                                this.loadedState.scale = new Pos(Double.parseDouble(args[1]));
                                player.func_145747_a((IChatComponent)new ChatComponentText("Scale: " + (Object)((Object)this.loadedState.getScale())));
                            }
                            catch (NumberFormatException e) {
                                player.func_145747_a((IChatComponent)new ChatComponentText("Error: could not parse numbers"));
                            }
                        }
                    } else if (args[0].equalsIgnoreCase("output")) {
                        player.func_145747_a((IChatComponent)new ChatComponentText("Offset: " + (Object)((Object)this.loadedState.getOffset())));
                        player.func_145747_a((IChatComponent)new ChatComponentText("Rotation: " + this.loadedState.getRotation()));
                        player.func_145747_a((IChatComponent)new ChatComponentText("Scale: " + (Object)((Object)this.loadedState.getScale())));
                    }
                } else {
                    player.func_145747_a((IChatComponent)new ChatComponentText("Render data must be loaded to use any other command. Use '/ve debug render loadState <render state id>' to load render data"));
                }
            } else {
                player.func_145747_a((IChatComponent)new ChatComponentText("Render data must be loaded to use any other command. Use '/ve debug render loadData <render data id>' to load render data"));
            }
        }
        return true;
    }

    @Override
    public boolean handleConsoleCommand(ICommandSender sender, String[] args) {
        return false;
    }
}

