/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.core.content.blast.emp;

import com.builtbroken.jlib.debug.DebugPrinter;
import com.builtbroken.jlib.lang.StringHelpers;
import com.builtbroken.mc.api.edit.IWorldEdit;
import com.builtbroken.mc.api.energy.IEMReceptiveDevice;
import com.builtbroken.mc.api.energy.IVoltageTransmitter;
import com.builtbroken.mc.api.explosive.IExplosiveHandler;
import com.builtbroken.mc.api.items.energy.IEMInterferenceItem;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.core.content.blast.emp.EmpDrainEdit;
import com.builtbroken.mc.core.content.blast.emp.EmpEdit;
import com.builtbroken.mc.framework.energy.UniversalEnergySystem;
import com.builtbroken.mc.framework.explosive.blast.Blast;
import com.builtbroken.mc.imp.transform.region.Sphere;
import com.builtbroken.mc.imp.transform.sorting.Vector3DistanceComparator;
import com.builtbroken.mc.imp.transform.vector.BlockPos;
import com.builtbroken.mc.imp.transform.vector.Location;
import com.builtbroken.mc.imp.transform.vector.Pos;
import com.builtbroken.mc.lib.world.map.radar.RadarMap;
import com.builtbroken.mc.lib.world.map.radar.data.RadarObject;
import com.builtbroken.mc.lib.world.map.radar.data.RadarTile;
import com.builtbroken.mc.lib.world.map.tile.TileMapRegistry;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class BlastEMP
extends Blast<BlastEMP>
implements IVoltageTransmitter {
    public static final String START_AUDIO = "icbm:icbm.taser";
    public static final String EDIT_AUDIO = "icbm:icbm.spark";
    public static final String END_AUDIO = "icbm:icbm.emp";
    protected DebugPrinter debugPrinter = new DebugPrinter(Engine.logger());

    public BlastEMP(IExplosiveHandler handler) {
        super(handler);
    }

    @Override
    public void getEffectedBlocks(List<IWorldEdit> edits) {
        this.debugPrinter.start("BlastEmp#getEffectedBlocks()", "Starting emp", Engine.runningAsDev);
        long time = System.nanoTime();
        RadarMap map = TileMapRegistry.getRadarMapForWorld(this.oldWorld);
        if (map != null) {
            LinkedList<BlockPos> tileLocations = new LinkedList<BlockPos>();
            List<RadarObject> objects = map.getRadarObjects(this.x(), this.z(), this.size);
            for (RadarObject object : objects) {
                IInventory inventory;
                TileEntity tile;
                if (!(object instanceof RadarTile) || (tile = ((RadarTile)object).tile).func_145837_r()) continue;
                if (tile instanceof IEMReceptiveDevice || UniversalEnergySystem.isHandler(tile, null)) {
                    tileLocations.add(new BlockPos(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e));
                    continue;
                }
                if (!(tile instanceof IInventory) || !this.inventoryContainsElectricItems(inventory = (IInventory)tile)) continue;
                tileLocations.add(new BlockPos(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e));
            }
            Collections.sort(tileLocations, new Vector3DistanceComparator(this, false));
            while (!tileLocations.isEmpty()) {
                double distance;
                BlockPos pos = (BlockPos)tileLocations.poll();
                TileEntity tile = pos.getTileEntity(this.oldWorld);
                if (tile == null || tile.func_145837_r() || !((distance = pos.distance(this)) < this.getEMPRange())) continue;
                this.startEmpPath(tile, distance, this.getPowerForRange(distance), tileLocations, edits);
            }
        }
        time = System.nanoTime() - time;
        this.debugPrinter.end("Done... " + StringHelpers.formatNanoTime((long)time));
    }

    @Override
    public void doEffectOther(boolean beforeBlocksPlaced) {
        Pos center;
        Sphere sphere;
        List<Entity> entities;
        super.doEffectOther(beforeBlocksPlaced);
        if (!beforeBlocksPlaced && (entities = (sphere = new Sphere(center = this.toPos(), this.size)).getEntities((World)this.world.unwrap(), Entity.class)) != null && !entities.isEmpty()) {
            for (Entity entity : entities) {
                if (entity instanceof IInventory) {
                    BlastEMP.applyEmpEffect((IInventory)entity, entity, this, this.getPowerForRange(this.size), center.distance(entity));
                    continue;
                }
                if (entity instanceof EntityPlayer) {
                    BlastEMP.applyEmpEffect((IInventory)((EntityPlayer)entity).field_71071_by, entity, this, this.getPowerForRange(this.size), center.distance(entity));
                    ((EntityPlayer)entity).field_71069_bz.func_75142_b();
                    continue;
                }
                if (!(entity instanceof EntityItem)) continue;
                BlastEMP.applyEmpEffect(entity, ((EntityItem)entity).func_92059_d(), 0, false, this, this.getPowerForRange(this.size), center.distance(entity));
            }
        }
    }

    protected double startEmpPath(TileEntity tile, double distance, double power, LinkedList<BlockPos> tileLocations, List<IWorldEdit> edits) {
        power = this.rayTraceBlocks(this.toPos().toVec3(), Vec3.func_72443_a((double)((double)tile.field_145851_c + 0.5), (double)((double)tile.field_145848_d + 0.5), (double)((double)tile.field_145849_e + 0.5)), power, tileLocations, edits, true);
        return this.handle(tile, distance, power, edits, true);
    }

    protected double handle(TileEntity tile, double distance, double power, List<IWorldEdit> edits, boolean doEdits) {
        if (power > 1.0) {
            IWorldEdit edit = null;
            double powerUsed = 0.0;
            if (tile instanceof IEMReceptiveDevice) {
                powerUsed = ((IEMReceptiveDevice)tile).onElectromagneticRadiationApplied(this, distance, power, false);
                if (doEdits) {
                    edit = this.doEMP((IEMReceptiveDevice)tile, distance, power);
                }
            } else if (UniversalEnergySystem.isHandler(tile, null) && doEdits) {
                edit = this.drainEnergy(tile, distance, power);
            }
            if (edit != null) {
                edits.add(edit);
            }
            return powerUsed < power ? power - powerUsed : 0.0;
        }
        return power;
    }

    protected IWorldEdit doEMPInventory(TileEntity tile, double distance, double power) {
        return null;
    }

    protected boolean inventoryContainsElectricItems(IInventory inventory) {
        return false;
    }

    protected IWorldEdit doEMPInventory(Entity tile, double distance, double power) {
        return null;
    }

    protected IWorldEdit doEMP(IEMReceptiveDevice tile, double distance, double power) {
        return new EmpEdit(new Location((TileEntity)tile), this, distance, power);
    }

    protected IWorldEdit drainEnergy(TileEntity tile, double distance, double power) {
        return new EmpDrainEdit(new Location(tile), this, distance, power);
    }

    protected double getEMPRange() {
        return this.size;
    }

    protected double getPowerForRange(double distance) {
        if (distance == -1.0) {
            return Math.PI * (this.size * this.size * this.size);
        }
        return distance * 100.0;
    }

    @Override
    public void doStartAudio() {
        if (!this.oldWorld.field_72995_K) {
            this.oldWorld.func_72908_a(this.x, this.y, this.z, START_AUDIO, 0.2f + this.oldWorld.field_73012_v.nextFloat() * 0.2f, 0.9f + this.oldWorld.field_73012_v.nextFloat() * 0.15f);
        }
    }

    @Override
    public void doEndAudio() {
        if (!this.oldWorld.field_72995_K) {
            this.oldWorld.func_72908_a(this.x, this.y, this.z, END_AUDIO, 0.2f + this.oldWorld.field_73012_v.nextFloat() * 0.2f, 0.9f + this.oldWorld.field_73012_v.nextFloat() * 0.15f);
        }
    }

    @Override
    public void playAudioForEdit(IWorldEdit blocks) {
        if (!this.oldWorld.field_72995_K) {
            this.oldWorld.func_72908_a(blocks.x(), blocks.y(), blocks.z(), EDIT_AUDIO, 0.2f + this.oldWorld.field_73012_v.nextFloat() * 0.2f, 0.9f + this.oldWorld.field_73012_v.nextFloat() * 0.15f);
        }
    }

    public double rayTraceBlocks(Vec3 start, Vec3 end, double power, LinkedList<BlockPos> tileLocations, List<IWorldEdit> edits, boolean doEdits) {
        if (!(Double.isNaN(start.field_72450_a) || Double.isNaN(start.field_72448_b) || Double.isNaN(start.field_72449_c) || Double.isNaN(end.field_72450_a) || Double.isNaN(end.field_72448_b) || Double.isNaN(end.field_72449_c))) {
            int end_x = MathHelper.func_76128_c((double)end.field_72450_a);
            int end_y = MathHelper.func_76128_c((double)end.field_72448_b);
            int end_z = MathHelper.func_76128_c((double)end.field_72449_c);
            int xx = MathHelper.func_76128_c((double)start.field_72450_a);
            int yy = MathHelper.func_76128_c((double)start.field_72448_b);
            int zz = MathHelper.func_76128_c((double)start.field_72449_c);
            int k1 = 200;
            while (k1-- >= 0) {
                BlockPos pos;
                int b0;
                if (Double.isNaN(start.field_72450_a) || Double.isNaN(start.field_72448_b) || Double.isNaN(start.field_72449_c)) {
                    return power;
                }
                if (xx == end_x && yy == end_y && zz == end_z) {
                    return power;
                }
                boolean flag6 = true;
                boolean flag3 = true;
                boolean flag4 = true;
                double d0 = 999.0;
                double d1 = 999.0;
                double d2 = 999.0;
                if (end_x > xx) {
                    d0 = (double)xx + 1.0;
                } else if (end_x < xx) {
                    d0 = (double)xx + 0.0;
                } else {
                    flag6 = false;
                }
                if (end_y > yy) {
                    d1 = (double)yy + 1.0;
                } else if (end_y < yy) {
                    d1 = (double)yy + 0.0;
                } else {
                    flag3 = false;
                }
                if (end_z > zz) {
                    d2 = (double)zz + 1.0;
                } else if (end_z < zz) {
                    d2 = (double)zz + 0.0;
                } else {
                    flag4 = false;
                }
                double d3 = 999.0;
                double d4 = 999.0;
                double d5 = 999.0;
                double d6 = end.field_72450_a - start.field_72450_a;
                double d7 = end.field_72448_b - start.field_72448_b;
                double d8 = end.field_72449_c - start.field_72449_c;
                if (flag6) {
                    d3 = (d0 - start.field_72450_a) / d6;
                }
                if (flag3) {
                    d4 = (d1 - start.field_72448_b) / d7;
                }
                if (flag4) {
                    d5 = (d2 - start.field_72449_c) / d8;
                }
                if (d3 < d4 && d3 < d5) {
                    b0 = end_x > xx ? 4 : 5;
                    start.field_72450_a = d0;
                    start.field_72448_b += d7 * d3;
                    start.field_72449_c += d8 * d3;
                } else if (d4 < d5) {
                    b0 = end_y > yy ? 0 : 1;
                    start.field_72450_a += d6 * d4;
                    start.field_72448_b = d1;
                    start.field_72449_c += d8 * d4;
                } else {
                    b0 = end_z > zz ? 2 : 3;
                    start.field_72450_a += d6 * d5;
                    start.field_72448_b += d7 * d5;
                    start.field_72449_c = d2;
                }
                Vec3 vec32 = Vec3.func_72443_a((double)start.field_72450_a, (double)start.field_72448_b, (double)start.field_72449_c);
                vec32.field_72450_a = MathHelper.func_76128_c((double)start.field_72450_a);
                xx = (int)vec32.field_72450_a;
                if (b0 == 5) {
                    --xx;
                    vec32.field_72450_a += 1.0;
                }
                vec32.field_72448_b = MathHelper.func_76128_c((double)start.field_72448_b);
                yy = (int)vec32.field_72448_b;
                if (b0 == 1) {
                    --yy;
                    vec32.field_72448_b += 1.0;
                }
                vec32.field_72449_c = MathHelper.func_76128_c((double)start.field_72449_c);
                zz = (int)vec32.field_72449_c;
                if (b0 == 3) {
                    --zz;
                    vec32.field_72449_c += 1.0;
                }
                if (tileLocations.contains(pos = new BlockPos(xx, yy, zz))) {
                    tileLocations.remove(pos);
                }
                if (!(power > 0.0)) continue;
                power -= this.onPassThroughTile(this.oldWorld, pos, power, edits, doEdits);
            }
        }
        return power;
    }

    protected double onPassThroughTile(World world, BlockPos pos, double power, List<IWorldEdit> edits, boolean doEdits) {
        int meta;
        Block block = pos.getBlock(world);
        if (!this.canPassThrough(world, pos, block, meta = pos.getBlockMetadata(world))) {
            TileEntity tile = pos.getTileEntity(world);
            if (tile != null && !tile.func_145837_r()) {
                return power - this.handle(tile, pos.distance(this), power, edits, doEdits);
            }
            Material material = block.func_149688_o();
            if (material == Material.field_151573_f) {
                return 20.0;
            }
            if (material == Material.field_151576_e) {
                return 5.0;
            }
            return 1.0;
        }
        return 0.0;
    }

    public static double applyEmpEffect(IInventory inventory, Object host, IVoltageTransmitter source, double power, double distance) {
        if (power > 1.0) {
            for (int slot = 0; slot < inventory.func_70302_i_(); ++slot) {
                boolean held = host instanceof EntityPlayer && slot == ((EntityPlayer)host).field_71071_by.field_70461_c;
                BlastEMP.applyEmpEffect(host, inventory.func_70301_a(slot), slot, held, source, power, distance);
            }
        }
        return power;
    }

    public static double applyEmpEffect(Object host, ItemStack stack, int slot, boolean held, IVoltageTransmitter source, double power, double distance) {
        if (stack != null && stack.func_77973_b() != null) {
            Item item = stack.func_77973_b();
            if (item instanceof IEMInterferenceItem) {
                return ((IEMInterferenceItem)item).onElectromagneticRadiationApplied(stack, host, slot, held, distance, power, source, true);
            }
            if (UniversalEnergySystem.isHandler(stack, null)) {
                UniversalEnergySystem.drain(stack, 2.147483647E9, true);
                return power * 0.98;
            }
        }
        return power;
    }

    protected boolean canPassThrough(World world, BlockPos pos, Block block, int meta) {
        return !block.func_149662_c();
    }

    @Override
    public double getTotalVoltagePower() {
        return this.getPowerForRange(-1.0);
    }
}

