/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.core.content.entity.creeper;

import com.builtbroken.mc.api.event.TriggerCause;
import com.builtbroken.mc.api.explosive.IExCreeperHandler;
import com.builtbroken.mc.api.explosive.IExplosiveHandler;
import com.builtbroken.mc.api.explosive.IExplosiveHolder;
import com.builtbroken.mc.framework.explosive.ExplosiveRegistry;
import com.builtbroken.mc.imp.transform.vector.Location;
import com.builtbroken.mc.lib.helper.LanguageUtility;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class EntityExCreeper
extends EntityMob
implements IExplosiveHolder,
IEntityAdditionalSpawnData {
    protected int fuseTicks = 30;
    protected double ex_size = 3.0;
    protected IExplosiveHandler ex;
    protected NBTTagCompound ex_data;

    public EntityExCreeper(World w) {
        super(w);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
    }

    public EntityExCreeper(Location location, IExplosiveHandler ex, double size, NBTTagCompound tag) {
        this(location.world);
        this.func_70107_b(location.x(), location.y(), location.z());
        this.setExplosive(ex, size, tag);
    }

    public static void replaceCreeper(EntityCreeper creeper, IExplosiveHandler ex) {
        EntityExCreeper.replaceCreeper(creeper, ex, 2.0, null);
    }

    public static void replaceCreeper(EntityCreeper creeper, IExplosiveHandler ex, double size, NBTTagCompound data) {
        EntityExCreeper cex = new EntityExCreeper(new Location((Entity)creeper), ex, size, data);
        creeper.func_70106_y();
        creeper.field_70170_p.func_72900_e((Entity)creeper);
        cex.field_70170_p.func_72838_d((Entity)cex);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)-1);
    }

    public String func_70005_c_() {
        String translation;
        String s;
        if (this.func_94056_bM()) {
            return this.func_94057_bL();
        }
        if (this.ex instanceof IExCreeperHandler && (s = ((IExCreeperHandler)((Object)this.ex)).getTranslationKey((Entity)this)) != null && !s.isEmpty() && (translation = LanguageUtility.getLocal(s + ".name")) != null && !translation.isEmpty()) {
            return translation;
        }
        return LanguageUtility.getLocal("entity.creeper.name");
    }

    public void func_70071_h_() {
        if (this.func_70089_S()) {
            int f = this.getFuse();
            if (f > 0) {
                this.func_85030_a("creeper.primed", 1.0f, 0.5f);
            }
            if (this.func_70638_az() != null && this.func_70638_az().func_70068_e((Entity)this) < 9.0) {
                this.setFuse(f + 1);
            } else if (f > 1) {
                this.setFuse(f - 1);
            }
            if (f >= this.fuseTicks) {
                this.explode();
            }
        }
        super.func_70071_h_();
    }

    public boolean func_70652_k(Entity entity) {
        return true;
    }

    @Override
    public IExplosiveHandler getExplosive() {
        return this.ex;
    }

    @Override
    public boolean setExplosive(IExplosiveHandler ex, double size, NBTTagCompound nbt) {
        this.ex_size = size;
        this.ex = ex;
        this.ex_data = nbt;
        return true;
    }

    @Override
    public NBTTagCompound getAdditionalExplosiveData() {
        return this.ex_data;
    }

    @Override
    public double getExplosiveSize() {
        return this.ex_size;
    }

    protected void explode() {
        if (!this.field_70170_p.field_72995_K) {
            boolean allow_mob_damage = this.field_70170_p.func_82736_K().func_82766_b("mobGriefing");
            if (this.ex == null) {
                this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 3.0f, allow_mob_damage);
            } else {
                ExplosiveRegistry.triggerExplosive(new Location((Entity)this), this.ex, new TriggerCause.TriggerCauseEntity((Entity)this), this.ex_size, this.ex_data);
            }
            this.func_70106_y();
        }
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74777_a("Fuse", (short)this.fuseTicks);
        if (this.ex != null) {
            nbt.func_74778_a("ex", this.ex.getID());
            nbt.func_74780_a("size", this.ex_size);
            if (this.ex_data != null) {
                nbt.func_74782_a("ex_data", (NBTBase)this.ex_data);
            }
        }
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.fuseTicks = nbt.func_74765_d("Fuse");
        if (nbt.func_74764_b("ex")) {
            this.ex = ExplosiveRegistry.get(nbt.func_74779_i("ex"));
            this.ex_size = Math.max(nbt.func_74769_h("size"), 1.0);
            if (nbt.func_74764_b("ex_data")) {
                this.ex_data = nbt.func_74775_l("ex_data");
            }
        }
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeBoolean(this.ex != null);
        if (this.ex != null) {
            ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.ex.getID());
            if (this.ex_data != null) {
                ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)this.ex_data);
            } else {
                ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)new NBTTagCompound());
            }
        }
    }

    public void readSpawnData(ByteBuf buffer) {
        boolean ex_exists = buffer.readBoolean();
        if (ex_exists) {
            this.ex = ExplosiveRegistry.get(ByteBufUtils.readUTF8String((ByteBuf)buffer));
            this.ex_data = ByteBufUtils.readTag((ByteBuf)buffer);
        } else {
            this.ex = null;
            this.ex_data = null;
        }
    }

    public int getFuse() {
        return this.field_70180_af.func_75683_a(16);
    }

    public void setFuse(int f) {
        this.field_70180_af.func_75692_b(16, (Object)((byte)f));
    }

    protected String func_70621_aR() {
        return "mob.creeper.say";
    }

    protected String func_70673_aS() {
        return "mob.creeper.death";
    }

    public boolean func_70650_aV() {
        return true;
    }

    public int func_82143_as() {
        return this.func_70638_az() == null ? 3 : 3 + (int)(this.func_110143_aJ() - 1.0f);
    }
}

