/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.core.network.packet.callback;

import com.builtbroken.mc.api.abstraction.world.IWorld;
import com.builtbroken.mc.api.data.IPacket;
import com.builtbroken.mc.core.Engine;
import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public class PacketAudio
implements IPacket {
    int dim;
    double x;
    double y;
    double z;
    float pitch;
    float volume;
    String audioKey;

    public PacketAudio() {
    }

    public PacketAudio(World world, String key, double x, double y, double z, float pitch, float volume) {
        this.dim = world != null && world.field_73011_w != null ? world.field_73011_w.field_76574_g : 0;
        this.audioKey = key;
        this.x = x;
        this.y = y;
        this.z = z;
        this.pitch = pitch;
        this.volume = volume;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeInt(this.dim);
        buffer.writeDouble(this.x);
        buffer.writeDouble(this.y);
        buffer.writeDouble(this.z);
        buffer.writeFloat(this.pitch);
        buffer.writeFloat(this.volume);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.audioKey);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.dim = buffer.readInt();
        this.x = buffer.readDouble();
        this.y = buffer.readDouble();
        this.z = buffer.readDouble();
        this.pitch = buffer.readFloat();
        this.volume = buffer.readFloat();
        this.audioKey = ByteBufUtils.readUTF8String((ByteBuf)buffer);
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        IWorld world = Engine.minecraft.getWorld(this.dim);
        if (world != null) {
            world.playAudio(this.audioKey, this.x, this.y, this.z, this.pitch, this.volume);
        }
    }
}

