/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.core.network.packet.callback.chunk;

import com.builtbroken.mc.api.data.IPacket;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.core.network.packet.callback.chunk.PacketSendData;
import com.builtbroken.mc.lib.world.map.block.ExtendedBlockDataManager;
import com.builtbroken.mc.lib.world.map.block.ExtendedBlockDataMap;
import com.builtbroken.mc.lib.world.map.data.s.ChunkDataShort;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public class PacketRequestData
implements IPacket {
    int dim;
    int x;
    int z;
    int type;

    public PacketRequestData() {
    }

    public PacketRequestData(int dim, int x, int z, int type) {
        this.dim = dim;
        this.x = x;
        this.z = z;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeInt(this.dim);
        buffer.writeInt(this.x);
        buffer.writeInt(this.z);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.dim = buffer.readInt();
        this.x = buffer.readInt();
        this.z = buffer.readInt();
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            ChunkDataShort data = null;
            if (this.type == 0) {
                ExtendedBlockDataMap map = (ExtendedBlockDataMap)ExtendedBlockDataManager.SERVER.getMapForDim(this.dim, false);
                if (map != null) {
                    data = (ChunkDataShort)map.getChunk(this.x, this.z);
                }
                if (data == null) {
                    data = new ChunkDataShort(this.x, this.z);
                }
            }
            if (data != null) {
                Engine.packetHandler.sendToPlayer(new PacketSendData(this.dim, this.x, this.z, this.type, data), (EntityPlayerMP)player);
            }
        }
    }
}

