/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.debug.gui.panels.imp;

import com.builtbroken.mc.debug.component.DebugDataCellRenderer;
import com.builtbroken.mc.debug.data.IJsonDebugData;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public abstract class PanelDataList<D>
extends JPanel {
    protected final DefaultListModel<IJsonDebugData> dataModel = new DefaultListModel();
    protected final List<D> data = new ArrayList<D>();

    public PanelDataList() {
        this.setLayout(new BorderLayout());
        JPanel menuPanel = new JPanel();
        menuPanel.setMaximumSize(new Dimension(-1, 100));
        Button button = new Button("Reload");
        button.addActionListener(e -> {
            this.dataModel.clear();
            this.reload(null);
        });
        menuPanel.add(button);
        JTextField searchBox = new JTextField();
        searchBox.setMinimumSize(new Dimension(200, -1));
        searchBox.setPreferredSize(new Dimension(200, 30));
        searchBox.setToolTipText("Search filter for current open tab");
        menuPanel.add(searchBox);
        button = new Button("Search");
        button.addActionListener(e -> {
            this.dataModel.clear();
            this.reload(searchBox.getText().trim());
        });
        menuPanel.add(button);
        this.add((Component)menuPanel, "North");
        final JList<IJsonDebugData> dataLogList = new JList<IJsonDebugData>(this.dataModel);
        dataLogList.setLayoutOrientation(0);
        dataLogList.setCellRenderer(new DebugDataCellRenderer());
        dataLogList.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                IJsonDebugData data;
                Point p;
                JList table = (JList)me.getSource();
                int row = table.locationToIndex(p = me.getPoint());
                if (row != -1 && me.getClickCount() == 2 && (data = (IJsonDebugData)dataLogList.getModel().getElementAt(row)) != null) {
                    data.onDoubleClicked();
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewportView(dataLogList);
        scrollPane.setVerticalScrollBarPolicy(22);
        scrollPane.setPreferredSize(new Dimension(this.getWidth() - 100, this.getHeight() - 100));
        scrollPane.setMinimumSize(new Dimension(this.getWidth() - 100, this.getHeight() - 100));
        this.add((Component)scrollPane, "Center");
    }

    protected void reload(String filter) {
        this.buildData();
        for (D object : this.data) {
            IJsonDebugData debugData;
            if (object == null || !this.shouldDisplay(object, filter) || (debugData = this.getDataEntryFor(object)) == null) continue;
            this.dataModel.addElement(debugData);
        }
    }

    protected boolean shouldDisplay(D object, String filter) {
        return filter == null || filter.isEmpty() || object.toString().contains(filter);
    }

    protected abstract IJsonDebugData getDataEntryFor(D var1);

    protected abstract void buildData();
}

