/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.framework.access;

import com.builtbroken.jlib.type.Group;
import com.builtbroken.mc.api.ISave;
import com.builtbroken.mc.framework.access.AccessUser;
import com.builtbroken.mc.framework.access.perm.Permission;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class AccessGroup
implements ISave,
Cloneable {
    private String name;
    protected long creation_time;
    protected Set<String> nodes = new LinkedHashSet<String>();
    protected AccessGroup extendGroup;
    protected String extendGroup_name;
    protected final HashMap<String, AccessUser> username_to_profile = new HashMap();
    protected final HashMap<UUID, AccessUser> uuid_to_profile = new HashMap();

    public AccessGroup(String group_name, AccessUser ... users) {
        this.name = group_name;
        this.creation_time = System.currentTimeMillis();
        for (AccessUser user : users) {
            this.addMember(user);
        }
    }

    public AccessUser getMember(String username) {
        if (this.username_to_profile.containsKey(username)) {
            return this.username_to_profile.get(username);
        }
        return null;
    }

    public AccessUser getMember(EntityPlayer player) {
        if (player != null) {
            UUID id = player.func_146103_bH().getId();
            if (this.uuid_to_profile.containsKey(id)) {
                return this.uuid_to_profile.get(id);
            }
            if (this.username_to_profile.containsKey(player.func_70005_c_())) {
                return this.username_to_profile.get(player.func_70005_c_());
            }
        }
        return null;
    }

    public boolean addMember(AccessUser obj) {
        if (this.isValid(obj)) {
            if (obj.getUserID() != null) {
                this.uuid_to_profile.put(obj.getUserID(), obj);
            }
            this.username_to_profile.put(obj.username, obj);
            obj.setGroup(this);
            return true;
        }
        return false;
    }

    @Deprecated
    public boolean addMember(String name) {
        return this.getMember(name) == null && this.addMember(new AccessUser(name));
    }

    public boolean addMember(EntityPlayer player) {
        return player != null && this.addMember(new AccessUser(player));
    }

    public boolean removeMember(EntityPlayer player) {
        return player != null && this.removeMember(player.func_146103_bH().getId());
    }

    public boolean removeMember(String name) {
        return this.removeMember(this.getMember(name));
    }

    public boolean removeMember(AccessUser user) {
        if (user != null && this.username_to_profile.containsKey(user.getName())) {
            this.username_to_profile.remove(user.username);
            if (user.getUserID() != null) {
                this.uuid_to_profile.remove(user.getUserID());
            }
            return true;
        }
        return false;
    }

    public boolean removeMember(UUID id) {
        if (this.uuid_to_profile.containsKey(id)) {
            return this.removeMember(this.uuid_to_profile.get(id));
        }
        return false;
    }

    @Override
    public NBTTagCompound save(NBTTagCompound nbt) {
        nbt.func_74778_a("groupName", this.getName());
        if (this.extendGroup_name != null) {
            nbt.func_74778_a("extendGroup", this.extendGroup_name);
        }
        NBTTagList usersTag = new NBTTagList();
        for (AccessUser user : this.username_to_profile.values()) {
            NBTTagCompound accessData = new NBTTagCompound();
            user.save(accessData);
            usersTag.func_74742_a((NBTBase)accessData);
        }
        nbt.func_74782_a("users", (NBTBase)usersTag);
        NBTTagList nodesTag = new NBTTagList();
        for (String str : this.nodes) {
            NBTTagCompound accessData = new NBTTagCompound();
            accessData.func_74778_a("name", str);
            nodesTag.func_74742_a((NBTBase)accessData);
        }
        nbt.func_74782_a("permissions", (NBTBase)nodesTag);
        nbt.func_74772_a("creationDate", this.creation_time);
        return nbt;
    }

    @Override
    public void load(NBTTagCompound nbt) {
        this.setName(nbt.func_74779_i("groupName"));
        if (nbt.func_74764_b("extendGroup")) {
            this.extendGroup_name = nbt.func_74779_i("extendGroup");
        }
        NBTTagList userList = nbt.func_150295_c("users", 10);
        this.getMembers().clear();
        for (int i = 0; i < userList.func_74745_c(); ++i) {
            AccessUser user = AccessUser.loadFromNBT(userList.func_150305_b(i));
            this.addMember(user);
        }
        NBTTagList nodeList = nbt.func_150295_c("permissions", 10);
        this.nodes.clear();
        for (int i = 0; i < nodeList.func_74745_c(); ++i) {
            this.nodes.add(nodeList.func_150305_b(i).func_74779_i("name"));
        }
        this.creation_time = nbt.func_74764_b("creationDate") ? nbt.func_74763_f("creationDate") : System.currentTimeMillis();
    }

    public boolean hasNode(String node) {
        return this.hasExactNode(node) || this.hasNodeInGroup(node) || this.getExtendGroup() != null && this.getExtendGroup().hasNode(node);
    }

    public boolean hasNode(Permission node) {
        return this.hasNode(node.toString());
    }

    public boolean hasNodeInGroup(String node) {
        String tempNode = node.replace(".*", "");
        for (String groupNode : this.nodes) {
            String headNode = groupNode.replace(".*", "");
            if (!tempNode.startsWith(headNode)) continue;
            return true;
        }
        return false;
    }

    public boolean hasExactNode(String node) {
        return this.nodes.contains(node);
    }

    public void addNode(String node) {
        this.nodes.add(node);
    }

    public void addNode(Permission node) {
        this.addNode(node.toString());
    }

    public void removeNode(String node) {
        if (this.nodes.contains(node)) {
            this.nodes.remove(node);
        }
    }

    public boolean setToExtend(AccessGroup group) {
        if (!this.isParent(group)) {
            this.extendGroup = group;
            if (this.extendGroup != null) {
                this.extendGroup_name = this.extendGroup.getName();
            }
            return true;
        }
        return false;
    }

    public boolean isParent(AccessGroup group) {
        if (group == this) {
            return true;
        }
        if (group != null && group.getExtendGroup() != null) {
            return group.getExtendGroup() == this || this.isParent(group.getExtendGroup());
        }
        return false;
    }

    public AccessGroup getExtendGroup() {
        return this.extendGroup;
    }

    public String getExtendGroupName() {
        return this.extendGroup_name;
    }

    public Set<String> getNodes() {
        return this.nodes;
    }

    public Collection<AccessUser> getMembers() {
        return this.username_to_profile.values();
    }

    protected boolean isValid(AccessUser obj) {
        return obj != null && obj.username != null && !this.getMembers().contains(obj);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AccessGroup clone() {
        AccessGroup group = new AccessGroup(this.getName(), new AccessUser[0]);
        for (String node : this.getNodes()) {
            group.getNodes().add(node);
        }
        return group;
    }

    public boolean equals(Object obj) {
        return obj instanceof Group && ((Group)obj).getName().equalsIgnoreCase(this.getName());
    }

    public String toString() {
        return "[Group:" + this.getName() + "]";
    }
}

