/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.framework.access.global;

import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.core.handler.SaveManager;
import com.builtbroken.mc.framework.access.AccessUtility;
import com.builtbroken.mc.framework.access.global.GlobalAccessProfile;
import com.builtbroken.mc.framework.mod.loadable.AbstractLoadable;
import com.builtbroken.mc.lib.helper.NBTUtility;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;

public final class GlobalAccessSystem
extends AbstractLoadable {
    private static final HashMap<String, GlobalAccessProfile> id_to_profiles = new HashMap();
    public static final GlobalAccessSystem instance = new GlobalAccessSystem();
    private int ticks = 0;

    public static GlobalAccessProfile getOrCreateProfile(String name, boolean defaultGroups) {
        GlobalAccessProfile p = GlobalAccessSystem.getProfile(name);
        if (p == null) {
            p = GlobalAccessSystem.createProfile(name, defaultGroups);
        }
        return p;
    }

    public static GlobalAccessProfile getProfile(String id) {
        if (id_to_profiles.containsKey(id) && id_to_profiles.get(id) != null) {
            return id_to_profiles.get(id);
        }
        return GlobalAccessSystem.loadProfile(id, false);
    }

    public static GlobalAccessProfile createProfile(String name, boolean defaultGroups) {
        GlobalAccessProfile profile = new GlobalAccessProfile();
        if (defaultGroups) {
            AccessUtility.loadNewGroupSet(profile);
        }
        profile.initName(name.trim(), "P_" + name + "_" + System.nanoTime());
        if (!id_to_profiles.containsKey(name) || id_to_profiles.get(name) == null) {
            id_to_profiles.put(profile.getID(), profile);
        }
        SaveManager.register(profile);
        return profile;
    }

    protected static GlobalAccessProfile loadProfile(String id, boolean create) {
        Engine.logger().info("GlobalAccessSystem: Loading a profile[" + id + "] from disk");
        NBTTagCompound tag = NBTUtility.loadData(GlobalAccessProfile.getPathToProfile(id));
        if (!tag.func_82582_d()) {
            GlobalAccessProfile profile = new GlobalAccessProfile();
            profile.load(tag);
            if (profile.getID() != null && profile.getName() != null) {
                id_to_profiles.put(profile.getID(), profile);
                if (id_to_profiles.containsKey(id) && id_to_profiles.get(id) != null) {
                    Engine.logger().error("GlobalAccessSystem: Loading a profile over an existing profile[" + id + ", " + id_to_profiles.get(id) + "] with " + profile);
                }
                SaveManager.register(profile);
            } else {
                Engine.logger().error("GlobalAccessSystem: Profile was invalid due to not containing id and name, skipping loading.");
            }
            return profile;
        }
        if (create) {
            return GlobalAccessSystem.createProfile(id, true);
        }
        return null;
    }

    public static List<GlobalAccessProfile> getProfilesFor(EntityPlayer player) {
        ArrayList<GlobalAccessProfile> profiles = new ArrayList<GlobalAccessProfile>();
        for (String name : id_to_profiles.keySet()) {
            GlobalAccessProfile profile;
            if (name == null || (profile = GlobalAccessSystem.getProfile(name)) == null || !profile.containsUser(player)) continue;
            profiles.add(profile);
        }
        return profiles;
    }

    public static Collection<GlobalAccessProfile> getProfiles() {
        return id_to_profiles.values();
    }

    private GlobalAccessSystem() {
    }

    @Override
    public void preInit() {
        MinecraftForge.EVENT_BUS.register((Object)instance);
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.world.field_73011_w.field_76574_g == 0) {
            ++this.ticks;
            if (this.ticks % 6000 == 0) {
                this.cleanup();
            }
        }
    }

    public void cleanup() {
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        File folder;
        if (event.world.field_73011_w.field_76574_g == 0 && !event.world.field_72995_K && MinecraftServer.func_71276_C() != null && (folder = new File(NBTUtility.getSaveDirectory(MinecraftServer.func_71276_C().func_71270_I()), "bbm/access/profiles/")).exists()) {
            File[] files;
            for (File file : files = folder.listFiles()) {
                NBTTagCompound tag;
                if (!file.getName().endsWith(".dat") || (tag = NBTUtility.loadData(file)).func_82582_d()) continue;
                GlobalAccessProfile profile = new GlobalAccessProfile();
                profile.load(tag);
                if (profile.getID() == null || profile.getName() == null) continue;
                id_to_profiles.put(profile.getID(), profile);
                SaveManager.register(profile);
            }
        }
    }
}

